/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio;

import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinEdge;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.wiringpi.Gpio;
import com.pi4j.wiringpi.GpioInterrupt;
import com.pi4j.wiringpi.GpioInterruptEvent;
import com.pi4j.wiringpi.GpioInterruptListener;
import com.pi4j.wiringpi.GpioUtil;

public class RaspiGpioProvider
extends GpioProviderBase
implements GpioProvider,
GpioInterruptListener {
    public static final String NAME = "RaspberryPi GPIO Provider";

    public RaspiGpioProvider() {
        Gpio.wiringPiSetup();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean hasPin(Pin pin) {
        return Gpio.wpiPinToGpio(pin.getAddress()) >= 0;
    }

    @Override
    public void export(Pin pin, PinMode mode) {
        super.export(pin, mode);
        GpioUtil.export(pin.getAddress(), mode.getDirection().getValue());
        this.setMode(pin, mode);
    }

    @Override
    public boolean isExported(Pin pin) {
        super.isExported(pin);
        return GpioUtil.isExported(pin.getAddress());
    }

    @Override
    public void unexport(Pin pin) {
        super.unexport(pin);
        GpioUtil.unexport(pin.getAddress());
    }

    @Override
    public void setMode(Pin pin, PinMode mode) {
        super.setMode(pin, mode);
        Gpio.pinMode(pin.getAddress(), mode.getValue());
        if (PinMode.allInputs().contains((Object)mode)) {
            GpioUtil.setEdgeDetection(pin.getAddress(), PinEdge.BOTH.getValue());
        }
    }

    @Override
    public PinMode getMode(Pin pin) {
        return super.getMode(pin);
    }

    @Override
    public void setPullResistance(Pin pin, PinPullResistance resistance) {
        super.setPullResistance(pin, resistance);
        Gpio.pullUpDnControl(pin.getAddress(), resistance.getValue());
    }

    @Override
    public PinPullResistance getPullResistance(Pin pin) {
        return super.getPullResistance(pin);
    }

    @Override
    public void setState(Pin pin, PinState state) {
        super.setState(pin, state);
        Gpio.digitalWrite(pin.getAddress(), state.getValue());
    }

    @Override
    public PinState getState(Pin pin) {
        super.getState(pin);
        PinState state = null;
        int ret = Gpio.digitalRead(pin.getAddress());
        if (ret >= 0) {
            state = PinState.getState(ret);
        }
        return state;
    }

    @Override
    public void setValue(Pin pin, double value) {
        super.setValue(pin, value);
        throw new RuntimeException("This GPIO provider does not support analog pins.");
    }

    @Override
    public double getValue(Pin pin) {
        super.getValue(pin);
        throw new RuntimeException("This GPIO provider does not support analog pins.");
    }

    @Override
    public void setPwm(Pin pin, int value) {
        super.setPwm(pin, value);
        if (this.getMode(pin) == PinMode.PWM_OUTPUT) {
            this.setPwmValue(pin, value);
        }
    }

    @Override
    public int getPwm(Pin pin) {
        return super.getPwm(pin);
    }

    private void setPwmValue(Pin pin, int value) {
        Gpio.pwmWrite(pin.getAddress(), value);
    }

    @Override
    public void pinStateChange(GpioInterruptEvent event) {
        for (Pin pin : this.listeners.keySet()) {
            if (pin.getAddress() != event.getPin()) continue;
            this.dispatchPinDigitalStateChangeEvent(pin, PinState.getState(event.getState()));
        }
    }

    @Override
    public void addListener(Pin pin, PinListener listener) {
        super.addListener(pin, listener);
        this.updateInterruptListener(pin);
    }

    @Override
    public void removeListener(Pin pin, PinListener listener) {
        super.removeListener(pin, listener);
        this.updateInterruptListener(pin);
    }

    private void updateInterruptListener(Pin pin) {
        if (this.listeners.size() > 0) {
            if (!GpioInterrupt.hasListener(this)) {
                GpioInterrupt.addListener(this);
            }
            GpioInterrupt.enablePinStateChangeCallback(pin.getAddress());
        } else {
            GpioInterrupt.disablePinStateChangeCallback(pin.getAddress());
            if (GpioInterrupt.hasListener(this)) {
                GpioInterrupt.removeListener(this);
            }
        }
    }
}

