/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.Config;
import bluej.prefmgr.PrefMgr;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class BlueJTheme
extends DefaultMetalTheme {
    private final FontUIResource controlFont = new FontUIResource(PrefMgr.getStandardFont());
    private final FontUIResource systemFont = new FontUIResource(this.controlFont);
    private final FontUIResource userFont = new FontUIResource(this.controlFont);
    private final FontUIResource menuFont = new FontUIResource(PrefMgr.getStandardMenuFont());
    private static final String SMALL_ICON_SUFFIX = "-icon-32.png";
    private static final String MEDIUM_ICON_SUFFIX = "-icon-48.png";
    private static final String LARGE_ICON_SUFFIX = "-icon-256.png";
    private static Image iconImage = null;
    private static String okayLabel;
    private static String cancelLabel;
    private static String closeLabel;
    private static String continueLabel;
    private static Dimension okCancelDimension;
    public static final int splitPaneDividerWidth = 3;
    public static final int generalSpacingWidth = 5;
    public static final Border generalBorder;
    public static final Border generalBorderWithStatusBar;
    public static final Border dialogBorder;
    public static final int commandButtonSpacing = 5;
    public static final int commandButtonPadding = 12;
    public static final int componentSpacingSmall = 5;
    public static final int componentSpacingLarge = 11;
    public static final int dialogCommandButtonsVertical = 17;

    @Override
    public String getName() {
        return "BlueJTheme";
    }

    @Override
    public FontUIResource getControlTextFont() {
        return this.controlFont;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return this.systemFont;
    }

    @Override
    public FontUIResource getUserTextFont() {
        return this.userFont;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return this.menuFont;
    }

    public static Image getIconImage() {
        String appName = Config.getApplicationName().toLowerCase();
        return BlueJTheme.getApplicationIcon(appName);
    }

    public static Image getApplicationIcon(String baseName) {
        if (Config.isMacOS()) {
            return null;
        }
        if (iconImage == null) {
            iconImage = Config.isModernWinOS() ? Config.getFixedImageAsIcon(baseName + LARGE_ICON_SUFFIX).getImage() : (Config.isWinOS() ? Config.getFixedImageAsIcon(baseName + SMALL_ICON_SUFFIX).getImage() : Config.getFixedImageAsIcon(baseName + MEDIUM_ICON_SUFFIX).getImage());
        }
        return iconImage;
    }

    public static void setIconImage(Image newIconImage) {
        iconImage = newIconImage;
    }

    public static String getOkLabel() {
        if (okayLabel == null) {
            okayLabel = Config.getString("okay");
        }
        return okayLabel;
    }

    public static String getCancelLabel() {
        if (cancelLabel == null) {
            cancelLabel = Config.getString("cancel");
        }
        return cancelLabel;
    }

    public static String getCloseLabel() {
        if (closeLabel == null) {
            closeLabel = Config.getString("close");
        }
        return closeLabel;
    }

    public static String getContinueLabel() {
        if (continueLabel == null) {
            continueLabel = Config.getString("continue");
        }
        return continueLabel;
    }

    public static JButton getOkButton() {
        BlueJTheme.computeButtonWidths();
        JButton okButton = new JButton(BlueJTheme.getOkLabel());
        okButton.setPreferredSize(okCancelDimension);
        return okButton;
    }

    public static JButton getCancelButton() {
        BlueJTheme.computeButtonWidths();
        JButton cancelButton = new JButton(BlueJTheme.getCancelLabel());
        cancelButton.setPreferredSize(okCancelDimension);
        return cancelButton;
    }

    public static JButton getCloseButton() {
        BlueJTheme.computeButtonWidths();
        JButton closeButton = new JButton(BlueJTheme.getCloseLabel());
        closeButton.setPreferredSize(okCancelDimension);
        return closeButton;
    }

    public static JButton getContinueButton() {
        BlueJTheme.computeButtonWidths();
        JButton continueButton = new JButton(BlueJTheme.getContinueLabel());
        continueButton.setPreferredSize(okCancelDimension);
        return continueButton;
    }

    private static void computeButtonWidths() {
        if (okCancelDimension != null) {
            return;
        }
        JButton okButton = new JButton(BlueJTheme.getOkLabel());
        JButton cancelButton = new JButton(BlueJTheme.getCancelLabel());
        JButton continueButton = new JButton(BlueJTheme.getContinueLabel());
        int maxWidth = Math.max(cancelButton.getPreferredSize().width, okButton.getPreferredSize().width);
        maxWidth = Math.max(maxWidth, continueButton.getPreferredSize().width);
        okCancelDimension = new Dimension(maxWidth, okButton.getPreferredSize().height);
    }

    static {
        generalBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        generalBorderWithStatusBar = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        dialogBorder = BorderFactory.createEmptyBorder(12, 12, 12, 12);
    }
}

