/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.jdi.JdiField;
import bluej.debugger.jdi.JdiUtils;
import bluej.utility.Debug;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;

public class JdiClass
extends DebuggerClass {
    ReferenceType remoteClass;
    List<Field> staticFields;

    public JdiClass(ReferenceType remoteClass) {
        this.remoteClass = remoteClass;
        this.getRemoteFields();
    }

    @Override
    public String getName() {
        return this.remoteClass.name();
    }

    @Override
    public List<DebuggerField> getStaticFields() {
        List<Field> visibleFields = this.remoteClass.visibleFields();
        ArrayList<DebuggerField> rlist = new ArrayList<DebuggerField>(this.staticFields.size());
        for (Field field : this.staticFields) {
            rlist.add(new JdiField(field, null, !visibleFields.contains(field)));
        }
        return rlist;
    }

    @Override
    public boolean isInterface() {
        return this.remoteClass instanceof InterfaceType;
    }

    @Override
    public boolean isEnum() {
        if (this.remoteClass instanceof ClassType) {
            return JdiUtils.getJdiUtils().isEnum((ClassType)this.remoteClass);
        }
        return false;
    }

    private void getRemoteFields() {
        this.staticFields = new ArrayList<Field>();
        if (this.remoteClass != null) {
            List<Field> allFields = this.remoteClass.allFields();
            for (int i = 0; i < allFields.size(); ++i) {
                Field field = allFields.get(i);
                if (!field.isStatic()) continue;
                this.staticFields.add(field);
            }
        } else {
            Debug.reportError("cannot get fields for remote class");
        }
    }
}

