/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.TextType;
import bluej.debugmgr.CallDialogWatcher;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.objectbench.ObjectBenchEvent;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.debugmgr.objectbench.ObjectBenchListener;
import bluej.utility.ComponentFactory;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.GrowableBox;
import bluej.utility.MultiLineLabel;
import bluej.views.CallableView;
import bluej.views.TypeParamView;
import bluej.views.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public abstract class CallDialog
extends EscapeDialog
implements ObjectBenchListener,
FocusListener {
    protected static final Insets INSETS = new Insets(2, 2, 2, 2);
    protected static final String emptyFieldMsg = Config.getString("error.methodCall.emptyField");
    protected static final String emptyTypeFieldMsg = Config.getString("error.methodCall.emptyTypeField");
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private MultiLineLabel errorLabel;
    protected ParameterList parameterList;
    protected ParameterList typeParameterList;
    private ObjectBenchInterface bench;
    private CallDialogWatcher watcher;
    private boolean listeningObjects;
    protected JButton okButton;
    protected String defaultParamValue = "";
    private JPanel descPanel;
    private JTextField focusedTextField;
    protected CallHistory history;

    public CallDialog(JFrame parentFrame, ObjectBenchInterface objectBench, String title) {
        super(parentFrame, title, false);
        this.bench = objectBench;
    }

    public abstract void doOk();

    public void doCancel() {
        this.callWatcher(1);
    }

    public void setWatcher(CallDialogWatcher w) {
        this.watcher = w;
    }

    public void callWatcher(int event) {
        if (this.watcher != null) {
            this.watcher.callDialogEvent(this, event);
        }
    }

    public void setWaitCursor(boolean wait) {
        if (wait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected MultiLineLabel getErrorLabel() {
        if (this.errorLabel == null) {
            this.errorLabel = new MultiLineLabel("\n\n", 0.0f);
            this.errorLabel.setForeground(new Color(136, 56, 56));
        }
        return this.errorLabel;
    }

    protected ObjectBenchInterface getObjectBench() {
        return this.bench;
    }

    protected void startObjectBenchListening() {
        if (!this.listeningObjects && this.bench != null) {
            this.bench.addObjectBenchListener(this);
            this.listeningObjects = true;
        }
    }

    protected void stopObjectBenchListening() {
        if (this.listeningObjects && this.bench != null) {
            this.bench.removeObjectBenchListener(this);
            this.listeningObjects = false;
        }
    }

    public void setErrorMessage(String message) {
        int index = message.indexOf("location:");
        if (index != -1) {
            message = message.substring(0, index - 1);
        }
        this.errorLabel.setText(message);
        this.pack();
        this.invalidate();
        this.validate();
    }

    @Override
    public void objectEvent(ObjectBenchEvent obe) {
        NamedValue value = obe.getValue();
        this.insertText(value.getName());
    }

    protected void makeDialog(JComponent topComponent, JComponent centerComponent) {
        JPanel contentPane = (JPanel)this.getContentPane();
        JPanel buttonPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            buttonPanel.setOpaque(false);
        }
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = BlueJTheme.getOkButton();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallDialog.this.doOk();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallDialog.this.doCancel();
            }
        });
        DialogManager.addOKCancelButtons(buttonPanel, this.okButton, cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.setBorder(BlueJTheme.generalBorder);
        if (topComponent != null) {
            contentPane.add((Component)topComponent, "North");
        }
        if (centerComponent != null) {
            contentPane.add((Component)centerComponent, "Center");
        }
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        DialogManager.centreDialog(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                CallDialog.this.setVisible(false);
            }
        });
    }

    public static TypeParamView[] getFormalTypeParams(CallableView callable) {
        View clazz = callable.getDeclaringView();
        return clazz.getTypeParams();
    }

    protected double getComboBoxHeight() {
        JComboBox comboBox = this.createComboBox(new ArrayList<String>());
        double comboHeight = comboBox.getPreferredSize().getHeight();
        return comboHeight;
    }

    protected JComboBox createComboBox(List<String> history) {
        if (history == null) {
            history = new ArrayList<String>();
        }
        JComboBox<Object> component = new JComboBox<Object>(history.toArray());
        component.insertItemAt(this.defaultParamValue, 0);
        component.setEditable(true);
        Dimension prefSize = component.getPreferredSize();
        if (prefSize.width < 100) {
            prefSize.width = 100;
            component.setPreferredSize(prefSize);
        }
        component.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallDialog.this.doOk();
            }
        });
        ((JTextField)component.getEditor().getEditorComponent()).addFocusListener(this);
        return component;
    }

    protected void setPreferredHeight(JComponent c, double height) {
        int lastTypeWidth = (int)c.getPreferredSize().getWidth();
        c.setPreferredSize(new Dimension(lastTypeWidth, (int)height));
    }

    protected JPanel createParameterPanel() {
        CallableView method = this.getCallableView();
        Class<?>[] paramClasses = this.getArgTypes(false);
        String[] paramNames = method.getParamNames();
        String[] paramTypes = method.getParamTypeStrings();
        this.parameterList = new ParameterList(paramClasses.length, this.defaultParamValue, method.isVarArgs());
        for (int i = 0; i < paramTypes.length; ++i) {
            JComponent component;
            List<String> historyList;
            String paramString = paramTypes[i];
            if (paramNames != null) {
                paramString = paramString + " " + paramNames[i];
            }
            if (method.isVarArgs() && i == paramClasses.length - 1) {
                historyList = this.history.getHistory(paramClasses[i].getComponentType());
                component = new GrowableBox(new VarArgFactory(this, historyList), 1, CallDialog.INSETS.top + CallDialog.INSETS.bottom);
                component.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        CallDialog.this.pack();
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                });
                this.parameterList.setVarArg((GrowableBox)component, paramString);
                continue;
            }
            historyList = this.history.getHistory(paramClasses[i]);
            component = this.createComboBox(historyList);
            this.parameterList.addParameter(i, (JComboBox)component, paramString);
        }
        return this.createParameterPanel("(", ")", this.parameterList);
    }

    protected JPanel createParameterPanel(String startString, String endString, ParameterList parameterList) {
        JPanel tmpPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        tmpPanel.setLayout(gridBag);
        JLabel startParenthesis = new JLabel(startString);
        double comboHeight = this.getComboBoxHeight();
        double parenthesisHeight = startParenthesis.getPreferredSize().getHeight();
        double parenthesisScale = comboHeight / parenthesisHeight;
        Font f = startParenthesis.getFont();
        Font parenthesisFont = f.deriveFont((float)((double)f.getSize() * parenthesisScale));
        startParenthesis.setFont(parenthesisFont);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = INSETS;
        constraints.gridx = 0;
        constraints.anchor = 12;
        tmpPanel.add((Component)startParenthesis, constraints);
        for (int i = 0; i < parameterList.size(); ++i) {
            constraints.gridx = 1;
            constraints.gridy = i;
            constraints.anchor = 17;
            JComponent component = parameterList.getParameterComponent(i);
            gridBag.setConstraints(component, constraints);
            tmpPanel.add(component);
            JLabel eol = new JLabel(",", 2);
            JLabel type = new JLabel(" " + parameterList.getType(i), 2);
            if (i == parameterList.size() - 1) {
                eol.setText(endString);
                eol.setFont(parenthesisFont);
                if (parameterList.size() == 1) {
                    type = null;
                } else {
                    this.setPreferredHeight(type, comboHeight);
                    constraints.anchor = 11;
                }
            }
            if (type != null) {
                constraints.gridx = 3;
                tmpPanel.add((Component)type, constraints);
                type.setLabelFor(component);
            }
            constraints.gridx = 2;
            this.setPreferredHeight(eol, comboHeight);
            constraints.anchor = 16;
            gridBag.setConstraints(eol, constraints);
            tmpPanel.add(eol);
        }
        return tmpPanel;
    }

    public Class<?>[] getArgTypes(boolean varArgsExpanded) {
        boolean hasVarArgs;
        CallableView method = this.getCallableView();
        Class<?>[] params = method.getParameters();
        boolean bl = hasVarArgs = method.isVarArgs() && this.parameterList != null && this.parameterList.size() >= params.length;
        if (hasVarArgs && varArgsExpanded) {
            int totalParams = this.parameterList.size();
            Class[] allParams = new Class[totalParams];
            System.arraycopy(params, 0, allParams, 0, params.length);
            Class<?> varArgType = params[params.length - 1].getComponentType();
            for (int i = params.length - 1; i < totalParams; ++i) {
                allParams[i] = varArgType;
            }
            return allParams;
        }
        return params;
    }

    public String[] getArgs() {
        String[] args = null;
        if (this.parameterList != null) {
            args = new String[this.parameterList.size()];
            for (int i = 0; i < this.parameterList.size(); ++i) {
                args[i] = (String)this.parameterList.getParameter(i).getEditor().getItem();
            }
        }
        return args;
    }

    public boolean parameterFieldsOk() {
        if (this.parameterList != null) {
            for (int i = 0; i < this.parameterList.size(); ++i) {
                String arg = (String)this.parameterList.getParameter(i).getEditor().getItem();
                if (arg != null && !arg.trim().equals("")) continue;
                return false;
            }
        }
        return true;
    }

    public boolean typeParameterFieldsOk() {
        boolean oneIsTypedIn = false;
        boolean oneIsEmpty = false;
        if (this.typeParameterList != null) {
            for (int i = 0; i < this.typeParameterList.size(); ++i) {
                String arg = (String)this.typeParameterList.getParameter(i).getEditor().getItem();
                if (arg == null || arg.trim().equals("")) {
                    oneIsEmpty = true;
                } else {
                    oneIsTypedIn = true;
                }
                if (!oneIsEmpty || !oneIsTypedIn) continue;
                return false;
            }
        }
        return true;
    }

    protected void clearParameters() {
        if (this.parameterList != null) {
            this.parameterList.clear();
        }
        if (this.typeParameterList != null) {
            this.typeParameterList.clear();
        }
    }

    @Override
    public void setVisible(boolean show) {
        if (!show) {
            this.stopObjectBenchListening();
        }
        super.setVisible(show);
    }

    protected void makeDialog(String className, String instanceName) {
        super.setContentPane(new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g;
                int width = this.getWidth();
                int height = this.getHeight();
                if (!Config.isRaspberryPi()) {
                    g2d.setPaint(new GradientPaint(width / 4, 0.0f, new Color(230, 229, 228), width * 3 / 4, height, new Color(191, 186, 178)));
                } else {
                    g2d.setPaint(new Color(214, 217, 223));
                }
                g2d.fillRect(0, 0, width, height);
            }
        });
        JPanel dialogPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            dialogPanel.setOpaque(false);
        }
        this.descPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            this.descPanel.setOpaque(false);
        }
        this.descPanel.setLayout(new BoxLayout(this.descPanel, 1));
        this.descPanel.setAlignmentX(0.0f);
        JPanel centerPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            centerPanel.setOpaque(false);
        }
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.setAlignmentX(0.0f);
        this.makeDialogInternal(className, instanceName, centerPanel);
        dialogPanel.setLayout(new BoxLayout(dialogPanel, 1));
        dialogPanel.setBorder(BlueJTheme.generalBorder);
        dialogPanel.add(this.descPanel);
        dialogPanel.add(Box.createVerticalStrut(5));
        JSeparator sep = new JSeparator();
        sep.setForeground(new Color(191, 190, 187));
        if (!Config.isRaspberryPi()) {
            sep.setBackground(new Color(0, 0, 0, 0));
        } else {
            sep.setBackground(new Color(0, 0, 0));
        }
        dialogPanel.add(sep);
        dialogPanel.add(Box.createVerticalStrut(5));
        dialogPanel.add(centerPanel);
        dialogPanel.add(this.getErrorLabel());
        this.makeDialog(null, dialogPanel);
    }

    protected void setDescription(MultiLineLabel label) {
        label.setAlignmentX(0.0f);
        this.descPanel.removeAll();
        this.descPanel.add(label);
        if (!Config.isRaspberryPi()) {
            label.setOpaque(false);
        }
        this.invalidate();
        this.validate();
    }

    public void insertText(String text) {
        if (this.parameterList != null && this.focusedTextField != null) {
            this.focusedTextField.setText(text);
            this.setVisible(true);
        }
    }

    public void updateParameters() {
        if (this.parameterList != null) {
            int i;
            Class<?>[] paramClasses = this.getArgTypes(true);
            for (i = 0; i < this.parameterList.size(); ++i) {
                this.history.addCall(paramClasses[i], (String)this.parameterList.getParameter(i).getEditor().getItem());
            }
            for (i = 0; i < this.parameterList.size(); ++i) {
                List<String> historyList = this.history.getHistory(paramClasses[i]);
                this.parameterList.setHistory(i, historyList);
            }
        }
        if (this.typeParameterList != null) {
            int i;
            CallableView callable = this.getCallableView();
            TypeParamView[] formalTypeParams = CallDialog.getFormalTypeParams(callable);
            String[] typeParams = this.getTypeParams();
            for (i = 0; i < typeParams.length; ++i) {
                this.history.addCall(formalTypeParams[i], typeParams[i]);
            }
            for (i = 0; i < typeParams.length; ++i) {
                List<String> historyList = this.history.getHistory(formalTypeParams[i]);
                this.typeParameterList.setHistory(i, historyList);
            }
        }
    }

    public String[] getTypeParams() {
        if (this.typeParameterList == null) {
            return new String[0];
        }
        String[] typeParams = new String[this.typeParameterList.size()];
        for (int i = 0; i < this.typeParameterList.size(); ++i) {
            typeParams[i] = (String)this.typeParameterList.getParameter(i).getEditor().getItem();
            if (!typeParams[i].equals("")) continue;
            return new String[0];
        }
        return typeParams;
    }

    public JavaType[] getArgGenTypes(boolean varArgsExpanded) {
        CallableView method = this.getCallableView();
        boolean raw = this.targetIsRaw();
        Map<String, GenTypeParameter> typeParameterMap = this.getTargetTypeArgs();
        HashMap<String, GenTypeParameter> typeMap = new HashMap<String, GenTypeParameter>();
        if (typeParameterMap != null) {
            typeMap.putAll(typeParameterMap);
        }
        String[] typeParams = this.getTypeParams();
        TypeParamView[] formalTypeParamViews = CallDialog.getFormalTypeParams(method);
        int len = typeParams.length;
        for (int i = 0; i < len; ++i) {
            TypeParamView view = formalTypeParamViews[i];
            GenTypeDeclTpar formalType = view.getParamType();
            TextType actualType = new TextType(typeParams[i]);
            typeMap.put(formalType.getTparName(), actualType);
        }
        JavaType[] params = method.getParamTypes(raw);
        for (int i = 0; i < params.length; ++i) {
            params[i] = params[i].mapTparsToTypes(typeMap).getUpperBound();
        }
        if (this.hasVarArgs(method, params) && varArgsExpanded) {
            int totalParams = this.parameterList.size();
            JavaType[] allParams = new JavaType[totalParams];
            System.arraycopy(params, 0, allParams, 0, params.length);
            JavaType varArgType = params[params.length - 1].getArrayComponent();
            for (int i = params.length - 1; i < totalParams; ++i) {
                allParams[i] = varArgType;
            }
            return allParams;
        }
        return params;
    }

    private boolean hasVarArgs(CallableView method, JavaType[] params) {
        if (!method.isVarArgs()) {
            return false;
        }
        if (this.parameterList == null) {
            return false;
        }
        if (this.parameterList.size() < params.length) {
            return false;
        }
        return this.getArgs().length != 1 || !this.isEmptyArg(this.getArgs()[0]);
    }

    private boolean isEmptyArg(String value) {
        String[] emptyArgs = new String[]{"{ }", "{}", ""};
        return Arrays.asList(emptyArgs).contains(value.trim());
    }

    protected String getNewInstanceName() {
        return null;
    }

    protected abstract CallableView getCallableView();

    protected abstract void makeDialogInternal(String var1, String var2, JPanel var3);

    protected boolean targetIsRaw() {
        return false;
    }

    protected Map<String, GenTypeParameter> getTargetTypeArgs() {
        return Collections.emptyMap();
    }

    @Override
    public void focusGained(FocusEvent fe) {
        if (fe.getComponent() instanceof JTextField) {
            this.focusedTextField = (JTextField)fe.getComponent();
            this.focusedTextField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
    }

    public static class ParameterList {
        private List<JComponent> parameters;
        private List<String> types;
        private boolean isVarArgs;
        private String defaultParamValue;

        public ParameterList(int initialSize, String defaultParamValue, boolean isVarArgs) {
            this.parameters = new ArrayList<JComponent>(initialSize);
            this.types = new ArrayList<String>(initialSize);
            this.defaultParamValue = defaultParamValue;
            this.isVarArgs = isVarArgs;
        }

        public JComboBox getParameter(int index) {
            if (this.isVarArgs && index >= this.parameters.size() - 1) {
                GrowableBox box = this.getGrowableBox();
                int boxIndex = index - this.parameters.size() + 1;
                return (JComboBox)((Container)box.getComponent(boxIndex)).getComponent(0);
            }
            return (JComboBox)this.parameters.get(index);
        }

        public JComponent getParameterComponent(int index) {
            return this.parameters.get(index);
        }

        public String getType(int index) {
            if (this.isVarArgs && index >= this.parameters.size() - 1) {
                return this.types.get(this.types.size() - 1);
            }
            return this.types.get(index);
        }

        private GrowableBox getGrowableBox() {
            if (this.parameters.size() < 1) {
                return null;
            }
            JComponent c = this.parameters.get(this.parameters.size() - 1);
            if (c instanceof GrowableBox) {
                return (GrowableBox)this.parameters.get(this.parameters.size() - 1);
            }
            return null;
        }

        public void addParameter(int index, JComboBox component, String type) {
            this.parameters.add(index, component);
            this.types.add(index, type);
        }

        public void setVarArg(GrowableBox component, String type) {
            GrowableBox box = this.getGrowableBox();
            if (box != null) {
                this.parameters.remove(box);
            }
            this.parameters.add(component);
            this.types.add(type);
        }

        public int size() {
            if (this.isVarArgs) {
                return this.parameters.size() + this.getGrowableBox().getComponentCountWithoutEmpty() - 1;
            }
            return this.parameters.size();
        }

        public void clear() {
            Iterator<JComponent> iter = this.parameters.iterator();
            while (iter.hasNext()) {
                JComponent element = iter.next();
                if (this.isVarArgs && !iter.hasNext()) {
                    ((GrowableBox)element).clear();
                    continue;
                }
                ((JComboBox)element).setSelectedIndex(0);
            }
        }

        public void setHistory(int i, List<String> historyList) {
            if (historyList == null) {
                return;
            }
            if (this.isVarArgs && i >= this.parameters.size() - 1) {
                GrowableBox varArgs = this.getGrowableBox();
                VarArgFactory factory = (VarArgFactory)varArgs.getComponentFactory();
                factory.setHistory(historyList);
            } else {
                this.getParameter(i).setModel(new DefaultComboBoxModel<Object>(historyList.toArray()));
                this.getParameter(i).insertItemAt(this.defaultParamValue, 0);
            }
        }
    }

    public static class VarArgFactory
    implements ComponentFactory {
        private List<String> history;
        private CallDialog dialog;

        public VarArgFactory(CallDialog dialog, List<String> history) {
            this.history = history;
            this.dialog = dialog;
        }

        public void setHistory(List<String> history) {
            this.history = history;
        }

        @Override
        public JComponent createComponent(JButton addButton, JButton removeButton) {
            Box container = new Box(0);
            JComboBox comboBox = this.dialog.createComboBox(this.history);
            comboBox.setSelectedIndex(0);
            container.add(comboBox);
            container.add(Box.createHorizontalStrut(5));
            container.add(new JLabel(" , "));
            container.add(Box.createHorizontalStrut(5));
            container.add(addButton);
            container.add(Box.createHorizontalStrut(5));
            container.add(removeButton);
            return container;
        }
    }
}

