/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.utility.MultiLineLabel;
import bluej.utility.Utility;
import java.awt.Font;
import javax.swing.JLabel;

public class FixedMultiLineLabel
extends MultiLineLabel {
    protected JLabel[] labels;
    protected int rows;

    public FixedMultiLineLabel(String text, float alignment, int numRows) {
        super(null, alignment);
        this.rows = numRows;
        this.labels = new JLabel[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.labels[i] = new JLabel(" ");
            this.labels[i].setAlignmentX(alignment);
            this.add(this.labels[i]);
        }
        this.addText(text);
    }

    public FixedMultiLineLabel(String text, int numRows) {
        this(text, 0.0f, numRows);
    }

    public FixedMultiLineLabel(float alignment, int numRows) {
        this(null, alignment, numRows);
    }

    public FixedMultiLineLabel(int numRows) {
        this(null, 0.0f, numRows);
    }

    @Override
    public void setText(String text) {
        this.addText(text);
    }

    @Override
    public void addText(String text) {
        int lines = 0;
        if (text != null) {
            String[] strs = Utility.splitLines(text);
            lines = strs.length < this.rows ? strs.length : this.rows;
            Font font = new Font("SansSerif", this.fontAttributes, 12);
            for (int i = 0; i < lines; ++i) {
                this.labels[i].setText(strs[i].length() == 0 ? " " : strs[i]);
                this.labels[i].setFont(font);
            }
        }
        for (int i = lines; i < this.rows; ++i) {
            this.labels[i].setText(" ");
        }
    }
}

