/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.Config;
import bluej.utility.ComponentFactory;
import bluej.utility.Utility;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GrowableBox
extends Box {
    private ComponentFactory componentFactory;
    private JComponent emptyGrowable;
    private Border emptyBorder;
    private static Insets buttonInsets = new Insets(0, 2, 0, 2);
    private static Font buttonFont = new Font("Monospaced", 1, 12);
    private static String addText = "+";
    private static ImageIcon addIcon;
    private static String removeText;
    private static ImageIcon removeIcon;

    public GrowableBox(ComponentFactory componentFactory, int axis, int gap) {
        super(axis);
        this.componentFactory = componentFactory;
        this.emptyBorder = BorderFactory.createEmptyBorder(0, 0, gap, 0);
        this.emptyGrowable = new JPanel();
        this.emptyGrowable.setLayout(new FlowLayout(1, 0, 0));
        JButton addButton = new JButton();
        JButton removeButton = new JButton();
        this.initButtons(addButton, removeButton);
        removeButton.setEnabled(false);
        this.emptyGrowable.add(addButton);
        this.emptyGrowable.add(removeButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrowableBox.this.createNewComponent(0);
            }
        });
        this.clear();
    }

    public void clear() {
        this.removeAll();
        this.createNewComponent(0);
        this.validate();
    }

    public void createNewComponent(int index) {
        JButton addButton = new JButton();
        JButton removeButton = new JButton();
        this.initButtons(addButton, removeButton);
        final JComponent component = this.componentFactory.createComponent(addButton, removeButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = GrowableBox.this.getIndex(component);
                GrowableBox.this.createNewComponent(index + 1);
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GrowableBox.this.removeGrowableComponent(component);
            }
        });
        this.addGrowableComponent(index, component);
    }

    public int getComponentCountWithoutEmpty() {
        int count = this.getComponentCount();
        if (count == 1 && this.getComponent(0) == this.emptyGrowable) {
            return 0;
        }
        return count;
    }

    public ComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    private void initButtons(JButton addButton, JButton removeButton) {
        Utility.changeToMacButton(addButton);
        addButton.setFont(buttonFont);
        addButton.setText(addText);
        addButton.setIcon(addIcon);
        Utility.changeToMacButton(removeButton);
        removeButton.setFont(buttonFont);
        removeButton.setText(removeText);
        removeButton.setIcon(removeIcon);
        if (!Config.isMacOSLeopard()) {
            addButton.setMargin(buttonInsets);
            removeButton.setMargin(buttonInsets);
        }
    }

    private void addGrowableComponent(int index, JComponent growableComponent) {
        if (this.getComponentCount() > 0 && this.getComponent(0) == this.emptyGrowable) {
            this.removeAll();
        }
        this.add((Component)growableComponent, index);
        if (index != this.getComponentCount() - 1) {
            growableComponent.setBorder(this.emptyBorder);
        } else {
            int nextLastIndex = index - 1;
            if (nextLastIndex >= 0) {
                JComponent nextLast = (JComponent)this.getComponent(nextLastIndex);
                nextLast.setBorder(this.emptyBorder);
            }
        }
        this.validate();
        this.repaint();
        this.fireResizedEvent();
    }

    private void removeGrowableComponent(JComponent growableComponent) {
        int nextLastIndex;
        int index = this.getIndex(growableComponent);
        if (index == this.getComponentCount() - 1 && (nextLastIndex = index - 1) >= 0) {
            JComponent nextLast = (JComponent)this.getComponent(nextLastIndex);
            nextLast.setBorder(null);
        }
        this.remove(growableComponent);
        if (this.getComponentCount() == 0) {
            this.addGrowableComponent(0, this.emptyGrowable);
        }
        this.validate();
        this.repaint();
        this.fireResizedEvent();
    }

    private void fireResizedEvent() {
        ComponentEvent e = new ComponentEvent(this, 101);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
    }

    private int getIndex(Component c) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component != c) continue;
            return i;
        }
        return -1;
    }

    static {
        removeText = "-";
    }
}

