/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.groupwork.UnableToParseInputException;

public class CvsUpdateResult {
    char statusCode = (char)88;
    String filename;
    public static final char ADDED = 'A';
    public static final char CONFLICT = 'C';
    public static final char MODIFIED = 'M';
    public static final char PATCHED = 'P';
    public static final char REMOVED = 'R';
    public static final char UPDATED = 'U';
    public static final char UNKNOWN = '?';

    private CvsUpdateResult(char statusCode, String filename) {
        this.statusCode = statusCode;
        this.filename = filename;
    }

    public static CvsUpdateResult parse(String str) throws UnableToParseInputException {
        boolean messageOk;
        char statusCode = 'X';
        boolean hasRightStructure = str != null && str.length() > 3;
        boolean hasRightStatusCode = false;
        if (hasRightStructure) {
            statusCode = str.charAt(0);
            hasRightStatusCode = statusCode == 'A' || statusCode == 'C' || statusCode == 'M' || statusCode == 'P' || statusCode == 'R' || statusCode == 'U' || statusCode == '?';
        }
        boolean bl = messageOk = hasRightStructure && hasRightStatusCode;
        if (messageOk) {
            String filename = str.substring(2);
            return new CvsUpdateResult(statusCode, filename);
        }
        throw new UnableToParseInputException(str);
    }

    public String getFilename() {
        return this.filename;
    }

    public char getStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        return "statusCode: " + this.statusCode + " filename: " + this.filename;
    }
}

