/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnCommand;
import bluej.groupwork.svn.SvnRepository;
import java.io.File;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;

public class SvnCheckoutCommand
extends SvnCommand {
    private File checkoutPath;
    private String moduleName;

    public SvnCheckoutCommand(SvnRepository repository, File projectPath) {
        super(repository);
        this.checkoutPath = projectPath.getAbsoluteFile();
        this.moduleName = projectPath.getName();
    }

    @Override
    protected TeamworkCommandResult doCommand() {
        block3: {
            SVNClientInterface client = this.getClient();
            String reposUrl = this.getRepository().getReposUrl();
            reposUrl = reposUrl + "/" + this.moduleName;
            try {
                client.checkout(reposUrl, this.checkoutPath.getAbsolutePath(), Revision.HEAD, Revision.HEAD, 3, true, true);
                if (!this.isCancelled()) {
                    return new TeamworkCommandResult();
                }
            }
            catch (ClientException ce) {
                if (this.isCancelled()) break block3;
                return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
            }
        }
        return new TeamworkCommandAborted();
    }
}

