/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.groupwork.actions.CommitCommentAction;
import bluej.groupwork.actions.UpdateDialogAction;
import bluej.pkgmgr.PkgMgrFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class TeamControlsPanel
extends JPanel {
    private JButton commitButton;
    private JButton updateButton;
    private PkgMgrFrame pmf;
    private JCheckBox includeGraphLayoutCheckBox;
    private JPanel helpPanel = null;
    private CommitCommentAction commitCommentAction;
    private UpdateDialogAction updateAction;

    public TeamControlsPanel(PkgMgrFrame pmf) {
        this.pmf = pmf;
        this.updateAction = new UpdateDialogAction();
        this.commitCommentAction = new CommitCommentAction();
        this.setLayout(new BoxLayout(this, 1));
        JPanel codeSynchPanel = new JPanel();
        codeSynchPanel.setLayout(new BoxLayout(codeSynchPanel, 1));
        codeSynchPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Code Synchronization"), BlueJTheme.generalBorder));
        codeSynchPanel.setAlignmentX(0.5f);
        this.commitButton = new JButton(this.commitCommentAction);
        this.updateButton = new JButton(this.updateAction);
        this.includeGraphLayoutCheckBox = new JCheckBox("Include graph layout");
        this.commitButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.commitButton.getPreferredSize().height));
        this.updateButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.updateButton.getPreferredSize().height));
        codeSynchPanel.add(this.commitButton);
        codeSynchPanel.add(Box.createVerticalStrut(5));
        codeSynchPanel.add(this.updateButton);
        codeSynchPanel.add(Box.createVerticalStrut(5));
        codeSynchPanel.add(this.includeGraphLayoutCheckBox);
        this.add(codeSynchPanel);
        this.doGreyOut(pmf.getProject() == null);
        this.configureHelp();
    }

    public void doGreyOut(boolean greyout) {
        this.updateAction.setEnabled(!greyout);
        this.commitCommentAction.setEnabled(!greyout);
        this.includeGraphLayoutCheckBox.setEnabled(!greyout);
    }

    public boolean includeGraphLayout() {
        return this.includeGraphLayoutCheckBox.isSelected();
    }

    public void configureHelp() {
        if (this.pmf.getProject() == null) {
            this.setHelp("To get a project from the repository, open the Team menuand select Checkout Project...");
            this.doGreyOut(true);
            return;
        }
        if (!this.pmf.getProject().isTeamProject()) {
            this.setHelp("This project is not a team project." + Config.nl + "To share this project, open the Team menu and select " + "Share Project..." + Config.nl + "To get a project from the repository, open the Team menu " + "and select Checkout Project...");
            this.doGreyOut(true);
        }
        if (this.pmf.getProject().isTeamProject()) {
            if (this.helpPanel != null) {
                this.remove(this.helpPanel);
            }
            this.doGreyOut(false);
        }
    }

    private void setHelp(String helpStr) {
        JPanel p = this.makeHelpPanel(helpStr);
        this.setHelpPanel(p);
    }

    private JPanel makeHelpPanel(String input) {
        JPanel panel = new JPanel();
        panel.setBorder(BlueJTheme.generalBorder);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.5f);
        Font helpFont = ((Font)UIManager.get("Label.font")).deriveFont(2, 12.0f);
        JTextArea text = new JTextArea(input);
        text.setEditable(false);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setBackground((Color)UIManager.get("Label.background"));
        text.setForeground((Color)UIManager.get("Label.foreground"));
        text.setFont(helpFont);
        panel.add(text);
        return panel;
    }

    private void setHelpPanel(JPanel helpPanel) {
        if (this.helpPanel != null) {
            this.remove(this.helpPanel);
        }
        this.helpPanel = helpPanel;
        this.add((Component)helpPanel, 0);
    }
}

