/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ProjectPrintDialog
extends EscapeDialog {
    private boolean ok;
    private JCheckBox printDiagram;
    private JCheckBox printSource;
    private JCheckBox printReadme;

    public ProjectPrintDialog(PkgMgrFrame parent) {
        super(parent, Config.getString("pkgmgr.printDialog.title"), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent E) {
                ProjectPrintDialog.this.ok = false;
                ProjectPrintDialog.this.setVisible(false);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        mainPanel.add(Box.createVerticalStrut(17));
        this.printDiagram = new JCheckBox(Config.getString("pkgmgr.printDialog.printDiagram"));
        this.printDiagram.setSelected(true);
        mainPanel.add(this.printDiagram);
        this.printSource = new JCheckBox(Config.getString("pkgmgr.printDialog.printSource"));
        mainPanel.add(this.printSource);
        if (parent.getPackage().isUnnamedPackage()) {
            this.printReadme = new JCheckBox(Config.getString("pkgmgr.printDialog.printReadme"));
            mainPanel.add(this.printReadme);
        }
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPrintDialog.this.doOK();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectPrintDialog.this.doCancel();
            }
        });
        DialogManager.addOKCancelButtons(buttonPanel, okButton, cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    public boolean display() {
        this.ok = false;
        this.setVisible(true);
        return this.ok;
    }

    public void doOK() {
        this.ok = this.printDiagram() || this.printSource() || this.printReadme();
        this.setVisible(false);
    }

    public void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }

    public boolean printDiagram() {
        return this.printDiagram.isSelected();
    }

    public boolean printSource() {
        return this.printSource.isSelected();
    }

    public boolean printReadme() {
        return this.printReadme != null && this.printReadme.isSelected();
    }
}

