/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.BlueJTheme;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerTerminal;
import bluej.debugmgr.ExecutionEvent;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.terminal.InputBuffer;
import bluej.terminal.TermTextArea;
import bluej.terminal.TerminalPrinter;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;

public final class Terminal
extends JFrame
implements KeyListener,
BlueJEventListener,
DebuggerTerminal {
    private static final String WINDOWTITLE = Config.getApplicationName() + ": " + Config.getString("terminal.title");
    private static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final String TERMINALFONTPROPNAME = "bluej.terminal.font";
    private static final String TERMINALFONTSIZEPROPNAME = "bluej.terminal.fontsize";
    private static final String RECORDMETHODCALLSPROPNAME = "bluej.terminal.recordcalls";
    private static final String CLEARONMETHODCALLSPROPNAME = "bluej.terminal.clearscreen";
    private static final String UNLIMITEDBUFFERINGCALLPROPNAME = "bluej.terminal.buffering";
    private static int terminalFontSize = Config.getPropInteger("bluej.terminal.fontsize", PrefMgr.getEditorFontSize());
    private Project project;
    private TermTextArea text;
    private TermTextArea errorText;
    private JScrollPane errorScrollPane;
    private JScrollPane scrollPane;
    private JSplitPane splitPane;
    private boolean isActive = false;
    private static boolean recordMethodCalls = Config.getPropBoolean("bluej.terminal.recordcalls");
    private static boolean clearOnMethodCall = Config.getPropBoolean("bluej.terminal.clearscreen");
    private static boolean unlimitedBufferingCall = Config.getPropBoolean("bluej.terminal.buffering");
    private boolean newMethodCall = true;
    private boolean errorShown = false;
    private InputBuffer buffer;
    private JCheckBoxMenuItem autoClear;
    private JCheckBoxMenuItem recordCalls;
    private JCheckBoxMenuItem unlimitedBuffering;
    private Reader in = new TerminalReader();
    private Writer out = new TerminalWriter(false);
    private Writer err = new TerminalWriter(true);
    private boolean initialised = false;

    public Terminal(Project project) {
        super(WINDOWTITLE + " - " + project.getProjectName());
        this.project = project;
        BlueJEvent.addListener(this);
    }

    private static Font getTerminalFont() {
        return Config.getFont(TERMINALFONTPROPNAME, "Monospaced", terminalFontSize);
    }

    private static void setTerminalFontSize(int size) {
        terminalFontSize = size <= 6 ? PrefMgr.getEditorFontSize() : size;
        Config.putPropInteger(TERMINALFONTSIZEPROPNAME, terminalFontSize);
    }

    private synchronized void initialise() {
        if (!this.initialised) {
            this.buffer = new InputBuffer(256);
            int width = Config.isGreenfoot() ? 80 : Config.getPropInteger("bluej.terminal.width", 80);
            int height = Config.isGreenfoot() ? 10 : Config.getPropInteger("bluej.terminal.height", 22);
            this.makeWindow(width, height);
            this.initialised = true;
            this.text.setUnlimitedBuffering(unlimitedBufferingCall);
        }
    }

    public void showHide(boolean show) {
        DataCollector.showHideTerminal(this.project, show);
        this.initialise();
        this.setVisible(show);
        if (show) {
            this.text.requestFocus();
        }
    }

    public boolean isShown() {
        this.initialise();
        return this.isShowing();
    }

    public void activate(boolean active) {
        if (active != this.isActive) {
            this.initialise();
            this.text.setEditable(active);
            if (!active) {
                this.text.getCaret().setVisible(false);
            }
            this.isActive = active;
        }
    }

    public boolean checkActive() {
        return this.isActive;
    }

    public void resetFont() {
        this.initialise();
        Font terminalFont = Terminal.getTerminalFont();
        this.text.setFont(terminalFont);
        if (this.errorText != null) {
            this.errorText.setFont(terminalFont);
        }
    }

    public void clear() {
        this.initialise();
        this.text.setText("");
        if (this.errorText != null) {
            this.errorText.setText("");
        }
        this.hideErrorPane();
    }

    public void save() {
        this.initialise();
        String fileName = FileUtility.getFileName(this, Config.getString("terminal.save.title"), Config.getString("terminal.save.buttonText"), null, false);
        if (fileName != null) {
            File f = new File(fileName);
            if (f.exists() && DialogManager.askQuestion(this, "error-file-exists") != 0) {
                return;
            }
            try {
                FileWriter writer = new FileWriter(fileName);
                this.text.write(writer);
                writer.close();
            }
            catch (IOException ex) {
                DialogManager.showError(this, "error-save-file");
            }
        }
    }

    public void print() {
        PrinterJob job = PrinterJob.getPrinterJob();
        int printFontSize = Config.getPropInteger("bluej.fontsize.printText", 10);
        Font font = new Font("Monospaced", 0, printFontSize);
        if (job.printDialog()) {
            TerminalPrinter.printTerminal(job, this.text, job.defaultPage(), font);
        }
    }

    private void writeToPane(boolean stdout, String s) {
        int n;
        this.prepare();
        if (!stdout) {
            this.showErrorPane();
        }
        if ((n = s.lastIndexOf(12)) != -1) {
            this.clear();
            s = s.substring(n + 1);
        }
        TermTextArea tta = stdout ? this.text : this.errorText;
        tta.append(s);
        tta.setCaretPosition(tta.getDocument().getLength());
    }

    public void writeToTerminal(String s) {
        this.writeToPane(true, s);
    }

    private void prepare() {
        if (this.newMethodCall) {
            this.showHide(true);
            this.newMethodCall = false;
        } else if (Config.isGreenfoot() && !this.isVisible()) {
            this.showHide(true);
        }
    }

    private void methodCall(String callString, boolean isVoid) {
        this.newMethodCall = false;
        if (clearOnMethodCall) {
            this.clear();
        }
        if (recordMethodCalls) {
            this.text.appendMethodCall(callString + "\n");
        }
        this.newMethodCall = true;
    }

    private void constructorCall(InvokerRecord ir) {
        this.newMethodCall = false;
        if (clearOnMethodCall) {
            this.clear();
        }
        if (recordMethodCalls) {
            String callString = ir.getResultTypeString() + " " + ir.getResultName() + " = " + ir.toExpression() + ";";
            this.text.appendMethodCall(callString + "\n");
        }
        this.newMethodCall = true;
    }

    private void methodResult(ExecutionEvent event) {
        if (recordMethodCalls) {
            String result = null;
            String resultType = event.getResult();
            if (resultType == "Normal exit") {
                DebuggerObject object = event.getResultObject();
                if (object != null) {
                    if (event.getClassName() != null && event.getMethodName() == null) {
                        return;
                    }
                    if (object.isNullObject()) {
                        return;
                    }
                    DebuggerField resultField = object.getField(0);
                    result = "    returned " + resultField.getType().toString(true) + " ";
                    result = result + resultField.getValueString();
                }
            } else if (resultType == "An exception occurred") {
                result = "    Exception occurred.";
            } else if (resultType == "User terminated") {
                result = "    VM terminated.";
            }
            if (result != null) {
                this.text.appendMethodCall(result + "\n");
            }
        }
    }

    @Override
    public Reader getReader() {
        return this.in;
    }

    @Override
    public Writer getWriter() {
        return this.out;
    }

    @Override
    public Writer getErrorWriter() {
        return this.err;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
        char ch = event.getKeyChar();
        block1 : switch (ch) {
            case '%': 
            case '&': 
            case '\'': 
            case '(': {
                if (PrefMgr.getFlag("bluej.accessibility.support")) {
                    return;
                }
            }
            case '=': 
            case '\u0209': {
                if (event.getModifiers() == SHORTCUT_MASK) {
                    Terminal.setTerminalFontSize(terminalFontSize + 1);
                    this.project.getTerminal().resetFont();
                    event.consume();
                    break;
                }
            }
            case '-': {
                if (event.getModifiers() == SHORTCUT_MASK) {
                    Terminal.setTerminalFontSize(terminalFontSize - 1);
                    this.project.getTerminal().resetFont();
                    event.consume();
                    break;
                }
            }
            default: {
                if ((event.getModifiers() & 4) != 0) {
                    return;
                }
                if (!this.isActive) break;
                switch (ch) {
                    case '\u0004': 
                    case '\u001a': {
                        this.buffer.signalEOF();
                        this.writeToTerminal("\n");
                        event.consume();
                        break block1;
                    }
                    case '\b': {
                        if (this.buffer.backSpace()) {
                            try {
                                int length = this.text.getDocument().getLength();
                                this.text.replaceRange("", length - 1, length);
                            }
                            catch (Exception exc) {
                                Debug.reportError("bad location " + exc);
                            }
                        }
                        event.consume();
                        break block1;
                    }
                    case '\n': 
                    case '\r': {
                        if (this.buffer.putChar('\n')) {
                            this.writeToTerminal(String.valueOf(ch));
                            this.buffer.notifyReaders();
                        }
                        event.consume();
                        break block1;
                    }
                }
                if (ch < ' ') break;
                if (this.buffer.putChar(ch)) {
                    this.writeToTerminal(String.valueOf(ch));
                }
                event.consume();
            }
        }
    }

    @Override
    public void blueJEvent(int eventId, Object arg) {
        this.initialise();
        if (eventId == 3) {
            InvokerRecord ir = (InvokerRecord)arg;
            if (ir.getResultName() != null) {
                this.constructorCall(ir);
            } else {
                this.methodCall(ir.toExpression(), ir.hasVoidResult());
            }
        } else if (eventId == 5) {
            this.methodResult((ExecutionEvent)arg);
        }
    }

    private void makeWindow(int columns, int rows) {
        Image icon = BlueJTheme.getIconImage();
        if (icon != null) {
            this.setIconImage(icon);
        }
        this.text = new TermTextArea(rows, columns, this.buffer, this.project, this, false);
        final InputMap origInputMap = this.text.getInputMap();
        this.text.setInputMap(0, new InputMap(){
            {
                this.setParent(origInputMap);
            }

            @Override
            public Object get(KeyStroke keyStroke) {
                Object actionName = super.get(keyStroke);
                if (actionName == null) {
                    return null;
                }
                char keyChar = keyStroke.getKeyChar();
                if (keyChar == '\uffff' || keyChar < ' ') {
                    if ("copy-to-clipboard".equals(actionName)) {
                        return actionName;
                    }
                    if ("paste-from-clipboard".equals(actionName)) {
                        return actionName;
                    }
                    return PrefMgr.getFlag("bluej.accessibility.support") ? actionName : null;
                }
                return actionName;
            }
        });
        this.scrollPane = new JScrollPane(this.text);
        this.text.setFont(Terminal.getTerminalFont());
        this.text.setEditable(false);
        this.text.setMargin(new Insets(6, 6, 6, 6));
        this.text.addKeyListener(this);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setJMenuBar(this.makeMenuBar());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Window win = (Window)event.getSource();
                if (Terminal.this.project != null && Terminal.this.project.getDebugger().getStatus() == 3) {
                    return;
                }
                DataCollector.showHideTerminal(Terminal.this.project, false);
                win.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.terminal", Terminal.this.getLocation());
            }
        });
        this.setDefaultCloseOperation(0);
        this.setLocation(Config.getLocation("bluej.terminal"));
        this.pack();
    }

    private void createErrorPane() {
        this.errorText = new TermTextArea(Config.isGreenfoot() ? 20 : 5, 80, null, this.project, this, true);
        this.errorScrollPane = new JScrollPane(this.errorText);
        this.errorText.setFont(Terminal.getTerminalFont());
        this.errorText.setEditable(false);
        this.errorText.setMargin(new Insets(6, 6, 6, 6));
        this.errorText.setUnlimitedBuffering(true);
        this.splitPane = new JSplitPane(0, this.scrollPane, this.errorScrollPane);
    }

    private void showErrorPane() {
        if (this.errorShown) {
            return;
        }
        boolean isFirstShow = false;
        if (this.errorText == null) {
            isFirstShow = true;
            this.createErrorPane();
        }
        this.getContentPane().remove(this.scrollPane);
        if (!isFirstShow) {
            this.splitPane.setTopComponent(this.scrollPane);
        }
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.resetToPreferredSizes();
        if (isFirstShow) {
            this.pack();
        } else {
            this.validate();
        }
        this.errorShown = true;
    }

    private void hideErrorPane() {
        if (!this.errorShown) {
            return;
        }
        this.getContentPane().remove(this.splitPane);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.errorShown = false;
        this.validate();
    }

    private JMenuBar makeMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu(Config.getString("terminal.options"));
        JMenuItem item = menu.add(new ClearAction());
        item.setAccelerator(KeyStroke.getKeyStroke(75, SHORTCUT_MASK));
        item = menu.add(this.getCopyAction());
        item.setText(Config.getString("terminal.copy"));
        item.setAccelerator(KeyStroke.getKeyStroke(67, SHORTCUT_MASK));
        item = menu.add(new SaveAction());
        item.setAccelerator(KeyStroke.getKeyStroke(83, SHORTCUT_MASK));
        menu.add(new PrintAction());
        menu.add(new JSeparator());
        this.autoClear = new JCheckBoxMenuItem(new AutoClearAction());
        this.autoClear.setSelected(clearOnMethodCall);
        menu.add(this.autoClear);
        this.recordCalls = new JCheckBoxMenuItem(new RecordCallAction());
        this.recordCalls.setSelected(recordMethodCalls);
        menu.add(this.recordCalls);
        this.unlimitedBuffering = new JCheckBoxMenuItem(new BufferAction());
        this.unlimitedBuffering.setSelected(unlimitedBufferingCall);
        menu.add(this.unlimitedBuffering);
        menu.add(new JSeparator());
        item = menu.add(new CloseAction());
        item.setAccelerator(KeyStroke.getKeyStroke(87, SHORTCUT_MASK));
        menubar.add(menu);
        return menubar;
    }

    private Action getCopyAction() {
        Action[] textActions = this.text.getActions();
        for (int i = 0; i < textActions.length; ++i) {
            if (!textActions[i].getValue("Name").equals("copy-to-clipboard")) continue;
            return textActions[i];
        }
        return null;
    }

    private class TerminalWriter
    extends Writer {
        private boolean isErrorOut;

        TerminalWriter(boolean isError) {
            this.isErrorOut = isError;
        }

        @Override
        public void write(final char[] cbuf, final int off, final int len) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Terminal.this.initialise();
                        Terminal.this.writeToPane(!TerminalWriter.this.isErrorOut, new String(cbuf, off, len));
                    }
                });
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private class TerminalReader
    extends Reader {
        private TerminalReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) {
            int charsRead;
            Terminal.this.initialise();
            for (charsRead = 0; charsRead < len; ++charsRead) {
                cbuf[off + charsRead] = Terminal.this.buffer.getChar();
                if (!Terminal.this.buffer.isEmpty()) continue;
                break;
            }
            return charsRead;
        }

        @Override
        public boolean ready() {
            return !Terminal.this.buffer.isEmpty();
        }

        @Override
        public void close() {
        }
    }

    private class BufferAction
    extends AbstractAction {
        public BufferAction() {
            super(Config.getString("terminal.buffering"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            unlimitedBufferingCall = Terminal.this.unlimitedBuffering.isSelected();
            Terminal.this.text.setUnlimitedBuffering(unlimitedBufferingCall);
            Config.putPropBoolean(Terminal.UNLIMITEDBUFFERINGCALLPROPNAME, unlimitedBufferingCall);
        }
    }

    private class RecordCallAction
    extends AbstractAction {
        public RecordCallAction() {
            super(Config.getString("terminal.recordCalls"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            recordMethodCalls = Terminal.this.recordCalls.isSelected();
            Config.putPropBoolean(Terminal.RECORDMETHODCALLSPROPNAME, recordMethodCalls);
        }
    }

    private class AutoClearAction
    extends AbstractAction {
        public AutoClearAction() {
            super(Config.getString("terminal.clearScreen"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            clearOnMethodCall = Terminal.this.autoClear.isSelected();
            Config.putPropBoolean(Terminal.CLEARONMETHODCALLSPROPNAME, clearOnMethodCall);
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Config.getString("terminal.close"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal.this.showHide(false);
        }
    }

    private class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super(Config.getString("terminal.print"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal.this.print();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(Config.getString("terminal.save"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal.this.save();
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(Config.getString("terminal.clear"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Terminal.this.clear();
        }
    }
}

