/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeDocumentListener;
import bluej.editor.moe.MoeSyntaxEvent;
import bluej.editor.moe.ReparseRecord;
import bluej.editor.moe.Token;
import bluej.parser.entity.EntityResolver;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.utility.Debug;
import bluej.utility.PersistentMarkDocument;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;

public class MoeSyntaxDocument
extends PersistentMarkDocument {
    private static Color[] colors = null;
    private static Color defaultColour = null;
    private static Color backgroundColour = null;
    private static final int MAX_PARSE_PIECE = 8000;
    private ParsedCUNode parsedNode;
    private EntityResolver parentResolver;
    private NodeTree<ReparseRecord> reparseRecordTree;
    private MoeDocumentListener listener;
    private Runnable[] scheduledUpdates;
    protected boolean inNotification = false;
    protected boolean runningScheduledUpdates = false;
    private List<PendingError> pendingErrors = new LinkedList<PendingError>();
    private static int EDIT_INSERT = 0;
    private static int EDIT_DELETE = 1;
    private List<EditEvent> recentEdits = new LinkedList<EditEvent>();

    private void recordEvent(DocumentEvent event) {
        int type;
        if (event.getType() == DocumentEvent.EventType.INSERT) {
            type = EDIT_INSERT;
        } else if (event.getType() == DocumentEvent.EventType.REMOVE) {
            type = EDIT_DELETE;
        } else {
            return;
        }
        EditEvent eevent = new EditEvent();
        eevent.type = type;
        eevent.offset = event.getOffset();
        eevent.length = event.getLength();
        this.recentEdits.add(eevent);
        if (this.recentEdits.size() > 10) {
            this.recentEdits.remove(0);
        }
    }

    public MoeSyntaxDocument() {
        MoeSyntaxDocument.getUserColors();
        int tabSize = Config.getPropInteger((String)"bluej.editor.tabsize", (int)4);
        this.putProperty("tabSize", tabSize);
    }

    public MoeSyntaxDocument(EntityResolver parentResolver) {
        this();
        this.parentResolver = parentResolver;
        if (parentResolver != null) {
            this.reparseRecordTree = new NodeTree();
        }
    }

    public MoeSyntaxDocument(EntityResolver parentResolver, MoeDocumentListener listener) {
        this(parentResolver);
        this.listener = listener;
    }

    public ParsedCUNode getParser() {
        this.flushReparseQueue();
        return this.parsedNode;
    }

    public ParsedCUNode getParsedNode() {
        return this.parsedNode;
    }

    public void enableParser(boolean force) {
        if (this.parentResolver != null || force) {
            this.parsedNode = new ParsedCUNode((Document)((Object)this));
            this.parsedNode.setParentResolver(this.parentResolver);
            this.reparseRecordTree = new NodeTree();
            this.parsedNode.textInserted(this, 0, 0, this.getLength(), new NodeStructureListener(){

                public void nodeRemoved(NodeTree.NodeAndPosition<ParsedNode> node) {
                }

                public void nodeChangedLength(NodeTree.NodeAndPosition<ParsedNode> node, int oldPos, int oldSize) {
                }
            });
        }
    }

    public boolean pollReparseQueue() {
        return this.pollReparseQueue(8000);
    }

    public boolean pollReparseQueue(int maxParse) {
        try {
            if (this.reparseRecordTree == null) {
                return false;
            }
            NodeTree.NodeAndPosition nap = this.reparseRecordTree.findNodeAtOrAfter(0);
            if (nap != null) {
                int pos = nap.getPosition();
                ParsedCUNode pn = this.parsedNode;
                int ppos = 0;
                if (pn != null) {
                    NodeTree.NodeAndPosition cn;
                    for (cn = pn.findNodeAt(pos, ppos); cn != null && cn.getEnd() == pos; cn = cn.nextSibling()) {
                    }
                    while (cn != null && cn.getPosition() <= pos) {
                        ppos = cn.getPosition();
                        pn = (ParsedNode)cn.getNode();
                        for (cn = pn.findNodeAt(nap.getPosition(), ppos); cn != null && cn.getEnd() == pos; cn = cn.nextSibling()) {
                        }
                    }
                    MoeSyntaxEvent mse = new MoeSyntaxEvent(this);
                    pn.reparse(this, ppos, pos, maxParse, (NodeStructureListener)mse);
                    this.fireChangedUpdate(mse);
                    return true;
                }
            }
            return false;
        }
        catch (RuntimeException e) {
            Debug.message((String)"Exception during incremental parsing. Recent edits:");
            for (EditEvent event : this.recentEdits) {
                String eventStr = event.type == EDIT_INSERT ? "insert " : "delete ";
                eventStr = eventStr + "offset=" + event.offset + " length=" + event.length;
                Debug.message((String)eventStr);
            }
            try {
                Debug.message((String)"--- Source code ---");
                Debug.message((String)this.getText(0, this.getLength()));
                Debug.message((String)"--- Source ends ---");
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            throw e;
        }
    }

    public void flushReparseQueue() {
        while (this.pollReparseQueue(this.getLength())) {
        }
    }

    public void scheduleReparse(int pos, int size) {
        NodeTree.NodeAndPosition existing = this.reparseRecordTree.findNodeAtOrAfter(pos);
        if (existing != null) {
            if (existing.getPosition() > pos && existing.getPosition() <= pos + size) {
                ((ReparseRecord)existing.getNode()).slideStart(pos - existing.getPosition());
                return;
            }
            if (existing.getPosition() <= pos) {
                int nsize = pos + size - existing.getPosition();
                if (nsize > existing.getSize()) {
                    NodeTree.NodeAndPosition next = existing.nextSibling();
                    while (next != null && next.getPosition() <= pos + size) {
                        nsize = Math.max(nsize, next.getEnd() - pos);
                        NodeTree.NodeAndPosition nnext = next.nextSibling();
                        ((ReparseRecord)next.getNode()).remove();
                        next = nnext;
                    }
                    ((ReparseRecord)existing.getNode()).setSize(nsize);
                }
                return;
            }
        }
        ReparseRecord rr = new ReparseRecord();
        this.reparseRecordTree.insertNode((RBTreeNode)rr, pos, size);
    }

    public void markSectionParsed(int pos, int size) {
        this.repaintLines(pos, size);
        if (this.listener != null) {
            this.listener.reparsingRange(pos, size);
            Iterator<PendingError> i = this.pendingErrors.iterator();
            while (i.hasNext()) {
                PendingError pe = i.next();
                if (pe.position < pos || pe.position > pos + size) continue;
                this.listener.parseError(pe.position, pe.size, pe.errCode);
                i.remove();
            }
        }
        NodeTree.NodeAndPosition existing = this.reparseRecordTree.findNodeAtOrAfter(pos);
        while (existing != null && existing.getPosition() <= pos) {
            NodeTree.NodeAndPosition next = existing.nextSibling();
            int rsize = existing.getEnd() - pos;
            if ((rsize = Math.min(rsize, size)) == existing.getSize()) {
                ((ReparseRecord)existing.getNode()).remove();
            } else {
                if (existing.getPosition() == pos) {
                    existing.slideStart(rsize);
                    existing = next;
                    break;
                }
                int existingEnd = existing.getEnd();
                existing.setSize(pos - existing.getPosition());
                if (existingEnd > pos + size) {
                    this.scheduleReparse(pos + size, existingEnd - (pos + size));
                    return;
                }
            }
            existing = next;
        }
        while (existing != null && existing.getPosition() < pos + size) {
            int rsize = pos + size - existing.getPosition();
            if (rsize < existing.getSize()) {
                existing.slideStart(rsize);
                return;
            }
            NodeTree.NodeAndPosition next = existing.nextSibling();
            ((ReparseRecord)existing.getNode()).remove();
            existing = next;
        }
    }

    public void parseError(int position, int size, String message) {
        if (this.listener != null) {
            this.pendingErrors.add(new PendingError(position, size, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParagraphAttributes(int offset, AttributeSet s) {
        try {
            this.writeLock();
            Element paragraph = this.getParagraphElement(offset);
            MutableAttributeSet attr = (MutableAttributeSet)paragraph.getAttributes();
            attr.addAttributes(s);
        }
        finally {
            this.writeUnlock();
        }
    }

    public static Color getDefaultColor() {
        return defaultColour;
    }

    public static Color getBackgroundColor() {
        return backgroundColour;
    }

    public static Color[] getColors() {
        return MoeSyntaxDocument.getUserColors();
    }

    private static Color[] getUserColors() {
        if (colors == null) {
            int colorInt = MoeSyntaxDocument.getPropHexInt("other", 0);
            defaultColour = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("background", 0);
            backgroundColour = new Color(colorInt);
            colors = new Color[13];
            colorInt = MoeSyntaxDocument.getPropHexInt("comment", 1710720);
            MoeSyntaxDocument.colors[1] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("javadoc", 1710720);
            MoeSyntaxDocument.colors[2] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("stand-out", 0xEE00BB);
            MoeSyntaxDocument.colors[3] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("keyword1", 0x660033);
            MoeSyntaxDocument.colors[4] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("keyword2", 13402163);
            MoeSyntaxDocument.colors[5] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("keyword3", 26265);
            MoeSyntaxDocument.colors[6] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("primitive", 0xCC0000);
            MoeSyntaxDocument.colors[7] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("string", 0x339933);
            MoeSyntaxDocument.colors[8] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("label", 0x999999);
            MoeSyntaxDocument.colors[10] = new Color(colorInt);
            colorInt = MoeSyntaxDocument.getPropHexInt("invalid", 0xFF3300);
            MoeSyntaxDocument.colors[12] = new Color(colorInt);
            MoeSyntaxDocument.colors[11] = new Color(0xCC9900);
        }
        return colors;
    }

    public Token getTokensForLine(int line) {
        Element lineEl = this.getDefaultRootElement().getElement(line);
        int pos = lineEl.getStartOffset();
        int length = lineEl.getEndOffset() - pos - 1;
        return this.parsedNode.getMarkTokensFor(pos, length, 0, (Document)((Object)this));
    }

    public void scheduleUpdate(Runnable r) {
        if (!this.inNotification) {
            r.run();
            return;
        }
        if (this.scheduledUpdates == null) {
            this.scheduledUpdates = new Runnable[1];
        } else {
            Runnable[] newScheduledTasks = new Runnable[this.scheduledUpdates.length + 1];
            System.arraycopy(this.scheduledUpdates, 0, newScheduledTasks, 0, this.scheduledUpdates.length);
            this.scheduledUpdates = newScheduledTasks;
        }
        this.scheduledUpdates[this.scheduledUpdates.length - 1] = r;
    }

    private static int getPropHexInt(String propName, int def) {
        String strVal = Config.getPropString((String)propName, null, (Properties)Config.moeUserProps);
        try {
            return Integer.parseInt(strVal, 16);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    protected void fireInsertUpdate(DocumentEvent e) {
        NodeTree.NodeAndPosition napRr;
        this.inNotification = true;
        if (this.reparseRecordTree != null && (napRr = this.reparseRecordTree.findNodeAtOrAfter(e.getOffset())) != null) {
            if (napRr.getPosition() <= e.getOffset()) {
                ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() + e.getLength());
            } else {
                ((ReparseRecord)napRr.getNode()).slide(e.getLength());
            }
        }
        MoeSyntaxEvent mse = new MoeSyntaxEvent(this, e);
        if (this.parsedNode != null) {
            this.parsedNode.textInserted(this, 0, e.getOffset(), e.getLength(), (NodeStructureListener)mse);
        }
        this.recordEvent(e);
        super.fireInsertUpdate((DocumentEvent)mse);
        this.inNotification = false;
        if (this.scheduledUpdates != null && !this.runningScheduledUpdates) {
            this.runningScheduledUpdates = true;
            for (int i = 0; i < this.scheduledUpdates.length; ++i) {
                this.scheduledUpdates[i].run();
            }
            this.scheduledUpdates = null;
            this.runningScheduledUpdates = false;
        }
    }

    protected void fireRemoveUpdate(DocumentEvent e) {
        NodeTree.NodeAndPosition napRr = this.reparseRecordTree != null ? this.reparseRecordTree.findNodeAtOrAfter(e.getOffset()) : null;
        int rpos = e.getOffset();
        int rlen = e.getLength();
        if (napRr != null && napRr.getEnd() == rpos) {
            napRr = napRr.nextSibling();
        }
        while (napRr != null && rlen > 0) {
            if (napRr.getPosition() < rpos) {
                if (napRr.getEnd() >= rpos + rlen) {
                    ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - rlen);
                    break;
                }
                int reduction = napRr.getEnd() - rpos;
                ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - reduction);
                rlen -= reduction;
                napRr = napRr.nextSibling();
                continue;
            }
            if (napRr.getPosition() == rpos) {
                if (napRr.getEnd() > rpos + rlen) {
                    ((ReparseRecord)napRr.getNode()).resize(napRr.getSize() - rlen);
                    break;
                }
                ((ReparseRecord)napRr.getNode()).remove();
                napRr = this.reparseRecordTree.findNodeAtOrAfter(e.getOffset());
                continue;
            }
            if (napRr.getPosition() >= rpos + rlen) {
                napRr.slide(-rlen);
                break;
            }
            if (napRr.getEnd() <= rpos + rlen) {
                NodeTree.NodeAndPosition nextRr = napRr.nextSibling();
                ((ReparseRecord)napRr.getNode()).remove();
                napRr = nextRr;
                continue;
            }
            int ramount = rpos + rlen - napRr.getPosition();
            napRr.slideStart(ramount);
            napRr.slide(-rlen);
            break;
        }
        MoeSyntaxEvent mse = new MoeSyntaxEvent(this, e);
        if (this.parsedNode != null) {
            this.parsedNode.textRemoved(this, 0, e.getOffset(), e.getLength(), (NodeStructureListener)mse);
        }
        this.recordEvent(e);
        super.fireRemoveUpdate((DocumentEvent)mse);
    }

    public void documentChanged() {
        this.repaintLines(0, this.getLength());
    }

    public void repaintLines(int offset, int length) {
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent((AbstractDocument)((Object)this), offset, length, DocumentEvent.EventType.CHANGE));
    }

    private static class EditEvent {
        int type;
        int offset;
        int length;

        private EditEvent() {
        }
    }

    private class PendingError {
        int position;
        int size;
        String errCode;

        PendingError(int position, int size, String errCode) {
            this.position = position;
            this.size = size;
            this.errCode = errCode;
        }
    }
}

