/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.prefmgr.PrefMgr;
import java.awt.EventQueue;

public class ReparseRunner
implements Runnable {
    private MoeEditor editor;
    private int procTime;

    public ReparseRunner(MoeEditor editor) {
        this.editor = editor;
        this.procTime = Config.isRaspberryPi() ? 150 : 5;
    }

    @Override
    public void run() {
        MoeSyntaxDocument document = this.editor.getSourceDocument();
        long begin = System.currentTimeMillis();
        if (PrefMgr.getScopeHighlightStrength() != 0 && document != null && document.pollReparseQueue()) {
            while (System.currentTimeMillis() - begin < (long)this.procTime && document.pollReparseQueue()) {
            }
            EventQueue.invokeLater(this);
        } else {
            this.editor.reparseRunnerFinished();
        }
    }
}

