/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CachedIntrospectionResults {
    private static final Log logger = LogFactory.getLog(CachedIntrospectionResults.class);
    static final Set<ClassLoader> acceptedClassLoaders = Collections.synchronizedSet(new HashSet());
    static final Map<Class, Object> classCache = Collections.synchronizedMap(new WeakHashMap());
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;

    public static void acceptClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            acceptedClassLoaders.add(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearClassLoader(ClassLoader classLoader) {
        Iterator<Object> it;
        if (classLoader == null) {
            return;
        }
        Object object = classCache;
        synchronized (object) {
            it = classCache.keySet().iterator();
            while (it.hasNext()) {
                Class beanClass = it.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(beanClass.getClassLoader(), classLoader)) continue;
                it.remove();
            }
        }
        object = acceptedClassLoaders;
        synchronized (object) {
            it = acceptedClassLoaders.iterator();
            while (it.hasNext()) {
                ClassLoader registeredLoader = (ClassLoader)it.next();
                if (!CachedIntrospectionResults.isUnderneathClassLoader(registeredLoader, classLoader)) continue;
                it.remove();
            }
        }
    }

    static CachedIntrospectionResults forClass(Class beanClass) throws BeansException {
        CachedIntrospectionResults results;
        Object value = classCache.get(beanClass);
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            results = (CachedIntrospectionResults)ref.get();
        } else {
            results = (CachedIntrospectionResults)value;
        }
        if (results == null) {
            boolean fullyCacheable;
            boolean bl = fullyCacheable = ClassUtils.isCacheSafe(beanClass, CachedIntrospectionResults.class.getClassLoader()) || CachedIntrospectionResults.isClassLoaderAccepted(beanClass.getClassLoader());
            if (fullyCacheable || !ClassUtils.isPresent(String.valueOf(beanClass.getName()) + "BeanInfo", beanClass.getClassLoader())) {
                results = new CachedIntrospectionResults(beanClass, fullyCacheable);
                classCache.put(beanClass, results);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not strongly caching class [" + beanClass.getName() + "] because it is not cache-safe");
                }
                results = new CachedIntrospectionResults(beanClass, true);
                classCache.put(beanClass, new WeakReference<CachedIntrospectionResults>(results));
            }
        }
        return results;
    }

    private static boolean isClassLoaderAccepted(ClassLoader classLoader) {
        ClassLoader[] acceptedLoaderArray;
        ClassLoader[] classLoaderArray = acceptedLoaderArray = acceptedClassLoaders.toArray(new ClassLoader[acceptedClassLoaders.size()]);
        int n = acceptedLoaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader registeredLoader = classLoaderArray[n2];
            if (CachedIntrospectionResults.isUnderneathClassLoader(classLoader, registeredLoader)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isUnderneathClassLoader(ClassLoader candidate, ClassLoader parent) {
        if (candidate == null) {
            return false;
        }
        if (candidate == parent) {
            return true;
        }
        ClassLoader classLoaderToCheck = candidate;
        while (classLoaderToCheck != null) {
            if ((classLoaderToCheck = classLoaderToCheck.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    private CachedIntrospectionResults(Class beanClass, boolean cacheFullMetadata) throws BeansException {
        try {
            PropertyDescriptor[] pds;
            if (logger.isTraceEnabled()) {
                logger.trace("Getting BeanInfo for class [" + beanClass.getName() + "]");
            }
            this.beanInfo = Introspector.getBeanInfo(beanClass);
            Class classToFlush = beanClass;
            do {
                Introspector.flushFromCaches(classToFlush);
            } while ((classToFlush = classToFlush.getSuperclass()) != null);
            if (logger.isTraceEnabled()) {
                logger.trace("Caching PropertyDescriptors for class [" + beanClass.getName() + "]");
            }
            this.propertyDescriptorCache = new LinkedHashMap<String, PropertyDescriptor>();
            PropertyDescriptor[] propertyDescriptorArray = pds = this.beanInfo.getPropertyDescriptors();
            int n = pds.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (!Class.class.equals(beanClass) || !"classLoader".equals(pd.getName())) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Found bean property '" + pd.getName() + "'" + (pd.getPropertyType() != null ? " of type [" + pd.getPropertyType().getName() + "]" : "") + (pd.getPropertyEditorClass() != null ? "; editor [" + pd.getPropertyEditorClass().getName() + "]" : ""));
                    }
                    if (cacheFullMetadata) {
                        pd = this.buildGenericTypeAwarePropertyDescriptor(beanClass, pd);
                    }
                    this.propertyDescriptorCache.put(pd.getName(), pd);
                }
                ++n2;
            }
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Failed to obtain BeanInfo for class [" + beanClass.getName() + "]", ex);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor pd = this.propertyDescriptorCache.get(name);
        if (pd == null && StringUtils.hasLength(name) && (pd = this.propertyDescriptorCache.get(String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1))) == null) {
            pd = this.propertyDescriptorCache.get(String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1));
        }
        return pd == null || pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
    }

    PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pds = new PropertyDescriptor[this.propertyDescriptorCache.size()];
        int i = 0;
        for (PropertyDescriptor pd : this.propertyDescriptorCache.values()) {
            pds[i] = pd instanceof GenericTypeAwarePropertyDescriptor ? pd : this.buildGenericTypeAwarePropertyDescriptor(this.getBeanClass(), pd);
            ++i;
        }
        return pds;
    }

    private PropertyDescriptor buildGenericTypeAwarePropertyDescriptor(Class beanClass, PropertyDescriptor pd) {
        try {
            return new GenericTypeAwarePropertyDescriptor(beanClass, pd.getName(), pd.getReadMethod(), pd.getWriteMethod(), pd.getPropertyEditorClass());
        }
        catch (IntrospectionException ex) {
            throw new FatalBeanException("Failed to re-introspect class [" + beanClass.getName() + "]", ex);
        }
    }
}

