/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.xml.namespace.QName;
import org.springframework.mock.web.portlet.MockPortletResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockStateAwareResponse
extends MockPortletResponse
implements StateAwareResponse {
    private WindowState windowState;
    private PortletMode portletMode;
    private final Map<String, String[]> renderParameters = new LinkedHashMap<String, String[]>();
    private final Map<QName, Serializable> events = new HashMap<QName, Serializable>();

    public MockStateAwareResponse() {
    }

    public MockStateAwareResponse(PortalContext portalContext) {
        super(portalContext);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (!CollectionUtils.contains(this.getPortalContext().getSupportedWindowStates(), (Object)windowState)) {
            throw new WindowStateException("WindowState not supported", windowState);
        }
        this.windowState = windowState;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (!CollectionUtils.contains(this.getPortalContext().getSupportedPortletModes(), (Object)portletMode)) {
            throw new PortletModeException("PortletMode not supported", portletMode);
        }
        this.portletMode = portletMode;
    }

    public PortletMode getPortletMode() {
        return this.portletMode;
    }

    public void setRenderParameters(Map<String, String[]> parameters) {
        Assert.notNull(parameters, "Parameters Map must not be null");
        this.renderParameters.clear();
        this.renderParameters.putAll(parameters);
    }

    public void setRenderParameter(String key, String value) {
        Assert.notNull(key, "Parameter key must not be null");
        Assert.notNull(value, "Parameter value must not be null");
        this.renderParameters.put(key, new String[]{value});
    }

    public void setRenderParameter(String key, String[] values) {
        Assert.notNull(key, "Parameter key must not be null");
        Assert.notNull(values, "Parameter values must not be null");
        this.renderParameters.put(key, values);
    }

    public String getRenderParameter(String key) {
        Assert.notNull(key, "Parameter key must not be null");
        String[] arr = this.renderParameters.get(key);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public String[] getRenderParameterValues(String key) {
        Assert.notNull(key, "Parameter key must not be null");
        return this.renderParameters.get(key);
    }

    public Iterator<String> getRenderParameterNames() {
        return this.renderParameters.keySet().iterator();
    }

    public Map<String, String[]> getRenderParameterMap() {
        return Collections.unmodifiableMap(this.renderParameters);
    }

    public void removePublicRenderParameter(String name) {
        this.renderParameters.remove(name);
    }

    public void setEvent(QName name, Serializable value) {
        this.events.put(name, value);
    }

    public void setEvent(String name, Serializable value) {
        this.events.put(new QName(name), value);
    }

    public Iterator<QName> getEventNames() {
        return this.events.keySet().iterator();
    }

    public Serializable getEvent(QName name) {
        return this.events.get(name);
    }

    public Serializable getEvent(String name) {
        return this.events.get(new QName(name));
    }
}

