/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.BlackBox;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelComboBox
extends JComboBox
implements BlackBox {
    protected UIManager.LookAndFeelInfo[] lafi = UIManager.getInstalledLookAndFeels();
    boolean changingItem = false;

    public LookAndFeelComboBox() {
        this.setEditable(false);
        this.changingItem = true;
        for (int i = 0; i < this.lafi.length; ++i) {
            this.addItem(this.lafi[i].getName());
        }
        this.changingItem = false;
    }

    public void addNotify() {
        super.addNotify();
        this.lafi = UIManager.getInstalledLookAndFeels();
        this.removeAllItems();
        this.changingItem = true;
        for (int i = 0; i < this.lafi.length; ++i) {
            this.addItem(this.lafi[i].getName());
        }
        this.setSelectedItem(UIManager.getLookAndFeel().getName());
        this.changingItem = false;
    }

    public void updateUI() {
        super.updateUI();
        this.changingItem = true;
        this.setSelectedItem(UIManager.getLookAndFeel().getName());
        this.changingItem = false;
    }

    protected Component findTopParent() {
        Container c = this;
        Container p = this.getParent();
        while (p != null) {
            c = p;
            p = c.getParent();
        }
        return c;
    }

    protected void selectedItemChanged() {
        super.selectedItemChanged();
        if (this.changingItem) {
            return;
        }
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.lafi.length) {
            try {
                UIManager.setLookAndFeel(this.lafi[index].getClassName());
            }
            catch (Exception x) {
                x.printStackTrace();
                this.changingItem = true;
                this.setSelectedItem(UIManager.getLookAndFeel().getName());
                this.changingItem = false;
                return;
            }
            SwingUtilities.updateComponentTreeUI(this.findTopParent());
        }
    }
}

