/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModelEvent;
import com.borland.jbcl.model.MatrixModelListener;
import com.borland.jbcl.model.Res;
import com.borland.jbcl.model.WritableMatrixModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class BasicMatrixContainer
implements WritableMatrixModel,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient Object[][] items = new Object[0][0];
    private int rows;
    private int columns;
    private boolean variableRows = true;
    private boolean variableColumns = true;
    private transient EventMulticaster modelListeners = new EventMulticaster();
    private boolean events = true;

    public BasicMatrixContainer() {
    }

    public BasicMatrixContainer(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.items = new Object[rows][columns];
    }

    public BasicMatrixContainer(Object[][] newItems) {
        this.rows = newItems.length;
        this.columns = this.rows > 0 ? newItems[0].length : 0;
        this.items = newItems;
    }

    public Object[][] getItems() {
        return this.items;
    }

    public void setItems(Object[][] newItems) {
        this.rows = newItems.length;
        this.columns = this.rows > 0 ? newItems[0].length : 0;
        this.items = newItems;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public Object get(int row, int column) {
        if (row >= 0 && row < this.rows && column >= 0 && column < this.columns) {
            return this.items[row][column];
        }
        return null;
    }

    public MatrixLocation find(Object data) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.items[r].length; ++c) {
                Object itemData = this.items[r][c];
                if (itemData != data && (itemData == null || !itemData.equals(data))) continue;
                return new MatrixLocation(r, c);
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.rows;
    }

    public void setRowCount(int rowCount) {
        if (!this.variableRows || rowCount == this.rows) {
            throw new IllegalStateException(Res.bundle.getString(23));
        }
        Object[][] newItems = new Object[rowCount][this.columns];
        int min = rowCount < this.rows ? rowCount : this.rows;
        for (int r = 0; r < min; ++r) {
            System.arraycopy(this.items[r], 0, newItems[r], 0, this.items[r].length);
        }
        this.rows = rowCount;
        this.items = newItems;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public int getColumnCount() {
        return this.columns;
    }

    public void setColumnCount(int columnCount) {
        if (!this.variableColumns || columnCount == this.columns) {
            throw new IllegalStateException(Res.bundle.getString(24));
        }
        Object[][] newItems = new Object[this.rows][columnCount];
        int min = columnCount < this.columns ? columnCount : this.columns;
        for (int r = 0; r < this.rows; ++r) {
            System.arraycopy(this.items[r], 0, newItems[r], 0, min);
        }
        this.columns = columnCount;
        this.items = newItems;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public void addModelListener(MatrixModelListener listener) {
        this.modelListeners.add((EventListener)listener);
    }

    public void removeModelListener(MatrixModelListener listener) {
        this.modelListeners.remove((EventListener)listener);
    }

    public boolean canSet(int row, int column, boolean startEdit) {
        return row >= 0 && row < this.rows && column >= 0 && column < this.columns;
    }

    public void set(int row, int column, Object data) {
        if (row >= 0 && row < this.rows && column >= 0 && column < this.columns) {
            this.items[row][column] = data;
            this.processModelEvent(new MatrixModelEvent(this, 17, new MatrixLocation(row, column)));
        }
    }

    public void touched(int row, int column) {
        if (row >= 0 && row < this.rows && column >= 0 && column < this.columns) {
            this.processModelEvent(new MatrixModelEvent(this, 33, new MatrixLocation(row, column)));
        }
    }

    public boolean isVariableRows() {
        return this.variableRows;
    }

    public void setVariableRows(boolean variable) {
        this.variableRows = variable;
    }

    public void addRow() {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.bundle.getString(23));
        }
        Object[][] newItems = new Object[this.rows + 1][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            System.arraycopy(this.items[r], 0, newItems[r], 0, this.items[r].length);
        }
        this.items = newItems;
        ++this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 18, new MatrixLocation(this.rows - 1, 0)));
    }

    public void addRow(int aheadOf) {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.bundle.getString(23));
        }
        Object[][] newItems = new Object[this.rows + 1][this.columns];
        if (aheadOf == 0) {
            for (int r = 0; r < this.rows; ++r) {
                System.arraycopy(this.items[r], 0, newItems[r + 1], 0, this.items[r].length);
            }
        } else if (aheadOf >= 0 && aheadOf < this.rows) {
            int r;
            for (r = 0; r < aheadOf; ++r) {
                System.arraycopy(this.items[r], 0, newItems[r], 0, this.items[r].length);
            }
            for (r = aheadOf; r < this.rows; ++r) {
                System.arraycopy(this.items[r], 0, newItems[r + 1], 0, this.items[r].length);
            }
        } else {
            return;
        }
        this.items = newItems;
        ++this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 18, new MatrixLocation(aheadOf, 0)));
    }

    public void removeRow(int row) {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.bundle.getString(23));
        }
        Object[][] newItems = new Object[this.rows - 1][this.columns];
        if (row == 0) {
            for (int r = 0; r < this.rows - 1; ++r) {
                System.arraycopy(this.items[r + 1], 0, newItems[r], 0, this.items[r + 1].length);
            }
        } else if (row >= 0 && row < this.rows) {
            int r;
            for (r = 0; r < row; ++r) {
                System.arraycopy(this.items[r], 0, newItems[r], 0, this.items[r].length);
            }
            for (r = row; r < this.rows - 1; ++r) {
                System.arraycopy(this.items[r + 1], 0, newItems[r], 0, this.items[r + 1].length);
            }
        } else {
            return;
        }
        this.items = newItems;
        --this.rows;
        this.processModelEvent(new MatrixModelEvent(this, 34, new MatrixLocation(row, 0)));
    }

    public void removeAllRows() {
        if (!this.variableRows) {
            throw new IllegalStateException(Res.bundle.getString(23));
        }
        Object[][] newItems = new Object[0][this.columns];
        this.items = newItems;
        this.rows = 0;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public boolean isVariableColumns() {
        return this.variableColumns;
    }

    public void setVariableColumns(boolean variable) {
        this.variableColumns = variable;
    }

    public void addColumn() {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.bundle.getString(24));
        }
        Object[][] newItems = new Object[this.rows][this.columns + 1];
        for (int r = 0; r < this.rows; ++r) {
            newItems[r] = this.appendColumn(this.items[r]);
        }
        this.items = newItems;
        ++this.columns;
        this.processModelEvent(new MatrixModelEvent(this, 50, new MatrixLocation(0, this.columns - 1)));
    }

    public void addColumn(int aheadOf) {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.bundle.getString(24));
        }
        if (aheadOf >= 0 && aheadOf < this.columns) {
            Object[][] newItems = new Object[this.rows][this.columns + 1];
            for (int r = 0; r < this.rows; ++r) {
                newItems[r] = this.insertColumn(this.items[r], aheadOf);
            }
            this.items = newItems;
            ++this.columns;
            this.processModelEvent(new MatrixModelEvent(this, 50, new MatrixLocation(0, aheadOf)));
        }
    }

    public void removeColumn(int column) {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.bundle.getString(24));
        }
        if (column >= 0 && column < this.columns) {
            Object[][] newItems = new Object[this.rows][this.columns - 1];
            for (int r = 0; r < this.rows; ++r) {
                newItems[r] = this.deleteColumn(this.items[r], column);
            }
            this.items = newItems;
            --this.columns;
            this.processModelEvent(new MatrixModelEvent(this, 66, new MatrixLocation(0, column)));
        }
    }

    public void removeAllColumns() {
        if (!this.variableColumns) {
            throw new IllegalStateException(Res.bundle.getString(24));
        }
        Object[][] newItems = new Object[this.rows][0];
        this.items = newItems;
        this.columns = 0;
        this.processModelEvent(new MatrixModelEvent(this, 2));
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.processModelEvent(new MatrixModelEvent(this, 2));
            }
        }
    }

    protected void processModelEvent(MatrixModelEvent e) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)e);
        }
    }

    private Object[] insertColumn(Object[] row, int col) {
        Object[] newRow = new Object[row.length + 1];
        if (col == 0) {
            System.arraycopy(row, 0, newRow, 1, row.length);
        } else if (col == row.length) {
            System.arraycopy(row, 0, newRow, 0, row.length);
        } else {
            System.arraycopy(row, 0, newRow, 0, col);
            System.arraycopy(row, col, newRow, col + 1, row.length - col);
        }
        return newRow;
    }

    private Object[] appendColumn(Object[] row) {
        Object[] newRow = new Object[row.length + 1];
        System.arraycopy(row, 0, newRow, 0, row.length);
        return newRow;
    }

    private Object[] deleteColumn(Object[] row, int col) {
        Object[] newRow = new Object[row.length - 1];
        if (col == 0) {
            System.arraycopy(row, 1, newRow, 0, row.length - 1);
        } else if (col == newRow.length) {
            System.arraycopy(row, 0, newRow, 0, newRow.length);
        } else {
            System.arraycopy(row, 0, newRow, 0, col);
            System.arraycopy(row, col + 1, newRow, col, newRow.length - col);
        }
        return newRow;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[][] sItems = new Object[this.rows][this.columns];
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.columns; ++c) {
                if (!(this.items[r][c] instanceof Serializable)) continue;
                sItems[r][c] = this.items[r][c];
            }
        }
        s.writeObject(sItems);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.items = (Object[][])s.readObject();
    }

    static {
        serialVersionUID = 200L;
    }
}

