/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.ExceptionHandler;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.model.WritableVectorModel;
import java.awt.Component;
import java.util.EventListener;

public class VectorDataSetManager
implements WritableVectorModel,
VectorViewManager,
DataChangeListener,
ExceptionHandler {
    private DataSet dataSet;
    private DataSetModel dataSetModel;
    private boolean events = true;
    private transient EventMulticaster modelListeners = new EventMulticaster();

    public VectorDataSetManager(DataSet dataSet, Column column) {
        this(dataSet, column, null);
    }

    public VectorDataSetManager(DataSet dataSet, Column column, Component component) {
        this.dataSet = dataSet;
        this.dataSetModel = new DataSetModel(dataSet, column, component);
    }

    public Object get(int row) {
        return this.dataSetModel.get(row);
    }

    public int find(Object data) {
        return -1;
    }

    public int getCount() {
        return this.dataSetModel.getRowCount();
    }

    public void addModelListener(VectorModelListener listener) {
        this.modelListeners.add((EventListener)listener);
        if (this.modelListeners.getListenerCount() == 1) {
            this.dataSet.addDataChangeListener((DataChangeListener)this);
        }
    }

    public void removeModelListener(VectorModelListener listener) {
        this.modelListeners.remove((EventListener)listener);
        if (this.modelListeners.getListenerCount() == 0) {
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
        }
    }

    public boolean canSet(int row, boolean startEdit) {
        return this.dataSetModel.canSet(row, startEdit);
    }

    public void set(int index, Object data) {
        this.dataSetModel.set(index, data);
        this.processModelEvent(17, index);
    }

    public void touched(int index) {
        this.processModelEvent(33, index);
    }

    public boolean isVariableSize() {
        return true;
    }

    public void addItem(int aheadOf, Object data) {
        this.dataSetModel.addRow(aheadOf);
        this.dataSetModel.set(data);
    }

    public void addItem(Object data) {
        this.dataSetModel.addRow();
        this.dataSetModel.set(data);
    }

    public void remove(int index) {
        this.dataSetModel.removeRow(index);
    }

    public void removeAll() {
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.processModelEvent(2, 0);
            }
        }
    }

    public ItemPainter getPainter(int index, Object value, int state) {
        return this.dataSetModel.getPainter(index, value);
    }

    public ItemEditor getEditor(int index, Object value, int state) {
        return this.dataSetModel.getEditor();
    }

    private void processModelEvent(int id, int row) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)new VectorModelEvent(this, id, row));
        }
    }

    public void dataChanged(DataChangeEvent e) {
        switch (e.getID()) {
            case 1: {
                this.processModelEvent(18, e.getRowAffected());
                break;
            }
            case 2: {
                this.processModelEvent(34, e.getRowAffected());
                break;
            }
            case 3: 
            case 4: {
                this.processModelEvent(17, e.getRowAffected());
                break;
            }
            case 5: {
                this.processModelEvent(2, 0);
            }
        }
    }

    public void postRow(DataChangeEvent e) throws Exception {
    }

    public void handleException(Exception x) {
        this.dataSetModel.handleThisException(x);
    }
}

