/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.sql.monitor;

import com.borland.jbcl.sql.monitor.Res;
import com.borland.jbcl.sql.monitor.TextAreaStream;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MonitorPanel
extends JPanel
implements ActionListener,
ItemListener {
    public final int hlpMonitorPanel = 0;
    public final int hlpSourceDialog = 1;
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JTextArea textArea = new JTextArea(20, 80);
    protected JScrollPane scrollPane = new JScrollPane();
    protected JButton clearButton = new JButton(Res.bundle.getString(4));
    protected JButton saveButton = new JButton(Res.bundle.getString(2));
    protected JCheckBox enableOutputCheckbox = new JCheckBox(Res.bundle.getString(0));
    protected JPanel buttonPanel = new JPanel();
    protected GridLayout gridLayout = new GridLayout(1, 2);
    protected JPanel outerButtonPanel = new JPanel();
    protected JPanel southPanel = new JPanel();
    protected BorderLayout southPanelLayout = new BorderLayout();
    protected TextAreaStream textAreaStream = new TextAreaStream(this.textArea);

    public MonitorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        this.clearButton.setMnemonic(Res.bundle.getString(5).charAt(0));
        this.saveButton.setMnemonic(Res.bundle.getString(3).charAt(0));
        this.enableOutputCheckbox.setMnemonic(Res.bundle.getString(1).charAt(0));
        this.setLayout(this.borderLayout1);
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.gridLayout.setHgap(5);
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.clearButton);
        this.outerButtonPanel.add(this.buttonPanel);
        this.saveButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.southPanel.setLayout(this.southPanelLayout);
        this.southPanel.add((Component)this.outerButtonPanel, "South");
        this.southPanel.add((Component)this.enableOutputCheckbox, "Center");
        this.enableOutputCheckbox.setSelected(true);
        this.enableOutputCheckbox.addItemListener(this);
        this.textAreaStream.setEnabled(true);
        this.textArea.setEditable(false);
        this.scrollPane.getViewport().add(this.textArea);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.southPanel, "South");
    }

    public void setOutputEnabled(boolean outputEnabled) {
        this.textAreaStream.setEnabled(outputEnabled);
    }

    public boolean isOutputEnabled() {
        return this.textAreaStream.isEnabled();
    }

    public void setMaxLogSize(int length) {
        this.textAreaStream.setMaxLength(length);
    }

    public int getMaxLogSize() {
        return this.textAreaStream.getMaxLength();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.enableOutputCheckbox) {
            this.textAreaStream.setEnabled(this.enableOutputCheckbox.isSelected());
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveButton) {
            this.saveToFile();
        } else if (e.getSource() == this.clearButton) {
            if (this.textArea.getSelectionEnd() - this.textArea.getSelectionStart() == 0) {
                this.textArea.setText("");
            } else {
                this.textArea.replaceRange("", this.textArea.getSelectionStart(), this.textArea.getSelectionEnd());
            }
            this.textAreaStream.resetLength();
        }
    }

    private void saveToFile() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        int val = fileChooser.showSaveDialog(this);
        if (val == 0) {
            try {
                File file = new File(fileChooser.getSelectedFile().toString());
                if (file != null) {
                    PrintWriter stream = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file), 1024));
                    if (this.textArea.getSelectionEnd() - this.textArea.getSelectionStart() == 0) {
                        stream.println(this.textArea.getText());
                    } else {
                        stream.println(this.textArea.getSelectedText());
                    }
                    stream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

