/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class ChoiceItemEditor
extends Choice
implements ItemEditor,
KeyListener,
Serializable {
    public ChoiceItemEditor() {
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
        this.addKeyListener(this);
        this.enableEvents(16L);
    }

    public ChoiceItemEditor(String[] items) {
        this();
        for (int i = 0; i < items.length; ++i) {
            this.add(items[i]);
        }
    }

    public Object getValue() {
        return this.getSelectedItem();
    }

    public Component getComponent() {
        return this;
    }

    public void startEdit(Object data, Rectangle bounds, ItemEditSite site) {
        if (data != null) {
            this.select(data.toString());
        }
        this.changeBounds(bounds);
        if (site != null) {
            this.setBackground(site.getBackground());
            this.setForeground(site.getForeground());
            this.setFont(site.getFont());
        }
        this.setVisible(true);
        this.requestFocus();
    }

    public void changeBounds(Rectangle bounds) {
        FontMetrics fm;
        int height = 0;
        Font f = this.getFont();
        Graphics g = this.getGraphics();
        FontMetrics fontMetrics = fm = f != null && g != null ? g.getFontMetrics(f) : null;
        if (fm != null) {
            height = fm.getHeight() * (this.getItemCount() < 6 ? this.getItemCount() : 6);
        }
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height < height ? bounds.height : height);
    }

    public boolean canPost() {
        return true;
    }

    public void endEdit(boolean post) {
        this.setBounds(0, 0, 0, 0);
        this.setVisible(false);
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        int sel = this.getSelectedIndex();
        switch (code) {
            case 40: {
                if (e.isAltDown()) {
                    return;
                }
                if (sel < this.getItemCount() - 1) {
                    this.select(sel + 1);
                }
                e.consume();
                break;
            }
            case 38: {
                if (sel > 0) {
                    this.select(sel - 1);
                }
                e.consume();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        char s = this.getSelectedItem().toLowerCase().charAt(0);
        int[] matches = new int[]{};
        if (c != '\uffff') {
            for (int i = 0; i < this.getItemCount(); ++i) {
                String value = this.getItem(i).toLowerCase();
                if (value.length() <= 0 || value.charAt(0) != c) continue;
                if (s != c) {
                    this.select(i);
                    return;
                }
                int[] old = matches;
                matches = new int[old.length + 1];
                System.arraycopy(old, 0, matches, 0, old.length);
                matches[matches.length - 1] = i;
            }
            if (matches.length > 0) {
                int sel = this.getSelectedIndex();
                for (int i = 0; i < matches.length; ++i) {
                    if (matches[i] > sel) {
                        this.select(matches[i]);
                        return;
                    }
                    if (i != matches.length - 1 || matches[i] != sel) continue;
                    this.select(matches[0]);
                    return;
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501 && e.getX() < this.getSize().width - this.getSize().height) {
            if (e.getClickCount() % 2 == 0) {
                int last;
                int sel = this.getSelectedIndex();
                if (sel < (last = this.getItemCount() - 1)) {
                    this.select(sel + 1);
                } else if (sel == last) {
                    this.select(0);
                }
            }
            e.consume();
        }
        super.processMouseEvent(e);
    }
}

