/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.ItemFormatter;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.io.Serializable;

public class TextItemEditor
extends TextField
implements ItemEditor,
Serializable {
    private static final long serialVersionUID = 200L;
    ItemFormatter itemFormatter;
    int alignment;

    public TextItemEditor(int alignment, ItemFormatter itemFormatter) {
        this.itemFormatter = itemFormatter;
        this.alignment = alignment;
    }

    public TextItemEditor(int alignment) {
        this(alignment, null);
    }

    public TextItemEditor() {
        this(1, null);
    }

    public void startEdit(Object value, Rectangle bounds, ItemEditSite site) {
        String text;
        try {
            text = this.itemFormatter != null && value instanceof Variant ? this.itemFormatter.format(value) : (value != null ? value.toString() : "");
        }
        catch (InvalidFormatException ex) {
            text = "";
        }
        this.setText(text);
        if (site != null) {
            this.setBackground(site.getBackground());
            this.setForeground(site.getForeground());
            this.setFont(site.getFont());
        }
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        this.setVisible(true);
        Point clickPoint = site != null ? site.getEditClickPoint() : null;
        int position = 0;
        if (clickPoint == null && text != null) {
            position = text.length();
            this.select(0, position);
        } else if (text != null) {
            int i;
            FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            int[] widths = metrics.getWidths();
            int xClick = clickPoint.x - bounds.x;
            int x = 0;
            for (i = 0; i < text.length(); ++i) {
                int offset;
                int charWidth = text.charAt(i) < '\u0100' ? widths[text.charAt(i)] : metrics.charWidth(text.charAt(i));
                int n = offset = charWidth > 3 ? charWidth / 3 : 1;
                if (x + offset >= xClick) {
                    --i;
                    break;
                }
                if (x + charWidth - offset >= xClick) break;
                x += charWidth;
            }
            position = i;
            this.select(position, position);
        }
        this.requestFocus();
    }

    public void changeBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Object getValue() {
        if (this.itemFormatter != null) {
            try {
                Object object = this.itemFormatter.parse(this.getText());
                return object;
            }
            catch (InvalidFormatException x) {
                String string = this.getText();
                return string;
            }
        }
        return this.getText();
    }

    public Component getComponent() {
        return this;
    }

    public boolean canPost() {
        return true;
    }

    public void endEdit(boolean posted) {
    }

    static {
        serialVersionUID = 200L;
    }
}

