/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.ImmutableEventException;
import java.util.EventObject;

public class JCTraverseCellEvent
extends EventObject {
    public static final int TRAVERSE_CELL = 1;
    public static final int AFTER_TRAVERSE_CELL = 2;
    protected int type;
    protected int current_row;
    protected int current_column;
    protected int next_row;
    protected int next_column;
    protected int traverse_type;
    protected boolean cancelled = false;

    public JCTraverseCellEvent(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        super(object);
        this.type = n;
        this.current_row = n2;
        this.current_column = n3;
        this.next_row = n4;
        this.next_column = n5;
        this.traverse_type = n6;
    }

    public int getColumn() {
        return this.current_column;
    }

    public int getNextColumn() {
        return this.next_column;
    }

    public int getNextRow() {
        return this.next_row;
    }

    public int getRow() {
        return this.current_row;
    }

    public int getTraverseType() {
        return this.traverse_type;
    }

    public String getTraverseTypeString() {
        switch (this.traverse_type) {
            case 0: {
                return "POINTER";
            }
            case 1: {
                return "DOWN";
            }
            case 2: {
                return "UP";
            }
            case 3: {
                return "LEFT";
            }
            case 4: {
                return "RIGHT";
            }
            case 7: {
                return "HOME";
            }
            case 8: {
                return "END";
            }
            case 9: {
                return "TOP";
            }
            case 10: {
                return "BOTTOM";
            }
            case 11: {
                return "PROGRAMMATIC";
            }
        }
        return "";
    }

    public int getType() {
        return this.type;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        if (this.type == 2) {
            throw new ImmutableEventException("setCancelled is not available in afterResize");
        }
        this.cancelled = bl;
    }

    public void setNextColumn(int n) {
        if (this.type == 2) {
            throw new ImmutableEventException("setNextColumn is not available following AFTER_TRAVERSE_CELL");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Column locations must be >= 0");
        }
        this.next_column = n;
    }

    public void setNextRow(int n) {
        if (this.type == 2) {
            throw new ImmutableEventException("setNextRow is not available following AFTER_TRAVERSE_CELL");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Row locations must be >= 0");
        }
        this.next_row = n;
    }

    public String toString() {
        return "TRAVERSE [" + (this.type == 1 ? "traverseCell: " : "afterTraverseCell: ") + "cancelled=" + this.isCancelled() + " from " + "R" + this.current_row + "C" + this.current_column + " to R" + this.next_row + "C" + this.next_column + ", traverse:" + this.getTraverseTypeString() + "]";
    }
}

