/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class SpanHandler
implements Serializable {
    protected JCTable table;
    protected Vector spans;

    public void addSpannedRange(JCCellRange jCCellRange) throws IllegalArgumentException {
        if (this.spans == null) {
            this.spans = new Vector();
        }
        this.validateRange(this.spans, jCCellRange);
        if (this.table.componentHandler != null) {
            this.table.componentHandler.removeCellComponents();
        }
        this.spans.addElement(jCCellRange);
    }

    private boolean cellIsNotHidden(int n, int n2) {
        return !this.table.isRowHidden(n) && !this.table.isColumnHidden(n2);
    }

    /*
     * Unable to fully structure code
     */
    public void clearSpannedRanges() {
        if (this.spans != null && this.spans.size() != 0) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.removeSpannedRange((JCCellRange)this.spans.elementAt(0));
lbl4:
            // 2 sources

            ** while (this.spans.size() > 0)
        }
lbl5:
        // 1 sources

    }

    public JCCellRange getCompleteRange(int n, int n2, int n3, int n4) {
        if (this.spans != null && this.spans.size() > 0) {
            int n5 = 0;
            while (n5 < this.spans.size()) {
                JCCellRange jCCellRange = (JCCellRange)this.spans.elementAt(n5);
                if (jCCellRange.start_row < n) {
                    n = jCCellRange.start_row;
                }
                if (jCCellRange.end_row > n3) {
                    n3 = jCCellRange.end_row;
                }
                if (jCCellRange.start_column < n2) {
                    n2 = jCCellRange.start_column;
                }
                if (jCCellRange.end_column > n4) {
                    n4 = jCCellRange.end_column;
                }
                ++n5;
            }
        }
        return new JCCellRange(n, n2, n3, n4);
    }

    public JCCellRange getSpannedRange(int n, int n2) {
        if (this.spans == null) {
            return null;
        }
        int n3 = 0;
        int n4 = this.spans.size();
        while (n3 < n4) {
            JCCellRange jCCellRange = (JCCellRange)this.spans.elementAt(n3);
            if (jCCellRange.inside(n, n2)) {
                return jCCellRange;
            }
            ++n3;
        }
        return null;
    }

    public Collection getSpannedRanges() {
        if (this.spans == null) {
            return null;
        }
        return (Vector)this.spans.clone();
    }

    public boolean isControllingCell(JCCellRange jCCellRange, int n, int n2) {
        boolean bl = false;
        if (this.cellIsNotHidden(n, n2)) {
            bl = true;
            int n3 = jCCellRange.start_row;
            while (n3 < n + 1 && bl) {
                int n4 = jCCellRange.start_column;
                while (n4 < n2 + 1) {
                    if (this.cellIsNotHidden(n3, n4) && (n3 < n || n4 < n2)) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        return bl;
    }

    public void removeSpannedRange(JCCellRange jCCellRange) {
        if (this.spans == null) {
            return;
        }
        int n = 0;
        int n2 = this.spans.size();
        while (n < n2) {
            JCCellRange jCCellRange2 = (JCCellRange)this.spans.elementAt(n);
            if (jCCellRange2.equals(jCCellRange)) {
                this.spans.removeElementAt(n);
                return;
            }
            ++n;
        }
    }

    public void setSpannedRanges(Collection collection) throws IllegalArgumentException {
        this.spans = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addSpannedRange((JCCellRange)iterator.next());
        }
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public void validateAllRanges() throws IllegalArgumentException {
        if (this.spans == null || this.spans.size() == 0) {
            return;
        }
        boolean bl = true;
        Vector<JCCellRange> vector = new Vector<JCCellRange>();
        int n = 0;
        while (n < this.spans.size()) {
            JCCellRange jCCellRange = (JCCellRange)this.spans.elementAt(n);
            try {
                this.validateRange(vector, jCCellRange);
                vector.addElement(jCCellRange);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
            ++n;
        }
        this.spans = vector;
        if (!bl) {
            throw new IllegalArgumentException("one or more spanned cell ranges failed validation");
        }
    }

    protected void validateRange(Vector vector, JCCellRange jCCellRange) throws IllegalArgumentException {
        if (jCCellRange.start_row > jCCellRange.end_row || jCCellRange.start_column > jCCellRange.end_column) {
            String string = "End row/column must be greater than or equal to start row/column. " + jCCellRange;
            throw new IllegalArgumentException(string);
        }
        if (jCCellRange.start_row == -1 && jCCellRange.end_row != -1 || jCCellRange.start_column == -1 && jCCellRange.end_column != -1) {
            throw new IllegalArgumentException("cell range " + jCCellRange + " contains labels and cells");
        }
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            JCCellRange jCCellRange2 = (JCCellRange)vector.elementAt(n);
            if (jCCellRange2.overlaps(jCCellRange)) {
                throw new IllegalArgumentException("cell range " + jCCellRange + " overlaps an existing span");
            }
            ++n;
        }
        int n3 = this.table.getFrozenRows();
        int n4 = this.table.getFrozenColumns();
        if (n3 > 0 && jCCellRange.start_row < n3 && jCCellRange.end_row >= n3) {
            throw new IllegalArgumentException("cell range " + jCCellRange + " contains frozen and non-frozen cells");
        }
        if (n4 > 0 && jCCellRange.start_column < n4 && jCCellRange.end_column >= n4) {
            throw new IllegalArgumentException("cell range " + jCCellRange + " contains frozen and non-frozen cells");
        }
    }
}

