/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.CellRangeValue;
import com.klg.jclass.table.CellSizeHandler;
import com.klg.jclass.table.CellStyleModel;
import com.klg.jclass.table.JCTable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class TableChangeHandler
implements Serializable,
PropertyChangeListener {
    public static final int TABLE_RESET = 2;
    public static final int TABLE_REPAINT = 4;
    public static final int TABLE_LAYOUT = 8;
    public static final int TABLE_RECALC_ROW_HEIGHTS = 16;
    public static final int TABLE_RECALC_COLUMN_WIDTHS = 32;
    public static final int CELL_RECALC_HEIGHT = 64;
    public static final int CELL_RECALC_WIDTH = 128;
    public static final int CELL_REPAINT = 256;
    protected JCTable table;

    public TableChangeHandler(JCTable jCTable) {
        this.table = jCTable;
    }

    protected void process(int n) {
        this.process(n, -999, -999);
    }

    protected void process(int n, int n2, int n3) {
        if (!this.table.isDisplayable()) {
            return;
        }
        if (this.table.isRecalcRequired() || (n & 2) != 0) {
            this.table.adjustmentHandler.adjustOrigin();
            CellSizeHandler.resetDimensions(this.table);
            if (this.table.isRepaintEnabled()) {
                this.table.setRecalcRequired(false);
            }
            n = 12;
        }
        if ((n & 0x10) != 0) {
            if (n2 == -999 || n2 == -998) {
                CellSizeHandler.calcRowHeights(this.table, -1, Integer.MAX_VALUE, -1, Integer.MAX_VALUE);
            } else if (n2 == -997) {
                CellSizeHandler.calcRowHeights(this.table, 0, Integer.MAX_VALUE, -1, Integer.MAX_VALUE);
            } else {
                CellSizeHandler.calcRowHeights(this.table, n2, n2, -1, Integer.MAX_VALUE);
            }
            n |= 0xC;
        }
        if ((n & 0x20) != 0) {
            if (n3 == -999 || n3 == -998) {
                CellSizeHandler.calcColumnWidths(this.table, -1, Integer.MAX_VALUE, -1, Integer.MAX_VALUE);
            } else if (n3 == -997) {
                CellSizeHandler.calcColumnWidths(this.table, -1, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            } else {
                CellSizeHandler.calcColumnWidths(this.table, -1, Integer.MAX_VALUE, n3, n3);
            }
            n |= 0xC;
        }
        if ((n & 0x40) != 0 && n2 != -999 && CellSizeHandler.calcRowHeights(this.table, n2, n2, -1, Integer.MAX_VALUE)) {
            n |= 0xC;
        }
        if ((n & 0x80) != 0 && n3 != -999 && CellSizeHandler.calcColumnWidths(this.table, -1, Integer.MAX_VALUE, n3, n3)) {
            n |= 0xC;
        }
        if ((n & 0x100) != 0) {
            int n4 = n2;
            int n5 = n2;
            int n6 = n3;
            int n7 = n3;
            if (n4 == -998) {
                n4 = -1;
                n5 = Integer.MAX_VALUE;
            } else if (n4 == -997) {
                n4 = 0;
                n5 = Integer.MAX_VALUE;
            }
            if (n6 == -998) {
                n4 = -1;
                n5 = Integer.MAX_VALUE;
            } else if (n6 == -997) {
                n4 = 0;
                n5 = Integer.MAX_VALUE;
            }
            if (!this.table.isRepaintEnabled()) {
                this.table.setRepaintRequired(true);
            } else {
                this.table.getCellAreaHandler().getCellAreaRenderer().repaintRange(n4, n6, n5, n7);
            }
        }
        if (this.table.spanHandler != null && (this.table.frozen_rows > 0 || this.table.frozen_columns > 0)) {
            try {
                this.table.spanHandler.validateAllRanges();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(illegalArgumentException.getMessage());
            }
        }
        if ((n & 8) != 0) {
            if (this.table.isRepaintEnabled()) {
                this.table.layoutAreas();
                this.table.setRelayoutRequired(false);
            } else {
                this.table.setRelayoutRequired(true);
            }
        } else if (this.table.isRepaintEnabled() && this.table.isRelayoutRequired()) {
            this.table.layoutAreas();
            this.table.setRelayoutRequired(false);
        }
        if (this.table.needs_initial_traverse) {
            this.table.editTraverseHandler.traverseInitial();
            this.table.needs_initial_traverse = false;
            this.table.needs_initial_set_top_check = false;
            if (this.table.set_initial_top && this.table.current_row != this.table.getTopRow()) {
                this.table.setTopRow(this.table.getTopRow());
                this.table.set_initial_top = false;
            }
            this.table.needs_initial_set_left_check = false;
            if (this.table.set_initial_left && this.table.current_column != this.table.getLeftColumn()) {
                this.table.setLeftColumn(this.table.getLeftColumn());
                this.table.set_initial_left = false;
            }
        }
        if (this.table.isRepaintEnabled() && (n & 4) != 0) {
            if (this.table.componentHandler != null && this.table.componentHandler.isParentSetRequired()) {
                this.table.componentHandler.addComponentsToParent();
                this.table.componentHandler.setParentSetRequired(false);
            }
            if (this.table.store_image_enabled) {
                this.table.store_image = null;
            }
            this.table.repaint();
            this.table.setRepaintRequired(false);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof CellStyleModel) {
            CellStyleModel cellStyleModel = (CellStyleModel)propertyChangeEvent.getSource();
            Collection collection = this.table.getCellStyleRanges(cellStyleModel);
            if (propertyChangeEvent.getPropertyName().equals("styleFont")) {
                this.process(2);
            } else if (!this.table.isRepaintEnabled()) {
                this.table.setRepaintRequired(true);
            } else {
                Object object;
                Iterator iterator = collection.iterator();
                CellAreaRenderer cellAreaRenderer = this.table.getCellAreaHandler().getCellAreaRenderer();
                while (iterator.hasNext()) {
                    object = (CellRangeValue)iterator.next();
                    cellAreaRenderer.repaintRange(((CellRangeValue)object).start_row, ((CellRangeValue)object).start_column, ((CellRangeValue)object).end_row, ((CellRangeValue)object).end_column);
                }
                object = this.table.getCellStyles();
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    CellStyleModel cellStyleModel2 = (CellStyleModel)iterator2.next();
                    if (cellStyleModel2.getParentStyle() != cellStyleModel) continue;
                    PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(cellStyleModel2, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    this.propertyChange(propertyChangeEvent2);
                }
            }
        }
    }
}

