/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.beans.ColorEditor;
import com.klg.jclass.table.beans.ColorEditorSample;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ColorChooser
extends JDialog
implements ActionListener,
DocumentListener {
    private ColorEditor editor;
    private JTextField red;
    private JTextField green;
    private JTextField blue;
    private ColorEditorSample sample;
    private JButton buttonOK;

    ColorChooser(ColorEditor colorEditor) {
        super(new Frame(), "Select Custom Color", true);
        this.editor = colorEditor;
        Color color = colorEditor.getColor();
        if (color == null) {
            color = Color.black;
        }
        this.red = new JTextField(String.valueOf(color.getRed()), 4);
        this.green = new JTextField(String.valueOf(color.getGreen()), 4);
        this.blue = new JTextField(String.valueOf(color.getBlue()), 4);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("RGB color"));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel.add((Component)new JLabel("Red"), gridBagConstraints);
        jPanel.add((Component)this.red, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("Green"), gridBagConstraints);
        jPanel.add((Component)this.green, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel("Blue"), gridBagConstraints);
        jPanel.add((Component)this.blue, gridBagConstraints);
        this.sample = new ColorEditorSample(color);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(this.sample);
        this.buttonOK = new JButton("OK");
        JButton jButton = new JButton("Cancel");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.add(this.buttonOK);
        jPanel3.add(jButton);
        this.getContentPane().setLayout(new BorderLayout(10, 4));
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "East");
        this.getContentPane().add((Component)jPanel3, "South");
        this.red.getDocument().addDocumentListener(this);
        this.green.getDocument().addDocumentListener(this);
        this.blue.getDocument().addDocumentListener(this);
        jButton.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonOK) {
            this.editor.selectColor(this.sample.getColor());
        }
        ((Component)this).setVisible(false);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.sample.setColor(new Color(this.getColor(this.red), this.getColor(this.green), this.getColor(this.blue)));
    }

    private int getColor(JTextField jTextField) {
        try {
            int n = new Integer(jTextField.getText());
            if (n < 0) {
                n = 0;
            }
            if (n > 255) {
                n = 255;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.sample.setColor(new Color(this.getColor(this.red), this.getColor(this.green), this.getColor(this.blue)));
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.sample.setColor(new Color(this.getColor(this.red), this.getColor(this.green), this.getColor(this.blue)));
    }
}

