/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.beans.EnumString;
import com.klg.jclass.table.beans.LabelLayoutWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LabelLayoutEditor
extends TablePropertyEditor
implements ActionListener,
FocusListener,
ItemListener {
    protected JCheckBox rowLabelDisplay;
    protected JCheckBox columnLabelDisplay;
    protected JTextField rowLabelOffset;
    protected JTextField columnLabelOffset;
    protected JComboBox columnLabelPlacement;
    protected JComboBox rowLabelPlacement;
    protected static final String LEFT = "Left";
    protected static final String RIGHT = "Right";
    protected static final String TOP = "Top";
    protected static final String BOTTOM = "Bottom";
    protected static EnumString[] EnumRowPosition = new EnumString[]{new EnumString(2, "Left"), new EnumString(4, "Right")};
    protected static EnumString[] EnumColPosition = new EnumString[]{new EnumString(1, "Top"), new EnumString(3, "Bottom")};

    public LabelLayoutEditor() {
        super(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        this.textChanged(actionEvent);
        this.checkChanged(actionEvent);
    }

    private void checkChanged(ActionEvent actionEvent) {
        boolean bl;
        Object object = actionEvent.getSource();
        if (object.equals(this.rowLabelDisplay)) {
            bl = this.rowLabelDisplay.isSelected();
            this.tableView.setRowLabelDisplay(bl);
            this.rowLabelOffset.setEnabled(bl);
            this.rowLabelPlacement.setEnabled(bl);
        }
        if (!object.equals(this.columnLabelDisplay)) {
            return;
        }
        bl = this.columnLabelDisplay.isSelected();
        this.tableView.setColumnLabelDisplay(bl);
        this.columnLabelOffset.setEnabled(bl);
        this.columnLabelPlacement.setEnabled(bl);
        this.support.firePropertyChange("labelLayout", null, this.getValue());
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.textChanged(focusEvent);
    }

    public String getAsText() {
        return this.getValue().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getLabelLayout().getJavaInitializationString();
    }

    public Object getValue() {
        return this.tableView.getLabelLayout();
    }

    protected void init() {
        super.init(false);
        this.tableView.setSelectionPolicy(0);
    }

    private void itemChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.rowLabelPlacement)) {
            this.tableView.setRowLabelPlacement(TablePropertyEditor.toIntValue(EnumRowPosition, (String)this.rowLabelPlacement.getSelectedItem()));
        }
        if (!object.equals(this.columnLabelPlacement)) {
            return;
        }
        this.tableView.setColumnLabelPlacement(TablePropertyEditor.toIntValue(EnumColPosition, (String)this.columnLabelPlacement.getSelectedItem()));
        this.support.firePropertyChange("labelLayout", null, this.getValue());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        this.itemChanged(itemEvent);
    }

    protected JComponent makePropertyPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.rowLabelDisplay = new JCheckBox("Row label display");
        this.columnLabelDisplay = new JCheckBox("Column label display");
        LabelLayoutEditor labelLayoutEditor = this;
        labelLayoutEditor.getClass();
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel(labelLayoutEditor, "Label Display");
        groupPanel.setLayout(new GridBagLayout());
        groupPanel.add((Component)this.rowLabelDisplay, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)this.columnLabelDisplay, gridBagConstraints);
        this.rowLabelOffset = new JTextField("0", 2);
        this.columnLabelOffset = new JTextField("0", 2);
        LabelLayoutEditor labelLayoutEditor2 = this;
        labelLayoutEditor2.getClass();
        TablePropertyEditor.GroupPanel groupPanel2 = new TablePropertyEditor.GroupPanel(labelLayoutEditor2, "Labels Offset");
        groupPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel2.add((Component)new JLabel("Row"), gridBagConstraints);
        groupPanel2.add((Component)this.rowLabelOffset, gridBagConstraints);
        groupPanel2.add((Component)new JLabel("pixels  "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel2.add((Component)new JLabel("Column"), gridBagConstraints);
        groupPanel2.add((Component)this.columnLabelOffset, gridBagConstraints);
        groupPanel2.add((Component)new JLabel("pixels "), gridBagConstraints);
        this.columnLabelPlacement = new JComboBox();
        this.columnLabelPlacement.addItem(TOP);
        this.columnLabelPlacement.addItem(BOTTOM);
        this.rowLabelPlacement = new JComboBox();
        this.rowLabelPlacement.addItem(LEFT);
        this.rowLabelPlacement.addItem(RIGHT);
        LabelLayoutEditor labelLayoutEditor3 = this;
        labelLayoutEditor3.getClass();
        TablePropertyEditor.GroupPanel groupPanel3 = new TablePropertyEditor.GroupPanel(labelLayoutEditor3, "Labels Placement");
        groupPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        groupPanel3.add((Component)new JLabel("Row"), gridBagConstraints);
        groupPanel3.add((Component)this.rowLabelPlacement, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel3.add((Component)new JLabel("Column"), gridBagConstraints);
        groupPanel3.add((Component)this.columnLabelPlacement, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 10, 6));
        jPanel.add(groupPanel);
        jPanel.add(groupPanel2);
        jPanel.add(groupPanel3);
        this.rowLabelDisplay.addActionListener(this);
        this.columnLabelDisplay.addActionListener(this);
        this.rowLabelOffset.addActionListener(this);
        this.columnLabelOffset.addActionListener(this);
        this.rowLabelOffset.addFocusListener(this);
        this.columnLabelOffset.addFocusListener(this);
        this.rowLabelPlacement.addItemListener(this);
        this.columnLabelPlacement.addItemListener(this);
        return jPanel;
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        this.tableView.setLabelLayout((LabelLayoutWrapper)object);
        this.updateLabelLayout();
        super.setValue(object);
    }

    private void textChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object.equals(this.rowLabelOffset)) {
            this.tableView.setRowLabelOffset(TablePropertyEditor.getInt(this.rowLabelOffset.getText()));
        } else if (object.equals(this.columnLabelOffset)) {
            this.tableView.setColumnLabelOffset(TablePropertyEditor.getInt(this.columnLabelOffset.getText()));
        } else {
            return;
        }
        this.support.firePropertyChange("labelLayout", null, this.getValue());
    }

    protected void updateLabelLayout() {
        this.rowLabelDisplay.setSelected(this.tableView.isRowLabelDisplay());
        this.columnLabelDisplay.setSelected(this.tableView.isColumnLabelDisplay());
        this.columnLabelOffset.setText(String.valueOf(this.tableView.getColumnLabelOffset()));
        this.rowLabelOffset.setText(String.valueOf(this.tableView.getRowLabelOffset()));
        TablePropertyEditor.setSelectedItem(this.rowLabelPlacement, TablePropertyEditor.toString(EnumRowPosition, this.tableView.getRowLabelPlacement()));
        TablePropertyEditor.setSelectedItem(this.columnLabelPlacement, TablePropertyEditor.toString(EnumColPosition, this.tableView.getColumnLabelPlacement()));
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.updateLabelLayout();
        this.support.firePropertyChange("labelLayout", null, this.getValue());
    }
}

