/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCSelection;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.beans.EnumString;
import com.klg.jclass.table.beans.LiveTable;
import com.klg.jclass.table.beans.PropertyEditorTable;
import com.klg.jclass.table.data.JCBeanFileDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.klg.jclass.util.swing.JCMessageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public abstract class TablePropertyEditor
extends JPanel
implements PropertyEditor,
ActionListener,
ItemListener,
JCSelectListener,
FocusListener {
    protected PropertyEditorTable tableView = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Object initValue = null;
    protected String nl = " ";
    protected int selectionPolicy;
    protected static final int SELECT_NONE = 0;
    protected static final int SELECT_CELLS = 1;
    protected static final int SELECT_ALL = 2;
    protected static final int SELECT_COLUMNS = 3;
    protected static final int SHOW_COLUMNS = 4;
    protected JComboBox choiceRow = null;
    protected JComboBox choiceColumn = null;
    protected JTextField textRow = null;
    protected JTextField textColumn = null;
    protected JTextField textWidth = null;
    protected JTextField textHeight = null;
    protected JButton buttonResetAll = null;
    protected static String numberDelimiters = ",:- ";
    protected static final String ALLCELLS = "allcells";
    protected static final String ALL_CELLS = "all cells";
    protected static final String ALL = "all";
    protected static final String LABEL = "label";
    protected static final String MAXINT = "maxint";
    protected static final String NOVALUE = "novalue";
    protected static final String RANGE = "range";
    protected static EnumString[] EnumCells = new EnumString[]{new EnumString(-998, "all"), new EnumString(-997, "all cells"), new EnumString(-1, "label")};
    protected static EnumString[] EnumRange = new EnumString[]{new EnumString(-998, "all"), new EnumString(-997, "all cells"), new EnumString(-1, "label"), new EnumString(Integer.MAX_VALUE, "maxint"), new EnumString(-999, "novalue")};
    protected boolean updateComponents = true;
    private boolean messageBoxExposed = false;
    static /* synthetic */ Class class$java$awt$Frame;

    public TablePropertyEditor() {
        this(2);
    }

    public TablePropertyEditor(int n) {
        this.selectionPolicy = n;
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonResetAll)) {
            this.resetValue();
        } else {
            this.textChanged(actionEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this.selectionChanged(jCSelectEvent);
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    private void changeSelection() {
        JCCellRange jCCellRange = this.tableView.getRangedSelection();
        if (jCCellRange == null) {
            return;
        }
        this.updateComponents = false;
        this.enable(this.textColumn, this.setChoice(this.choiceColumn, jCCellRange.start_column), jCCellRange.start_column, jCCellRange.end_column);
        this.enable(this.textRow, this.setChoice(this.choiceRow, jCCellRange.start_row), jCCellRange.start_row, jCCellRange.end_row);
        this.updatePropertyPanel(jCCellRange);
        this.updateComponents = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void enable(JTextField jTextField, boolean bl, int n, int n2) {
        String string = n != n2 ? (n < n2 ? String.valueOf(n) + "," + n2 : String.valueOf(n2) + "," + n) : String.valueOf(n);
        jTextField.setEnabled(bl);
        jTextField.setText(bl ? string : "");
    }

    protected void errorMessageBox(String string) {
        if (this.messageBoxExposed) {
            return;
        }
        this.messageBoxExposed = true;
        JCMessageHelper.showError("LiveTable Bean Error", string);
        this.messageBoxExposed = false;
    }

    public Frame findParent() {
        return (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = TablePropertyEditor.class$("java.awt.Frame")), this);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.textChanged(focusEvent);
    }

    public abstract String getAsText();

    public Component getCustomEditor() {
        return this;
    }

    private static int getEnd(String string, String string2) {
        return string.equals(RANGE) ? TablePropertyEditor.getRangeValue((String)string2).end : TablePropertyEditor.toIntValue(EnumCells, string);
    }

    protected static int getFirstCell(int n) {
        return n == -998 ? -1 : (n == -997 ? 0 : n);
    }

    protected static int getInt(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public abstract String getJavaInitializationString();

    protected static RangeValue getRangeValue(String string) {
        return TablePropertyEditor.getRangeValue(string, numberDelimiters);
    }

    protected static RangeValue getRangeValue(String string, String string2) {
        if ((string = string.trim()).length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            if (stringTokenizer.hasMoreTokens()) {
                int n;
                int n2 = TablePropertyEditor.toIntValue(EnumRange, stringTokenizer.nextToken());
                int n3 = n = stringTokenizer.hasMoreTokens() ? TablePropertyEditor.toIntValue(EnumRange, stringTokenizer.nextToken()) : n2;
                if (n2 != Integer.MIN_VALUE && n != Integer.MIN_VALUE) {
                    return new RangeValue(n2, n);
                }
            }
        }
        throw new IllegalArgumentException("Invalid style property string value: " + string);
    }

    protected static int getStart(String string, String string2) {
        return string.equals(RANGE) ? TablePropertyEditor.getRangeValue((String)string2).start : TablePropertyEditor.toIntValue(EnumCells, string);
    }

    public PropertyEditorTable getTableView() {
        return this.tableView;
    }

    public String[] getTags() {
        return null;
    }

    public abstract Object getValue();

    protected void init() {
        this.init(false);
    }

    protected void init(boolean bl) {
        this.tableView = new PropertyEditorTable(bl);
        this.tableView.setName("tableView");
        this.tableView.clearSelectedCells();
        this.tableView.setAllowCellResize(0);
        this.tableView.setColumnLabelDisplay(true);
        this.tableView.setRowLabelDisplay(true);
        this.tableView.setPixelWidth(-998, 33001);
        this.tableView.setPixelHeight(-998, 33001);
        this.tableView.setSelectionModel(new PropertyEditorSelection(this.tableView));
        this.tableView.setSelectionPolicy(this.selectionPolicy == 0 ? 0 : 2);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(6);
        borderLayout.setHgap(6);
        this.setLayout(borderLayout);
        this.add("North", this.makePropertyPanel());
        this.add("Center", this.tableView);
        this.add("East", this.makeControlPanel());
        this.updateSizePanel();
        this.tableView.addSelectListener(this);
        this.textWidth.addFocusListener(this);
        this.textHeight.addFocusListener(this);
        this.textWidth.addActionListener(this);
        this.textHeight.addActionListener(this);
    }

    protected static void initComboBox(JComboBox jComboBox, EnumString[] enumStringArray) {
        int n = 0;
        while (n < enumStringArray.length) {
            jComboBox.addItem(enumStringArray[n].name);
            ++n;
        }
    }

    public boolean isPaintable() {
        return true;
    }

    private void itemChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object.equals(this.choiceRow) || object.equals(this.choiceColumn)) {
            JCCellRange jCCellRange = this.tableView.getSelectedRange();
            if (jCCellRange == null) {
                return;
            }
            if (object.equals(this.choiceRow)) {
                this.enable(this.textRow, ((String)this.choiceRow.getSelectedItem()).equals(RANGE), jCCellRange.start_row, jCCellRange.end_row);
            } else if (object.equals(this.choiceColumn)) {
                this.enable(this.textColumn, ((String)this.choiceColumn.getSelectedItem()).equals(RANGE), jCCellRange.start_column, jCCellRange.end_column);
            }
            this.updateSelection();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.itemChanged(itemEvent);
    }

    protected JComponent makeControlPanel() {
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        jPanel.setLayout(borderLayout);
        if (this.selectionPolicy != 0 && this.selectionPolicy != 4) {
            jPanel.add("North", this.makeSelectionPanel());
        }
        jPanel.add("South", this.makeSizeResetPanel());
        return jPanel;
    }

    protected abstract JComponent makePropertyPanel();

    protected JComponent makeSelectionPanel() {
        this.choiceRow = new JComboBox();
        this.choiceColumn = new JComboBox();
        this.textRow = new JTextField("0", 5);
        this.textColumn = new JTextField("0", 5);
        if (this.selectionPolicy == 3) {
            this.choiceRow.addItem(ALL);
        } else {
            this.choiceRow.addItem(RANGE);
            this.choiceRow.addItem(ALL_CELLS);
            if (this.selectionPolicy == 2) {
                this.choiceRow.addItem(ALL);
            }
            if (this.selectionPolicy == 2 || this.selectionPolicy == 1) {
                this.choiceRow.addItem(LABEL);
            }
        }
        this.choiceColumn.addItem(RANGE);
        this.choiceColumn.addItem(ALL_CELLS);
        if (this.selectionPolicy == 2 || this.selectionPolicy == 3) {
            this.choiceColumn.addItem(ALL);
        }
        if (this.selectionPolicy == 2 || this.selectionPolicy == 1 || this.selectionPolicy == 3) {
            this.choiceColumn.addItem(LABEL);
        }
        GroupPanel groupPanel = new GroupPanel("Selected region");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)new JLabel("Row"), gridBagConstraints);
        groupPanel.add((Component)this.choiceRow, gridBagConstraints);
        groupPanel.add((Component)this.textRow, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)new JLabel("Column"), gridBagConstraints);
        groupPanel.add((Component)this.choiceColumn, gridBagConstraints);
        groupPanel.add((Component)this.textColumn, gridBagConstraints);
        this.choiceRow.addItemListener(this);
        this.choiceColumn.addItemListener(this);
        this.textRow.addFocusListener(this);
        this.textColumn.addFocusListener(this);
        this.textRow.addActionListener(this);
        this.textColumn.addActionListener(this);
        return groupPanel;
    }

    protected JComponent makeSizeResetPanel() {
        this.textWidth = new JTextField(3);
        this.textHeight = new JTextField(3);
        this.buttonResetAll = new JButton("Reset All");
        GroupPanel groupPanel = new GroupPanel("Table size");
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        groupPanel.add((Component)this.textHeight, gridBagConstraints);
        groupPanel.add((Component)new JLabel("rows"), gridBagConstraints);
        groupPanel.add((Component)this.textWidth, gridBagConstraints);
        groupPanel.add((Component)new JLabel("columns"), gridBagConstraints);
        gridBagConstraints.fill = 2;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(this.buttonResetAll);
        JPanel jPanel2 = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(6);
        jPanel2.setLayout(borderLayout);
        jPanel2.add("Center", groupPanel);
        jPanel2.add("South", jPanel);
        this.buttonResetAll.addActionListener(this);
        return jPanel2;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getAsText();
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x + 2, rectangle.y + rectangle.height - n);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private void resetValue() {
        if (this.initValue != null) {
            this.setValue(this.initValue);
            TableDataModel tableDataModel = this.tableView.getDataSource();
            this.updatePropertyPanel(this.tableView.getSelectedRange());
        }
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    private void selectionChanged(JCSelectEvent jCSelectEvent) {
        if (jCSelectEvent.getAction() == 3) {
            return;
        }
        this.changeSelection();
    }

    public void setAsText(String string) {
        this.setValue(string);
    }

    protected boolean setChoice(JComboBox jComboBox, int n) {
        if (n == -998) {
            TablePropertyEditor.setSelectedItem(jComboBox, ALL);
        } else if (n == -997) {
            TablePropertyEditor.setSelectedItem(jComboBox, ALL_CELLS);
        } else if (n == -1) {
            TablePropertyEditor.setSelectedItem(jComboBox, LABEL);
        } else {
            TablePropertyEditor.setSelectedItem(jComboBox, RANGE);
            return true;
        }
        return false;
    }

    protected static void setSelected(JCheckBox jCheckBox, boolean bl) {
        if (jCheckBox.isSelected() != bl) {
            jCheckBox.setSelected(bl);
        }
    }

    protected static void setSelected(JRadioButton jRadioButton, boolean bl) {
        if (!jRadioButton.isSelected()) {
            jRadioButton.setSelected(bl);
        }
    }

    protected static void setSelectedItem(JComboBox jComboBox, String string) {
        if (!string.equals((String)jComboBox.getSelectedItem())) {
            jComboBox.setSelectedItem(string);
        }
    }

    public void setValue(Object object) {
        if (this.initValue == null) {
            this.initValue = object;
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    private void textChanged(EventObject eventObject) {
        Object object = eventObject.getSource();
        if (object.equals(this.textHeight)) {
            int n = TablePropertyEditor.getInt(this.textHeight.getText());
            if (n == LiveTable.getNumEditorRows()) {
                return;
            }
            LiveTable.setNumEditorRows(n);
            TableDataModel tableDataModel = this.tableView.getDataSource();
            int n2 = ((JCVectorDataSource)tableDataModel).getNumRows();
            if (tableDataModel instanceof JCVectorDataSource && n != n2) {
                if (n < n2) {
                    int n3 = n2 - n;
                    ((JCVectorDataSource)tableDataModel).deleteRows(n2 - n3, n3);
                } else if (n > n2) {
                    int n4 = n - n2;
                    Vector<String> vector = new Vector<String>();
                    int n5 = 0;
                    while (n5 < ((JCVectorDataSource)tableDataModel).getNumColumns()) {
                        vector.addElement("Cell");
                        ++n5;
                    }
                    int n6 = 0;
                    while (n6 < n4) {
                        ((JCVectorDataSource)tableDataModel).addRow(Integer.MAX_VALUE, "Row: " + (n2 + n6), vector);
                        ++n6;
                    }
                }
            }
        } else if (object.equals(this.textWidth)) {
            int n = TablePropertyEditor.getInt(this.textWidth.getText());
            if (n == LiveTable.getNumEditorColumns()) {
                return;
            }
            LiveTable.setNumEditorColumns(n);
            TableDataModel tableDataModel = this.tableView.getDataSource();
            int n7 = ((JCVectorDataSource)tableDataModel).getNumColumns();
            if (tableDataModel instanceof JCVectorDataSource && n != n7) {
                if (n < n7) {
                    int n8 = n7 - n;
                    ((JCVectorDataSource)tableDataModel).deleteColumns(n7 - n8, n8);
                } else if (n > n7) {
                    int n9 = n - n7;
                    Vector<String> vector = new Vector<String>();
                    int n10 = 0;
                    while (n10 < ((JCVectorDataSource)tableDataModel).getNumRows()) {
                        vector.addElement("Cell");
                        ++n10;
                    }
                    int n11 = 0;
                    while (n11 < n9) {
                        ((JCVectorDataSource)tableDataModel).addColumn(Integer.MAX_VALUE, "Col: " + (n7 + n11), vector);
                        ++n11;
                    }
                }
            }
        } else if (object.equals(this.textRow) || object.equals(this.textColumn)) {
            this.updateSelection();
        }
    }

    protected static int toIntValue(EnumString[] enumStringArray, String string) {
        return PropertyEditorTable.toIntValue(enumStringArray, string);
    }

    protected static String toString(EnumString[] enumStringArray, int n) {
        return PropertyEditorTable.toString(enumStringArray, n);
    }

    protected abstract void updatePropertyPanel(JCCellRange var1);

    protected void updateSelection() {
        int n = TablePropertyEditor.getStart((String)this.choiceRow.getSelectedItem(), this.textRow.getText());
        int n2 = TablePropertyEditor.getEnd((String)this.choiceRow.getSelectedItem(), this.textRow.getText());
        int n3 = TablePropertyEditor.getStart((String)this.choiceColumn.getSelectedItem(), this.textColumn.getText());
        int n4 = TablePropertyEditor.getEnd((String)this.choiceColumn.getSelectedItem(), this.textColumn.getText());
        if (n == Integer.MIN_VALUE || n == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE || n4 == Integer.MIN_VALUE || n == -1 && n3 == -1) {
            this.errorMessageBox("The selected region is invalid.");
            this.changeSelection();
            return;
        }
        this.updateSelection(n, n3, n2, n4);
    }

    protected void updateSelection(int n, int n2, int n3, int n4) {
        if (n3 == -999) {
            n3 = n;
        }
        if (n4 == -999) {
            n4 = n2;
        }
        if (n == -999 || n2 == -999) {
            this.tableView.clearSelectedCells();
        } else {
            JCCellRange jCCellRange;
            this.tableView.clearSelectedCells();
            JCCellRange jCCellRange2 = new JCCellRange(n, n2, n3, n4);
            if (jCCellRange2.start_row == -998) {
                jCCellRange2.start_row = -1;
                jCCellRange2.end_row = Integer.MAX_VALUE;
            }
            if (jCCellRange2.start_column == -998) {
                jCCellRange2.start_column = -1;
                jCCellRange2.end_column = Integer.MAX_VALUE;
            }
            if (jCCellRange2.start_row == -997) {
                jCCellRange2.start_row = 0;
                jCCellRange2.end_row = this.tableView.getNumRows() - 1;
            }
            if (jCCellRange2.start_column == -997) {
                jCCellRange2.start_column = 0;
                jCCellRange2.end_column = this.tableView.getNumColumns() - 1;
            }
            if ((jCCellRange = this.tableView.getSelectedRange()) == null || !jCCellRange2.equals(jCCellRange)) {
                this.tableView.setSelectedCells(jCCellRange2);
                this.updatePropertyPanel(this.tableView.getSelectedRange());
            }
        }
    }

    protected void updateSize() {
        if (this.updateTableSize()) {
            this.updateSizePanel();
        }
    }

    protected void updateSizePanel() {
        TableDataModel tableDataModel = this.tableView.getDataSource();
        boolean bl = tableDataModel instanceof JCBeanFileDataSource ^ true;
        this.enable(this.textWidth, bl, 0, 0);
        this.enable(this.textHeight, bl, 0, 0);
        if (bl) {
            String string = String.valueOf(((JCVectorDataSource)tableDataModel).getNumRows());
            String string2 = String.valueOf(((JCVectorDataSource)tableDataModel).getNumColumns());
            if (string.compareTo(this.textHeight.getText()) != 0) {
                this.textHeight.setText(string);
            }
            if (string2.compareTo(this.textWidth.getText()) != 0) {
                this.textWidth.setText(string2);
            }
        }
    }

    protected boolean updateTableSize() {
        boolean bl = false;
        TableDataModel tableDataModel = this.tableView.getDataSource();
        if (tableDataModel instanceof JCVectorDataSource) {
            int n = LiveTable.getNumEditorColumns();
            if (((JCVectorDataSource)tableDataModel).getNumColumns() != n) {
                ((JCVectorDataSource)tableDataModel).setNumColumns(n);
                bl = true;
            }
            int n2 = LiveTable.getNumEditorRows();
            if (((JCVectorDataSource)tableDataModel).getNumRows() != n2) {
                ((JCVectorDataSource)tableDataModel).setNumRows(n2);
                bl = true;
            }
        }
        return bl;
    }

    class PropertyEditorSelection
    extends JCSelection {
        protected boolean labelSelection = false;

        public PropertyEditorSelection() {
        }

        public PropertyEditorSelection(JCTable jCTable) {
            super(jCTable);
        }

        public boolean isSelected(int n, int n2) {
            return super.isSelected(n, n2);
        }

        public boolean setSelection(JCCellRange jCCellRange) {
            if (TablePropertyEditor.this.selectionPolicy == 1) {
                if (jCCellRange.start_row == -1 && jCCellRange.end_row == Integer.MAX_VALUE) {
                    jCCellRange.start_row = 0;
                }
                if (jCCellRange.start_column == -1 && jCCellRange.end_column == Integer.MAX_VALUE) {
                    jCCellRange.start_column = 0;
                }
            }
            return super.setSelection(jCCellRange);
        }
    }

    protected class GroupPanel
    extends JPanel {
        GroupPanel(String string) {
            this.setBorder(BorderFactory.createTitledBorder(string));
        }
    }

    protected static class RangeValue {
        int start;
        int end;

        RangeValue(int n, int n2) {
            this.start = n;
            this.end = n2;
        }
    }
}

