/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.OperandMismatchException;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Product
extends Operation {
    public Product(Expression expression) {
        super(expression);
    }

    public Product(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Product(Expression expression, Number number) {
        super(expression, number);
    }

    public Product(Number number, Expression expression) {
        super(number, expression);
    }

    public Product(Number number, Number number2) {
        super(number, number2);
    }

    private MathValue doProduct(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathScalar) {
            MathScalar mathScalar = (MathScalar)mathValue;
            MathScalar mathScalar2 = (MathScalar)mathValue2;
            Number number = this.productSimple(mathScalar.realValue, mathScalar2.realValue);
            return new MathScalar(number);
        }
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathVector || mathValue instanceof MathVector && mathValue2 instanceof MathScalar) {
            MathVector mathVector;
            MathScalar mathScalar;
            if (mathValue instanceof MathScalar) {
                mathScalar = (MathScalar)mathValue;
                mathVector = (MathVector)mathValue2;
            } else {
                mathVector = (MathVector)mathValue;
                mathScalar = (MathScalar)mathValue2;
            }
            Number[] numberArray = new Number[mathVector.size];
            int n = 0;
            while (n < mathVector.size) {
                numberArray[n] = this.productSimple(mathScalar.realValue, mathVector.realValues[n]);
                ++n;
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathMatrix || mathValue instanceof MathMatrix && mathValue2 instanceof MathScalar) {
            MathMatrix mathMatrix;
            MathScalar mathScalar;
            if (mathValue instanceof MathScalar) {
                mathScalar = (MathScalar)mathValue;
                mathMatrix = (MathMatrix)mathValue2;
            } else {
                mathMatrix = (MathMatrix)mathValue;
                mathScalar = (MathScalar)mathValue2;
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix.columns];
            int n = 0;
            while (n < mathMatrix.rows) {
                int n2 = 0;
                while (n2 < mathMatrix.columns) {
                    numberArray[n][n2] = this.productSimple(mathScalar.realValue, mathMatrix.realValues[n][n2]);
                    ++n2;
                }
                ++n;
            }
            return new MathMatrix(numberArray);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathVector) {
            MathVector mathVector = (MathVector)mathValue;
            MathVector mathVector2 = (MathVector)mathValue2;
            if (mathVector.size != mathVector2.size) {
                throw new OperandMismatchException("Cannot compute the dot product of different-sized vectors");
            }
            Number number = new Integer(0);
            int n = 0;
            while (n < mathVector.size) {
                number = this.sum(number, this.productSimple(mathVector.realValues[n], mathVector2.realValues[n]));
                ++n;
            }
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathMatrix) {
            MathVector mathVector = (MathVector)mathValue;
            MathMatrix mathMatrix = (MathMatrix)mathValue2;
            if (mathVector.size != mathMatrix.rows) {
                throw new OperandMismatchException("Vector and matrix sizes do not match");
            }
            Number[] numberArray = new Number[mathMatrix.columns];
            int n = 0;
            while (n < mathMatrix.columns) {
                numberArray[n] = new Integer(0);
                int n3 = 0;
                while (n3 < mathVector.size) {
                    numberArray[n] = this.sum(numberArray[n], this.productSimple(mathVector.realValues[n3], mathMatrix.realValues[n3][n]));
                    ++n3;
                }
                ++n;
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathVector) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathVector mathVector = (MathVector)mathValue2;
            if (mathVector.size != mathMatrix.columns) {
                throw new OperandMismatchException("Vector and matrix sizes do not match");
            }
            Number[] numberArray = new Number[mathMatrix.rows];
            int n = 0;
            while (n < mathMatrix.rows) {
                numberArray[n] = new Integer(0);
                int n4 = 0;
                while (n4 < mathVector.size) {
                    numberArray[n] = this.sum(numberArray[n], this.productSimple(mathMatrix.realValues[n][n4], mathVector.realValues[n4]));
                    ++n4;
                }
                ++n;
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathMatrix) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathMatrix mathMatrix2 = (MathMatrix)mathValue2;
            if (mathMatrix.columns != mathMatrix2.rows) {
                throw new OperandMismatchException("Cannot multiply matrices of non-complementary sizes");
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix2.columns];
            int n = 0;
            while (n < mathMatrix.rows) {
                int n5 = 0;
                while (n5 < mathMatrix2.columns) {
                    numberArray[n][n5] = this.productSimple(mathMatrix.realValues[n][n5], mathMatrix2.realValues[n][n5]);
                    numberArray[n][n5] = new Integer(0);
                    int n6 = 0;
                    while (n6 < mathMatrix.columns) {
                        numberArray[n][n5] = this.sum(numberArray[n][n5], this.productSimple(mathMatrix.realValues[n][n6], mathMatrix2.realValues[n6][n5]));
                        ++n6;
                    }
                    ++n5;
                }
                ++n;
            }
            return new MathMatrix(numberArray);
        }
        throw new OperandMismatchException("Cannot multiply given operands");
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Product is not defined on zero operands");
        }
        MathValue mathValue = null;
        MathValue mathValue2 = null;
        if (this.leftOperand != null) {
            mathValue = this.evaluateOperand(this.leftOperand);
        }
        if (this.rightOperand != null) {
            mathValue2 = this.evaluateOperand(this.rightOperand);
        }
        if (this.leftOperand == null) {
            return mathValue2;
        }
        if (this.rightOperand == null) {
            return mathValue;
        }
        return this.doProduct(mathValue, mathValue2);
    }

    private MathValue evaluateOperand(Expression expression) {
        if (expression instanceof MathValue) {
            return (MathValue)expression;
        }
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            return this.evaluateOperand(expression.evaluate());
        }
        if (expression instanceof ExpressionList) {
            MathValue mathValue = null;
            Iterator iterator = ((ExpressionList)expression).iterator();
            while (iterator.hasNext()) {
                MathValue mathValue2 = this.evaluateOperand((Expression)iterator.next());
                mathValue = mathValue == null ? mathValue2 : this.doProduct(mathValue, mathValue2);
            }
            return mathValue;
        }
        throw new IllegalArgumentException("Unrecognized operand type to Product");
    }

    private Number productSimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() * number2.doubleValue());
        }
        return new Integer(number.intValue() * number2.intValue());
    }

    private Number sum(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() + number2.doubleValue());
        }
        return new Integer(number.intValue() + number2.intValue());
    }
}

