/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCCircularGauge;
import com.klg.jclass.swing.gauge.JCCircularScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCCenter
extends JComponent
implements Serializable {
    static final long serialVersionUID = -1082954384206749087L;
    protected JCCircularScale scale;
    protected Image image;
    protected Color foreground = Color.black;
    protected boolean scaleImage = true;
    protected double radius = 0.1;

    public JCCenter(JCCircularScale jCCircularScale) {
        this.scale = jCCircularScale;
        this.setForeground(this.foreground);
    }

    public JCCenter(JCCircularScale jCCircularScale, Color color, double d) {
        this.scale = jCCircularScale;
        this.radius = d;
        this.setForeground(color);
    }

    public JCCenter(JCCircularScale jCCircularScale, Color color, Image image) {
        this.scale = jCCircularScale;
        this.image = image;
        this.setForeground(color);
    }

    protected void drawDisc(Graphics graphics) {
        int n = 0;
        int n2 = 360;
        graphics.fillArc(0, 0, this.getWidth(), this.getHeight(), n, n2);
    }

    protected void drawImage(Graphics graphics, Image image, Rectangle rectangle) {
        JLabel jLabel = new JLabel();
        if (this.scaleImage) {
            graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.getForeground(), jLabel);
        } else {
            graphics.drawImage(image, 0, 0, this.getForeground(), jLabel);
        }
    }

    protected Shape getCenterShape() {
        Shape shape = null;
        JCCircularGauge jCCircularGauge = this.scale.getCircularGauge();
        double d = GaugeUtil.normalizeAngle(this.scale.getStartAngle());
        double d2 = GaugeUtil.normalizeAngle(this.scale.getStopAngle());
        if (this.scale.getPaintCompleteBackground()) {
            d = jCCircularGauge.getGaugeType().getStartAngle();
        } else if (d >= d2) {
            d2 += 360.0;
        }
        Rectangle rectangle = this.getBounds();
        if (jCCircularGauge.getGaugeType() == JCCircularGauge.GaugeType.FULL_CIRCLE || jCCircularGauge.getGaugeType() == JCCircularGauge.GaugeType.TOP_HALF_CIRCLE || jCCircularGauge.getGaugeType() == JCCircularGauge.GaugeType.LEFT_HALF_CIRCLE) {
            Ellipse2D.Double double_ = new Ellipse2D.Double();
            double_.setFrame(rectangle.x, rectangle.y, this.getWidth(), this.getHeight());
            shape = double_;
        } else {
            Polygon polygon = new Polygon();
            double d3 = 3.0;
            double d4 = this.radius * this.scale.getRadius();
            double d5 = d;
            while (d5 < d2) {
                polygon.addPoint((int)d4, (int)d5);
                d5 += d3;
            }
            polygon.addPoint((int)d4, (int)d2);
            int n = jCCircularGauge.getGaugeArea().getBounds().width;
            int n2 = jCCircularGauge.getGaugeArea().getBounds().height;
            int n3 = rectangle.x + this.getWidth() / 2;
            int n4 = rectangle.y + this.getHeight() / 2;
            Polygon polygon2 = new Polygon();
            polygon2.addPoint(n3, n4);
            int n5 = 0;
            while (n5 < polygon.npoints) {
                int n6 = n3 + (int)((double)polygon.xpoints[n5] * Math.cos((double)polygon.ypoints[n5] * 3.14 / 180.0));
                int n7 = n4 - (int)((double)polygon.xpoints[n5] * Math.sin((double)polygon.ypoints[n5] * 3.14 / 180.0));
                if (n6 > n) {
                    n6 = n;
                }
                if (n7 > n2) {
                    n7 = n2;
                }
                polygon2.addPoint(n6, n7);
                ++n5;
            }
            polygon2.addPoint(n3, n4);
            shape = polygon2;
        }
        return shape;
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getPreferredSize() {
        int n = (int)(this.scale.getRadius() * this.radius) * 2;
        return new Dimension(n, n);
    }

    public double getRadius() {
        return this.radius;
    }

    public JCCircularScale getScale() {
        return this.scale;
    }

    public boolean getScaleImage() {
        return this.scaleImage;
    }

    public void paintComponent(Graphics graphics) {
        if (!this.isVisible() || this.scale == null || this.scale.getMin() >= this.scale.getMax() || this.radius <= 0.0 && this.image == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.getBounds();
        graphics2.translate(-rectangle.x, -rectangle.y);
        Shape shape = graphics.getClip();
        Shape shape2 = this.getCenterShape();
        graphics2.setClip(shape2);
        if (this.image != null) {
            if (this.scaleImage) {
                this.drawImage(graphics2, this.image, rectangle);
            } else {
                this.drawImage(graphics2, this.image, rectangle);
            }
        } else {
            graphics2.fillArc(rectangle.x, rectangle.y, this.getWidth(), this.getHeight(), 0, 360);
        }
        graphics.setClip(shape);
        graphics2.dispose();
    }

    public void redraw() {
        if (this.scale.getGauge().getRepaintEnabled()) {
            this.repaint();
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }

    public void setRadius(double d) {
        if (d <= 0.0) {
            d = 0.0;
        }
        this.radius = d;
        this.revalidate();
    }

    public void setScaleImage(boolean bl) {
        this.scaleImage = bl;
        this.redraw();
    }
}

