/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.editors;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.JCCellEditorSupport;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.cell.JCKeyModifier;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class JCComboBoxCellEditor
extends JComboBox
implements JCCellEditor,
KeyListener {
    protected JCCellEditorSupport support = new JCCellEditorSupport();
    protected int[] values;
    protected boolean ignoreEnterKey = false;
    private AWTEvent initialEvent;
    private boolean showPopupLater = false;
    protected Object originalValue = null;
    protected JCKeyModifier[] key_modifiers = new JCKeyModifier[]{new JCKeyModifier(40, 16), new JCKeyModifier(38, 16)};

    public JCComboBoxCellEditor() {
        this.values = this.values;
        this.addKeyListener(this);
    }

    public JCComboBoxCellEditor(Object[] objectArray) {
        this(objectArray, null);
    }

    public JCComboBoxCellEditor(Object[] objectArray, int[] nArray) {
        super(objectArray);
        this.values = nArray;
        this.addKeyListener(this);
    }

    public void addCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.addCellEditorListener(jCCellEditorListener);
    }

    public void addNotify() {
        super.addNotify();
        if (this.initialEvent != null) {
            if (this.isVisible()) {
                try {
                    this.setPopupVisible(true);
                }
                catch (Exception exception) {}
            }
            this.initialEvent = null;
        }
    }

    public void cancelCellEditing() {
    }

    public Object getCellEditorValue() {
        if (this.values == null) {
            return this.getSelectedItem();
        }
        return new Integer(this.values[this.getSelectedIndex()]);
    }

    public Component getComponent() {
        return this;
    }

    private int getIndexFromValue(int n) {
        if (this.values == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.values.length) {
            if (this.values[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public JCKeyModifier[] getReservedKeys() {
        return this.key_modifiers;
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        if (aWTEvent != null && aWTEvent instanceof KeyEvent && ((KeyEvent)aWTEvent).getKeyCode() == 10) {
            this.ignoreEnterKey = true;
        }
        this.initialEvent = aWTEvent;
        if (this.values != null && object instanceof Integer) {
            this.setSelectedIndex(this.getIndexFromValue((Integer)object));
        } else {
            this.setSelectedItem(object);
        }
        this.originalValue = object;
        this.setBackground(jCCellInfo.getBackground());
        this.setForeground(jCCellInfo.getForeground());
        if (jCCellInfo.isEditable()) {
            this.setBackground(jCCellInfo.getBackground().brighter());
        }
        this.showPopupLater = !this.isEditable() && aWTEvent != null && aWTEvent instanceof MouseEvent && aWTEvent.getID() == 502;
    }

    public boolean isModified() {
        if (this.originalValue == null) {
            return this.getCellEditorValue() != null;
        }
        return this.originalValue.equals(this.getCellEditorValue()) ^ true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object var2_2 = null;
        if (keyEvent.getKeyCode() == 27) {
            this.support.fireCancelEditing(new JCCellEditorEvent(keyEvent));
        } else if (keyEvent.getKeyCode() == 10 && !this.ignoreEnterKey) {
            this.support.fireStopEditing(new JCCellEditorEvent(keyEvent));
        }
        this.ignoreEnterKey = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.showPopupLater) {
            this.showPopupLater = false;
            SwingUtilities.invokeLater(new PopupInvoker());
        }
    }

    public void removeCellEditorListener(JCCellEditorListener jCCellEditorListener) {
        this.support.removeCellEditorListener(jCCellEditorListener);
    }

    public boolean stopCellEditing() {
        return true;
    }

    private class PopupInvoker
    implements Runnable {
        PopupInvoker() {
        }

        public void run() {
            if (JCComboBoxCellEditor.this.isShowing() && !JCComboBoxCellEditor.this.isPopupVisible()) {
                JCComboBoxCellEditor.this.showPopup();
            }
        }
    }
}

