/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCCandleChartFormat;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class FastCandleChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    public static final int OPEN_SERIES_INDEX = 2;
    public static final int CLOSE_SERIES_INDEX = 3;
    protected JCCandleChartFormat cf = null;
    protected boolean isComplex = false;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;
    boolean useRubberBand = false;

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            this.isComplex = this.cf.isComplex();
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = this.xaxis.isLogarithmic();
            boolean bl5 = this.yaxis.isLogarithmic();
            Graphics graphics2 = graphics.create();
            int n = this.seriesList.size() / 4;
            int n2 = 0;
            while (n2 < n) {
                block29: {
                    JCChartStyle jCChartStyle;
                    JCChartStyle jCChartStyle2;
                    JCChartStyle jCChartStyle3;
                    JCLineStyle jCLineStyle;
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    block31: {
                        JCChartStyle jCChartStyle4;
                        block30: {
                            boolean bl6 = true;
                            n7 = Integer.MAX_VALUE;
                            n6 = Integer.MAX_VALUE;
                            boolean bl7 = true;
                            n5 = 0;
                            int n8 = 0;
                            n5 = 4 * n2;
                            n8 = 0;
                            while (n8 < 4) {
                                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n5);
                                if (!chartDataViewSeries.isVisible()) {
                                    bl7 = false;
                                    break;
                                }
                                if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                                    bl6 = false;
                                    break;
                                }
                                n7 = Math.min(n7, chartDataViewSeries.getFirstPoint());
                                n6 = Math.min(n6, chartDataViewSeries.getLastPoint());
                                ++n8;
                                ++n5;
                            }
                            if (!bl7 || !bl6) break block29;
                            n4 = 0;
                            n3 = 0;
                            jCChartStyle4 = this.cf.getHiloStyle(n2);
                            if (jCChartStyle4 == null) break block29;
                            jCLineStyle = jCChartStyle4.getLineStyle();
                            if (!this.isComplex) break block30;
                            jCChartStyle3 = this.cf.getRisingCandleStyle(n2);
                            if (jCChartStyle3 == null) break block29;
                            n4 = jCChartStyle3.getSymbolSize();
                            jCChartStyle2 = this.cf.getFallingCandleStyle(n2);
                            if (jCChartStyle2 == null) break block29;
                            n3 = jCChartStyle2.getSymbolSize();
                            jCChartStyle = this.cf.getCandleOutlineStyle(n2);
                            if (jCChartStyle != null) break block31;
                            break block29;
                        }
                        jCChartStyle3 = jCChartStyle4;
                        jCChartStyle2 = jCChartStyle4;
                        jCChartStyle = jCChartStyle4;
                        n3 = n4 = jCChartStyle4.getSymbolSize();
                    }
                    boolean bl8 = jCLineStyle.updateGraphics(graphics);
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n9 = n7;
                    while (n9 <= n6) {
                        block33: {
                            double d;
                            double d2;
                            double d3;
                            double d4;
                            double d5;
                            double d6;
                            double d7;
                            double d8;
                            block32: {
                                int n10 = 4 * n2;
                                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n10++);
                                double d9 = chartDataViewSeries.getX(n9);
                                double d10 = chartDataViewSeries.getY(n9);
                                chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n10++);
                                double d11 = chartDataViewSeries.getX(n9);
                                double d12 = chartDataViewSeries.getY(n9);
                                if (d10 < d12) {
                                    d8 = d9;
                                    d7 = d10;
                                    d9 = d11;
                                    d10 = d12;
                                    d11 = d8;
                                    d12 = d7;
                                }
                                chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n10++);
                                d6 = chartDataViewSeries.getX(n9);
                                d5 = chartDataViewSeries.getY(n9);
                                chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n10++);
                                d4 = chartDataViewSeries.getX(n9);
                                d3 = chartDataViewSeries.getY(n9);
                                bl = d5 < d3;
                                bl3 = (d10 == this.holeValue || d12 == this.holeValue || d9 == this.holeValue || d11 == this.holeValue || bl4 && d9 <= 0.0 || bl5 && d10 <= 0.0 || bl4 && d11 <= 0.0 || bl5 && d12 <= 0.0) ^ true;
                                bl2 = (d3 == this.holeValue || d5 == this.holeValue || d4 == this.holeValue || d6 == this.holeValue || bl4 && d4 <= 0.0 || bl5 && d3 <= 0.0 || bl4 && d6 <= 0.0 || bl5 && d5 <= 0.0) ^ true;
                                d8 = d9;
                                d7 = d10;
                                if (!bl3 || !bl8) break block32;
                                if (bl2) {
                                    d2 = bl ? d4 : d6;
                                    d = bl ? d3 : d5;
                                } else {
                                    d2 = d11;
                                    d = d12;
                                }
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d8, d7, d2, d, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                                    ((Graphics2D)graphics).draw(new Line2D.Double(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py));
                                }
                                if (!bl2) break block33;
                                d8 = d11;
                                d7 = d12;
                                d2 = bl ? d6 : d4;
                                d = bl ? d5 : d3;
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d8, d7, d2, d, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                                    ((Graphics2D)graphics).draw(new Line2D.Double(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py));
                                }
                            }
                            if (bl2) {
                                boolean bl9 = false;
                                int n11 = Integer.MAX_VALUE;
                                int n12 = Integer.MAX_VALUE;
                                int n13 = Integer.MIN_VALUE;
                                int n14 = Integer.MIN_VALUE;
                                double d13 = d6;
                                double d14 = d5;
                                int n15 = this.xaxis.toPixel(d13, this.drawFront);
                                int n16 = (bl ? n4 : n3) / 2;
                                d8 = this.xaxis.toData(n15 - n16, this.drawFront);
                                d7 = d14;
                                d2 = this.xaxis.toData(n15 + n16, this.drawFront);
                                d = d14;
                                boolean bl10 = (d5 > this.ylim.max && d3 > this.ylim.max || d5 < this.ylim.min && d3 < this.ylim.min) ^ true;
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d8, d7, d2, d, this.xlim, this.ylim, plotPointArray, this.inverted, bl10);
                                n5 = 0;
                                while (n5 < plotPointArray.length && !bl9) {
                                    if (plotPointArray[n5].valid) {
                                        n11 = Math.min(n11, plotPointArray[n5].px);
                                        n13 = Math.max(n13, plotPointArray[n5].px);
                                        n12 = Math.min(n12, plotPointArray[n5].py);
                                        n14 = Math.max(n14, plotPointArray[n5].py);
                                    } else {
                                        bl9 = true;
                                    }
                                    ++n5;
                                }
                                if (!bl9) {
                                    d13 = d4;
                                    d14 = d3;
                                    n15 = this.xaxis.toPixel(d13, this.drawFront);
                                    d8 = this.xaxis.toData(n15 - n16, this.drawFront);
                                    d7 = d14;
                                    d2 = this.xaxis.toData(n15 + n16, this.drawFront);
                                    d = d14;
                                    plotPointArray[0].valid = false;
                                    plotPointArray[1].valid = false;
                                    this.financialClip(d8, d7, d2, d, this.xlim, this.ylim, plotPointArray, this.inverted, bl10);
                                    n5 = 0;
                                    while (n5 < plotPointArray.length && !bl9) {
                                        if (plotPointArray[n5].valid) {
                                            n11 = Math.min(n11, plotPointArray[n5].px);
                                            n13 = Math.max(n13, plotPointArray[n5].px);
                                            n12 = Math.min(n12, plotPointArray[n5].py);
                                            n14 = Math.max(n14, plotPointArray[n5].py);
                                        } else {
                                            bl9 = true;
                                        }
                                        ++n5;
                                    }
                                    if (!bl9) {
                                        if (bl) {
                                            this.drawCandleRect(graphics2, jCChartStyle3.getFillStyle(), jCChartStyle.getLineStyle(), n11, n12, n13, n14, this.isComplex, bl);
                                        } else {
                                            this.drawCandleRect(graphics2, jCChartStyle2.getFillStyle(), jCChartStyle.getLineStyle(), n11, n12, n13, n14, this.isComplex, bl);
                                        }
                                    }
                                }
                            }
                        }
                        ++n9;
                    }
                    jCLineStyle.resetGraphics(graphics);
                }
                ++n2;
            }
            graphics2.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private final void drawCandleRect(Graphics graphics, JCFillStyle jCFillStyle, JCLineStyle jCLineStyle, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = Math.max(n3 - n, 1);
        int n6 = Math.max(n4 - n2, 1);
        if (bl) {
            jCFillStyle.fillRect(graphics, n, n2, n5 == 1 ? n5 : n5 + 1, n6 == 1 ? n6 : n6 + 1);
            if (jCLineStyle.updateGraphics(graphics)) {
                ((Graphics2D)graphics).draw(new Rectangle2D.Double(n, n2, n5, n6));
            }
        } else if (jCLineStyle.updateGraphics(graphics)) {
            if (!bl2) {
                graphics.fillRect(n, n2, n5 == 1 ? n5 : n5 + 1, n6 == 1 ? n6 : n6 + 1);
            }
            ((Graphics2D)graphics).draw(new Rectangle2D.Double(n, n2, n5, n6));
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        return jCDataIndex.dataView.getXAxis().vertical ? n - this.r.x : n2 - this.r.y;
    }

    public int getNumSeriesPerData() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        int n4 = -1;
        int n5 = -1;
        JCDataIndex jCDataIndex = null;
        double d = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        int n6 = this.seriesList.size() / 4;
        try {
            int n7 = 0;
            while (n7 < n6) {
                boolean bl3 = true;
                int n8 = Integer.MAX_VALUE;
                int n9 = Integer.MAX_VALUE;
                boolean bl4 = true;
                int n10 = 4 * n7;
                int n11 = 0;
                while (n11 < 4) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n10);
                    if (!chartDataViewSeries.isVisible()) {
                        bl4 = false;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        bl3 = false;
                        break;
                    }
                    n8 = Math.min(n8, chartDataViewSeries.getFirstPoint());
                    n9 = Math.min(n9, chartDataViewSeries.getLastPoint());
                    ++n11;
                    ++n10;
                }
                if (bl4 && bl3) {
                    Object object;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    if (this.isComplex) {
                        object = this.cf.getRisingCandleStyle(n7);
                        if (object != null) {
                            d2 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                        if ((object = this.cf.getFallingCandleStyle(n7)) != null) {
                            d3 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                    } else {
                        object = this.cf.getHiloStyle(n7);
                        if (object != null) {
                            d3 = d2 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                    }
                    object = ((ChartDataViewSeries)this.seriesList.get(4 * n7)).getX();
                    double[] dArray = ((ChartDataViewSeries)this.seriesList.get(4 * n7)).getY();
                    double[] dArray2 = ((ChartDataViewSeries)this.seriesList.get(4 * n7 + 1)).getX();
                    double[] dArray3 = ((ChartDataViewSeries)this.seriesList.get(4 * n7 + 1)).getY();
                    double[] dArray4 = ((ChartDataViewSeries)this.seriesList.get(4 * n7 + 2)).getX();
                    double[] dArray5 = ((ChartDataViewSeries)this.seriesList.get(4 * n7 + 2)).getY();
                    double[] dArray6 = ((ChartDataViewSeries)this.seriesList.get(4 * n7 + 3)).getX();
                    double[] dArray7 = ((ChartDataViewSeries)this.seriesList.get(4 * n7 + 3)).getY();
                    double d4 = 0.0;
                    double d5 = 0.0;
                    int n12 = n8;
                    while (n12 <= n9) {
                        int n13;
                        int n14;
                        Object object2 = object[n12];
                        double d6 = dArray[n12];
                        Object object3 = dArray2[n12];
                        double d7 = dArray3[n12];
                        if (d6 < d7) {
                            Object object4 = object2;
                            double d8 = d6;
                            object2 = object3;
                            d6 = d7;
                            object3 = object4;
                            d7 = d8;
                        }
                        double d9 = dArray4[n12];
                        double d10 = dArray5[n12];
                        double d11 = dArray6[n12];
                        double d12 = dArray7[n12];
                        boolean bl5 = (d12 == this.holeValue || d10 == this.holeValue || d11 == this.holeValue || d9 == this.holeValue || bl && d11 <= 0.0 || bl2 && d12 <= 0.0 || bl && d9 <= 0.0 || bl2 && d10 <= 0.0) ^ true;
                        double d13 = d10 < d12 ? d2 : d3;
                        boolean bl6 = false;
                        if (!(d6 == this.holeValue || d7 == this.holeValue || object2 == this.holeValue || object3 == this.holeValue || bl && object2 <= 0.0 || bl2 && d6 <= 0.0 || bl && object3 <= 0.0 || bl2 && d7 <= 0.0)) {
                            if (bl5) {
                                n14 = 0;
                                n13 = 4;
                            } else {
                                n14 = 0;
                                n13 = 2;
                            }
                        } else if (bl5) {
                            n14 = 2;
                            n13 = 4;
                        } else {
                            n14 = 0;
                            n13 = 0;
                        }
                        int n15 = n14;
                        block15: while (n15 < n13) {
                            double d14;
                            switch (n15) {
                                case 0: {
                                    d4 = (double)object2;
                                    d5 = d6;
                                    break;
                                }
                                case 1: {
                                    d4 = object3;
                                    d5 = d7;
                                    break;
                                }
                                case 2: {
                                    if (d13 == 0.0) {
                                        ++n15;
                                        continue block15;
                                    }
                                    if (!bl6) {
                                        d4 = d9 - d13;
                                        d5 = d10;
                                        bl6 = true;
                                        break;
                                    }
                                    d4 = d9 + d13;
                                    bl6 = false;
                                    break;
                                }
                                case 3: {
                                    if (d13 == 0.0) {
                                        ++n15;
                                        continue block15;
                                    }
                                    if (!bl6) {
                                        d4 = d11 - d13;
                                        d5 = d12;
                                        bl6 = true;
                                        break;
                                    }
                                    d4 = d11 + d13;
                                    bl6 = false;
                                }
                            }
                            if (d4 > this.xlim.max || this.xlim.min > d4 || d5 > this.ylim.max || this.ylim.min > d5) {
                                if (bl6) continue;
                                ++n15;
                                continue;
                            }
                            switch (n) {
                                case 1: {
                                    int n16 = this.xaxis.toPixel(d4, this.drawFront);
                                    d14 = this.inverted ? Math.abs(n16 - n3) : Math.abs(n16 - n2);
                                    break;
                                }
                                case 2: {
                                    int n17 = this.yaxis.toPixel(d5, this.drawFront);
                                    d14 = this.inverted ? Math.abs(n17 - n2) : Math.abs(n17 - n3);
                                    break;
                                }
                                default: {
                                    int n16 = this.xaxis.toPixel(d4, this.drawFront);
                                    int n17 = this.yaxis.toPixel(d5, this.drawFront);
                                    double d15 = d14 = this.inverted ? Math.sqrt((n17 - n2) * (n17 - n2) + (n16 - n3) * (n16 - n3)) : Math.sqrt((n16 - n2) * (n16 - n2) + (n17 - n3) * (n17 - n3));
                                }
                            }
                            if (d > d14) {
                                n4 = n7 * 4 + n15;
                                n5 = n12;
                                d = d14;
                            }
                            if (bl6) continue;
                            ++n15;
                        }
                        ++n12;
                    }
                }
                ++n7;
            }
            if (n4 >= 0 && n5 >= 0) {
                jCDataIndex = new JCDataIndex(n5, (ChartDataViewSeries)this.seriesList.get(n4), n4);
                jCDataIndex.distance = (int)d;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n) {
        super.recalc();
        if (n == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.cf = (JCCandleChartFormat)this.dataObject.getChartFormat();
        this.holeValue = this.dataObject.getHoleValue();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.inverted = this.xaxis.vertical;
        if (n == -1 || n == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (bl) {
            this.end.x = n;
        } else {
            this.end.y = n2;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d;
        double d2;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        int n = jCDataIndex.series.getDrawingOrder() / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        this.useRubberBand = false;
        int n2 = n * 4;
        int n3 = jCDataIndex.seriesIndex - n2;
        int n4 = 0;
        int n5 = 0;
        if (this.isComplex) {
            JCChartStyle jCChartStyle = this.cf.getRisingCandleStyle(n);
            if (jCChartStyle != null) {
                n4 = jCChartStyle.getSymbolSize();
            }
            if ((jCChartStyle = this.cf.getFallingCandleStyle(n)) != null) {
                n5 = jCChartStyle.getSymbolSize();
            }
        } else {
            JCChartStyle jCChartStyle = this.cf.getHiloStyle(n);
            if (jCChartStyle != null) {
                n5 = n4 = jCChartStyle.getSymbolSize();
            }
        }
        boolean bl2 = (d2 = ((ChartDataViewSeries)this.seriesList.get(n2 + 2)).getY(jCDataIndex.point)) < (d = ((ChartDataViewSeries)this.seriesList.get(n2 + 3)).getY(jCDataIndex.point));
        int n6 = bl2 ? n4 : n5;
        double d3 = ((ChartDataViewSeries)this.seriesList.get(n2 + n3)).getX(jCDataIndex.point);
        double d4 = ((ChartDataViewSeries)this.seriesList.get(n2 + n3)).getY(jCDataIndex.point);
        if (n3 > 1) {
            this.useRubberBand = true;
            if (bl) {
                this.start = new Point(this.yaxis.toPixel(d4) + this.r.x, this.xaxis.toPixel(d3) + this.r.y - n6 / 2);
                this.end = new Point(this.start.x, this.start.y + n6);
            } else {
                this.start = new Point(this.xaxis.toPixel(d3) + this.r.x - n6 / 2, this.yaxis.toPixel(d4) + this.r.y);
                this.end = new Point(this.start.x + n6, this.start.y);
            }
        } else {
            this.start = bl ? new Point(this.yaxis.toPixel(d4) + this.r.x, this.xaxis.toPixel(d3) + this.r.y) : new Point(this.xaxis.toPixel(d3) + this.r.x, this.yaxis.toPixel(d4) + this.r.y);
            this.end = new Point(this.start.x, this.start.y);
        }
    }

    public Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            if (this.inverted) {
                n3 = this.yaxis.toPixel(d, this.drawFront);
                n4 = this.xaxis.toPixel(d2, this.drawFront);
            } else {
                n3 = this.xaxis.toPixel(d2, this.drawFront);
                n4 = this.yaxis.toPixel(d, this.drawFront);
            }
            return new Point(n3, n4);
        }
        return null;
    }
}

