/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.FlattenedObject;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.o;

public class NativeFunction
extends ScriptableObject
implements Function {
    public String debug_srcName;
    public int debug_level = -1;
    public NativeFunction[] nestedFunctions;
    protected String source;
    protected short version;
    protected short argCount;
    protected String[] names;
    private static final boolean a = false;
    private static final int b = 2;
    private static final int c = 4;

    public String toString() {
        String string = this.names == null ? "function () { [native code] }" : String.valueOf(new StringBuffer("function ").append(this.names[0]).append("() { [native code] }"));
        return string;
    }

    private NativeCall b(Context context) {
        NativeCall nativeCall = context.fb;
        while (nativeCall != null) {
            if (nativeCall.getFunctionObject() == this) {
                return nativeCall;
            }
            nativeCall = nativeCall.d;
        }
        return null;
    }

    public String jsGet_name() {
        if (this.names != null && this.names[0].length() > 0) {
            return this.names[0];
        }
        Context context = Context.getCurrentContext();
        if (context != null && context.getLanguageVersion() == 120) {
            return "";
        }
        return "anonymous";
    }

    public int jsGet_arity() {
        return this.argCount;
    }

    public int jsGet_length() {
        Context context = Context.b();
        if (context.getLanguageVersion() != 120) {
            return this.argCount;
        }
        NativeCall nativeCall = this.b(context);
        if (nativeCall == null) {
            return this.argCount;
        }
        return nativeCall.getOriginalArguments().length;
    }

    public static Object jsFunction_call(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (objectArray.length == 0) {
            Scriptable scriptable2 = ScriptRuntime.toObject(function, object);
            Scriptable scriptable3 = scriptable2.getParentScope();
            return ScriptRuntime.call(context, object, scriptable3, ScriptRuntime.emptyArgs, scriptable3);
        }
        Scriptable scriptable4 = objectArray[0] == null ? ScriptableObject.getTopLevelScope(scriptable) : ScriptRuntime.toObject(function, objectArray[0]);
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return ScriptRuntime.call(context, object, scriptable4, objectArray2, scriptable4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object jsFunction_apply(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        Object[] objectArray2;
        Scriptable scriptable2;
        if (objectArray.length != 2) {
            return NativeFunction.jsFunction_call(context, scriptable, objectArray, function);
        }
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        Scriptable scriptable3 = scriptable2 = objectArray[0] == null ? ScriptableObject.getTopLevelScope(scriptable) : ScriptRuntime.toObject(function, objectArray[0]);
        if (objectArray.length > 1) {
            if (!(objectArray[1] instanceof NativeArray) && !(objectArray[1] instanceof o)) throw NativeGlobal.constructError(context, "TypeError", ScriptRuntime.getMessage("msg.arg.isnt.array", null), scriptable);
            objectArray2 = context.getElements((Scriptable)objectArray[1]);
            return ScriptRuntime.call(context, object, scriptable2, objectArray2, scriptable2);
        } else {
            objectArray2 = new Object[]{};
        }
        return ScriptRuntime.call(context, object, scriptable2, objectArray2, scriptable2);
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        int n2;
        int n3 = objectArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            if (n2 > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ScriptRuntime.toString(objectArray[n2]));
        }
        String string = n3 == 0 ? "" : ScriptRuntime.toString(objectArray[n2]);
        String string2 = String.valueOf(new StringBuffer("function (").append(stringBuffer.toString()).append(") {").append(string).append("}"));
        int[] nArray = new int[]{0};
        String string3 = Context.a(nArray);
        if (string3 == null) {
            string3 = "<eval'ed string>";
            nArray[0] = 1;
        }
        Object object = context.a(4);
        Scriptable scriptable = context.gb;
        if (scriptable == null) {
            scriptable = function;
        }
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        int n4 = context.getOptimizationLevel();
        context.setOptimizationLevel(-1);
        NativeFunction nativeFunction = (NativeFunction)context.compileFunction(scriptable2, string2, string3, nArray[0], object);
        context.setOptimizationLevel(n4);
        if (nativeFunction.names == null) {
            nativeFunction.names = new String[1];
        }
        nativeFunction.names[0] = "";
        nativeFunction.setPrototype(ScriptableObject.getFunctionPrototype(scriptable2));
        nativeFunction.setParentScope(scriptable2);
        return nativeFunction;
    }

    public static Object jsFunction_toString(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (!(object instanceof NativeFunction)) {
            Object[] objectArray2 = new Object[]{"toString"};
            String string = Context.a("msg.incompat.call", objectArray2);
            throw NativeGlobal.constructError(context, "TypeError", string, function);
        }
        int n2 = 0;
        if (objectArray.length > 0) {
            n2 = (int)ScriptRuntime.toNumber(objectArray[0]);
        }
        return ((NativeFunction)object).decompile(n2, true, false);
    }

    public String decompile(int n2, boolean bl, boolean bl2) {
        int n3;
        if (this.source == null) {
            return String.valueOf(new StringBuffer("function ").append(this.jsGet_name()).append("() {\n\t[native code]\n}\n"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        if (this.source.length() > 0) {
            if (bl) {
                if (!bl2) {
                    stringBuffer.append('\n');
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(' ');
                }
            }
            if (this.source.charAt(0) == 'm' && this.source.length() > 1 && (this.source.charAt(1) == ',' || this.source.charAt(1) == ']')) {
                if (!bl2) {
                    stringBuffer.append("function ");
                    if (this.a(n4, 93) && this.version != 120 && this.names != null && this.names[0].length() == 0) {
                        stringBuffer.append("anonymous");
                    }
                    ++n4;
                } else {
                    while (n4 < this.source.length() && (this.source.charAt(n4) != '\u0001' || n4 > 0 && this.source.charAt(n4 - 1) == ',')) {
                        ++n4;
                    }
                    ++n4;
                }
            }
        }
        while (n4 < this.source.length()) {
            block0 : switch (this.source.charAt(n4)) {
                case ',': 
                case '8': {
                    n3 = ++n4 + this.source.charAt(n4);
                    stringBuffer.append(this.source.substring(n4 + 1, n3 + 1));
                    n4 = n3;
                    break;
                }
                case '-': {
                    long l2 = 0L;
                    switch (this.source.charAt(++n4)) {
                        case 'S': {
                            stringBuffer.append((int)this.source.charAt(++n4));
                            break block0;
                        }
                        case 'J': {
                            int n5 = ++n4;
                            l2 |= (long)this.source.charAt(n5) << 48;
                            int n6 = ++n4;
                            l2 |= (long)this.source.charAt(n6) << 32;
                            int n7 = ++n4;
                            l2 |= (long)this.source.charAt(n7) << 16;
                            stringBuffer.append(l2 |= (long)this.source.charAt(++n4));
                            break block0;
                        }
                        case 'D': {
                            int n8 = ++n4;
                            l2 |= (long)this.source.charAt(n8) << 48;
                            int n9 = ++n4;
                            l2 |= (long)this.source.charAt(n9) << 32;
                            int n10 = ++n4;
                            l2 |= (long)this.source.charAt(n10) << 16;
                            double d2 = Double.longBitsToDouble(l2 |= (long)this.source.charAt(++n4));
                            stringBuffer.append(ScriptRuntime.numberToString(d2, 10));
                            break block0;
                        }
                    }
                    break;
                }
                case '.': {
                    n3 = ++n4 + this.source.charAt(n4);
                    stringBuffer.append('\"');
                    stringBuffer.append(ScriptRuntime.escapeString(this.source.substring(n4 + 1, n3 + 1)));
                    stringBuffer.append('\"');
                    n4 = n3;
                    break;
                }
                case 'l': {
                    switch (this.source.charAt(++n4)) {
                        case '4': {
                            stringBuffer.append("true");
                            break block0;
                        }
                        case '3': {
                            stringBuffer.append("false");
                            break block0;
                        }
                        case '1': {
                            stringBuffer.append("null");
                            break block0;
                        }
                        case '2': {
                            stringBuffer.append("this");
                            break block0;
                        }
                        case ' ': {
                            stringBuffer.append("typeof");
                            break block0;
                        }
                        case '\u0083': {
                            stringBuffer.append("void");
                            break block0;
                        }
                        case 'J': {
                            stringBuffer.append("undefined");
                            break block0;
                        }
                    }
                    break;
                }
                case 'm': {
                    int n11 = this.source.charAt(++n4);
                    if (this.nestedFunctions == null || n11 > this.nestedFunctions.length) {
                        String string;
                        if (this.names != null && this.names.length > 0 && this.names[0].length() > 0) {
                            Object[] objectArray = new Object[]{new Integer(this.source.charAt(n4)), this.names[0]};
                            string = Context.a("msg.no.function.ref.found.in", objectArray);
                        } else {
                            Object[] objectArray = new Object[]{new Integer(this.source.charAt(n4))};
                            string = Context.a("msg.no.function.ref.found", objectArray);
                        }
                        throw Context.reportRuntimeError(string);
                    }
                    stringBuffer.append(this.nestedFunctions[n11].decompile(n2, false, false));
                    break;
                }
                case '_': {
                    stringBuffer.append(", ");
                    break;
                }
                case '[': {
                    if (this.a(n4, 1)) {
                        n2 += 4;
                    }
                    stringBuffer.append("{");
                    break;
                }
                case '\\': {
                    if (bl2 && bl && n4 + 1 == this.source.length()) break;
                    if (this.a(n4, 1)) {
                        n2 -= 4;
                    }
                    if (this.a(n4, 117) || this.a(n4, 113)) {
                        n2 -= 4;
                        stringBuffer.append("} ");
                        break;
                    }
                    stringBuffer.append('}');
                    break;
                }
                case ']': {
                    stringBuffer.append('(');
                    break;
                }
                case '^': {
                    if (this.a(n4, 91)) {
                        stringBuffer.append(") ");
                        break;
                    }
                    stringBuffer.append(')');
                    break;
                }
                case 'Y': {
                    stringBuffer.append('[');
                    break;
                }
                case 'Z': {
                    stringBuffer.append(']');
                    break;
                }
                case '\u0001': {
                    char c2;
                    stringBuffer.append('\n');
                    if (n4 + 1 >= this.source.length()) break;
                    int n11 = 0;
                    if (this.a(n4, 115) || this.a(n4, 116)) {
                        n11 = 2;
                    } else if (this.a(n4, 92)) {
                        n11 = 4;
                    } else if (this.a(n4, 44) && this.source.charAt(n4 + (c2 = this.source.charAt(n4 + 2)) + 3) == 'b') {
                        n11 = 4;
                    }
                    while (n11 < n2) {
                        stringBuffer.append(' ');
                        ++n11;
                    }
                    break;
                }
                case 'k': {
                    stringBuffer.append('.');
                    break;
                }
                case '\u001e': {
                    stringBuffer.append("new ");
                    break;
                }
                case '\u001f': {
                    stringBuffer.append("delete ");
                    break;
                }
                case 'p': {
                    stringBuffer.append("if ");
                    break;
                }
                case 'q': {
                    stringBuffer.append("else ");
                    break;
                }
                case 'w': {
                    stringBuffer.append("for ");
                    break;
                }
                case '?': {
                    stringBuffer.append(" in ");
                    break;
                }
                case '{': {
                    stringBuffer.append("with ");
                    break;
                }
                case 'u': {
                    stringBuffer.append("while ");
                    break;
                }
                case 'v': {
                    stringBuffer.append("do ");
                    break;
                }
                case 'K': {
                    stringBuffer.append("try ");
                    break;
                }
                case '|': {
                    stringBuffer.append("catch ");
                    break;
                }
                case '}': {
                    stringBuffer.append("finally ");
                    break;
                }
                case '>': {
                    stringBuffer.append("throw ");
                    break;
                }
                case 'r': {
                    stringBuffer.append("switch ");
                    break;
                }
                case 'x': {
                    if (this.a(n4, 44)) {
                        stringBuffer.append("break ");
                        break;
                    }
                    stringBuffer.append("break");
                    break;
                }
                case 'y': {
                    if (this.a(n4, 44)) {
                        stringBuffer.append("continue ");
                        break;
                    }
                    stringBuffer.append("continue");
                    break;
                }
                case 's': {
                    stringBuffer.append("case ");
                    break;
                }
                case 't': {
                    stringBuffer.append("default");
                    break;
                }
                case '\u0005': {
                    if (this.a(n4, 88)) {
                        stringBuffer.append("return");
                        break;
                    }
                    stringBuffer.append("return ");
                    break;
                }
                case 'z': {
                    stringBuffer.append("var ");
                    break;
                }
                case 'X': {
                    if (this.a(n4, 1)) {
                        stringBuffer.append(";");
                        break;
                    }
                    stringBuffer.append("; ");
                    break;
                }
                case '`': {
                    switch (this.source.charAt(++n4)) {
                        case '\u007f': {
                            stringBuffer.append(" = ");
                            break block0;
                        }
                        case '\u0017': {
                            stringBuffer.append(" += ");
                            break block0;
                        }
                        case '\u0018': {
                            stringBuffer.append(" -= ");
                            break block0;
                        }
                        case '\u0019': {
                            stringBuffer.append(" *= ");
                            break block0;
                        }
                        case '\u001a': {
                            stringBuffer.append(" /= ");
                            break block0;
                        }
                        case '\u001b': {
                            stringBuffer.append(" %= ");
                            break block0;
                        }
                        case '\u000b': {
                            stringBuffer.append(" |= ");
                            break block0;
                        }
                        case '\f': {
                            stringBuffer.append(" ^= ");
                            break block0;
                        }
                        case '\r': {
                            stringBuffer.append(" &= ");
                            break block0;
                        }
                        case '\u0014': {
                            stringBuffer.append(" <<= ");
                            break block0;
                        }
                        case '\u0015': {
                            stringBuffer.append(" >>= ");
                            break block0;
                        }
                        case '\u0016': {
                            stringBuffer.append(" >>>= ");
                            break block0;
                        }
                    }
                    break;
                }
                case 'a': {
                    stringBuffer.append(" ? ");
                    break;
                }
                case '\u0086': {
                    stringBuffer.append(':');
                    break;
                }
                case 'b': {
                    if (this.a(n4, 1)) {
                        stringBuffer.append(":");
                        break;
                    }
                    stringBuffer.append(" : ");
                    break;
                }
                case 'c': {
                    stringBuffer.append(" || ");
                    break;
                }
                case 'd': {
                    stringBuffer.append(" && ");
                    break;
                }
                case '\u000b': {
                    stringBuffer.append(" | ");
                    break;
                }
                case '\f': {
                    stringBuffer.append(" ^ ");
                    break;
                }
                case '\r': {
                    stringBuffer.append(" & ");
                    break;
                }
                case 'e': {
                    switch (this.source.charAt(++n4)) {
                        case '5': {
                            stringBuffer.append(this.version == 120 ? " == " : " === ");
                            break block0;
                        }
                        case '6': {
                            stringBuffer.append(this.version == 120 ? " != " : " !== ");
                            break block0;
                        }
                        case '\u000e': {
                            stringBuffer.append(" == ");
                            break block0;
                        }
                        case '\u000f': {
                            stringBuffer.append(" != ");
                            break block0;
                        }
                    }
                    break;
                }
                case 'f': {
                    switch (this.source.charAt(++n4)) {
                        case '\u0011': {
                            stringBuffer.append(" <= ");
                            break block0;
                        }
                        case '\u0010': {
                            stringBuffer.append(" < ");
                            break block0;
                        }
                        case '\u0013': {
                            stringBuffer.append(" >= ");
                            break block0;
                        }
                        case '\u0012': {
                            stringBuffer.append(" > ");
                            break block0;
                        }
                        case '@': {
                            stringBuffer.append(" instanceof ");
                            break block0;
                        }
                    }
                    break;
                }
                case 'g': {
                    switch (this.source.charAt(++n4)) {
                        case '\u0014': {
                            stringBuffer.append(" << ");
                            break block0;
                        }
                        case '\u0015': {
                            stringBuffer.append(" >> ");
                            break block0;
                        }
                        case '\u0016': {
                            stringBuffer.append(" >>> ");
                            break block0;
                        }
                    }
                    break;
                }
                case 'h': {
                    switch (this.source.charAt(++n4)) {
                        case ' ': {
                            stringBuffer.append("typeof ");
                            break block0;
                        }
                        case '\u0083': {
                            stringBuffer.append("void ");
                            break block0;
                        }
                        case '\u0080': {
                            stringBuffer.append('!');
                            break block0;
                        }
                        case '\u001c': {
                            stringBuffer.append('~');
                            break block0;
                        }
                        case '\u0017': {
                            stringBuffer.append('+');
                            break block0;
                        }
                        case '\u0018': {
                            stringBuffer.append('-');
                            break block0;
                        }
                    }
                    break;
                }
                case 'i': {
                    stringBuffer.append("++");
                    break;
                }
                case 'j': {
                    stringBuffer.append("--");
                    break;
                }
                case '\u0017': {
                    stringBuffer.append(" + ");
                    break;
                }
                case '\u0018': {
                    stringBuffer.append(" - ");
                    break;
                }
                case '\u0019': {
                    stringBuffer.append(" * ");
                    break;
                }
                case '\u001a': {
                    stringBuffer.append(" / ");
                    break;
                }
                case '\u001b': {
                    stringBuffer.append(" % ");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown token ".concat(String.valueOf(this.source.charAt(n4))));
                }
            }
            ++n4;
        }
        if (bl && !bl2) {
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private boolean a(int n2, int n3) {
        if (n2 + 1 < this.source.length()) {
            return this.source.charAt(n2 + 1) == n3;
        }
        return false;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        NativeObject nativeObject = new NativeObject();
        nativeObject.setPrototype(this.f());
        nativeObject.setParentScope(this.getParentScope());
        Object object = this.call(context, scriptable, nativeObject, objectArray);
        if (object != null && object != Undefined.instance && object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return nativeObject;
    }

    protected Scriptable f() {
        Object object = this.get("prototype", (Scriptable)this);
        if (object == null || !(object instanceof Scriptable) || object == Undefined.instance) {
            object = ScriptableObject.getClassPrototype(this, "Object");
        }
        return (Scriptable)object;
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return Undefined.instance;
    }

    public boolean hasInstance(Scriptable scriptable) {
        FlattenedObject flattenedObject = new FlattenedObject(this);
        Object object = flattenedObject.getProperty("prototype");
        if (object instanceof FlattenedObject && (object = ((FlattenedObject)object).getObject()) != Undefined.instance) {
            return ScriptRuntime.a(scriptable, (Scriptable)object);
        }
        Object[] objectArray = new Object[]{this.names[0]};
        String string = ScriptRuntime.getMessage("msg.instanceof.bad.prototype", objectArray);
        throw NativeGlobal.constructError(Context.b(), "TypeError", string, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        Object object = super.get(string, scriptable);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        if (string.equals("prototype")) {
            NativeObject nativeObject = new NativeObject();
            nativeObject.setPrototype(ScriptableObject.getObjectPrototype(this));
            nativeObject.defineProperty("constructor", this, 7);
            this.put(string, (Scriptable)this, (Object)nativeObject);
            return nativeObject;
        }
        if (string.equals("arguments")) {
            NativeCall nativeCall = this.b(Context.b());
            return nativeCall == null ? null : nativeCall.get("arguments", (Scriptable)nativeCall);
        }
        return Scriptable.NOT_FOUND;
    }

    public boolean has(String string, Scriptable scriptable) {
        return string.equals("prototype") || string.equals("arguments") || super.has(string, scriptable);
    }

    public String getClassName() {
        return "Function";
    }

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        functionObject.setPrototype(scriptable2);
        String[] stringArray = new String[]{""};
        ((NativeFunction)scriptable2).names = stringArray;
    }
}

