/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeString
extends ScriptableObject
implements Wrapper {
    private String a;
    private static final String b = "";

    private static RegExpProxy a(Context context) {
        RegExpProxy regExpProxy = context.c();
        if (regExpProxy == null) {
            throw Context.reportRuntimeError(Context.a("msg.no.regexp", null));
        }
        return regExpProxy;
    }

    public static Object jsFunction_replace(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        return NativeString.a(context).replace(context, scriptable, objectArray, function);
    }

    public static Object jsFunction_search(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        return NativeString.a(context).search(context, scriptable, objectArray, function);
    }

    public static Object jsFunction_match(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws JavaScriptException {
        return NativeString.a(context).match(context, scriptable, objectArray, function);
    }

    public Object unwrap() {
        return this.a;
    }

    public String jsFunction_anchor(String string) {
        return this.a("A NAME", "A", string);
    }

    public String jsFunction_link(String string) {
        return this.a("A HREF", "A", string);
    }

    public String jsFunction_fontcolor(String string) {
        return this.a("FONT COLOR", "FONT", string);
    }

    public String jsFunction_fontsize(String string) {
        return this.a("FONT SIZE", "FONT", string);
    }

    public String jsFunction_sub() {
        return this.a("SUB", null, null);
    }

    public String jsFunction_sup() {
        return this.a("SUP", null, null);
    }

    public String jsFunction_blink() {
        return this.a("BLINK", null, null);
    }

    public String jsFunction_big() {
        return this.a("BIG", null, null);
    }

    public String jsFunction_small() {
        return this.a("SMALL", null, null);
    }

    public String jsFunction_strike() {
        return this.a("STRIKE", null, null);
    }

    public String jsFunction_fixed() {
        return this.a("TT", null, null);
    }

    public String jsFunction_italics() {
        return this.a("I", null, null);
    }

    public String jsFunction_bold() {
        return this.a("B", null, null);
    }

    private String a(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(string);
        if (string3 != null) {
            stringBuffer.append('=');
            stringBuffer.append(string3);
        }
        stringBuffer.append('>');
        stringBuffer.append(this.a);
        stringBuffer.append("</");
        stringBuffer.append(string2 == null ? string : string2);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public static String jsFunction_slice(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(scriptable);
        if (objectArray.length != 0) {
            double d2;
            double d3 = ScriptRuntime.toInteger(objectArray[0]);
            int n2 = string.length();
            if (d3 < 0.0) {
                if ((d3 += (double)n2) < 0.0) {
                    d3 = 0.0;
                }
            } else if (d3 > (double)n2) {
                d3 = n2;
            }
            if (objectArray.length == 1) {
                d2 = n2;
            } else {
                d2 = ScriptRuntime.toInteger(objectArray[1]);
                if (d2 < 0.0) {
                    if ((d2 += (double)n2) < 0.0) {
                        d2 = 0.0;
                    }
                } else if (d2 > (double)n2) {
                    d2 = n2;
                }
                if (d2 < d3) {
                    d2 = d3;
                }
            }
            return string.substring((int)d3, (int)d2);
        }
        return string;
    }

    public static String jsFunction_concat(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ScriptRuntime.toString(scriptable));
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringBuffer.append(ScriptRuntime.toString(objectArray[i2]));
        }
        return stringBuffer.toString();
    }

    public static String jsFunction_substr(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d2;
        String string = ScriptRuntime.toString(scriptable);
        if (objectArray.length < 1) {
            return string;
        }
        double d3 = ScriptRuntime.toInteger(objectArray[0]);
        int n2 = string.length();
        if (d3 < 0.0) {
            if ((d3 += (double)n2) < 0.0) {
                d3 = 0.0;
            }
        } else if (d3 > (double)n2) {
            d3 = n2;
        }
        if (objectArray.length == 1) {
            d2 = n2;
        } else {
            d2 = ScriptRuntime.toInteger(objectArray[1]);
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            if ((d2 += d3) > (double)n2) {
                d2 = n2;
            }
        }
        return string.substring((int)d3, (int)d2);
    }

    public double jsGet_length() {
        return this.a.length();
    }

    public static String jsFunction_toUpperCase(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(scriptable);
        return string.toUpperCase();
    }

    public static String jsFunction_toLowerCase(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        String string = ScriptRuntime.toString(scriptable);
        return string.toLowerCase();
    }

    public static String jsFunction_substring(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        double d2;
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(scriptable);
        int n2 = string.length();
        double d3 = ScriptRuntime.toInteger(objectArray[0]);
        if (d3 < 0.0) {
            d3 = 0.0;
        } else if (d3 > (double)n2) {
            d3 = n2;
        }
        if (objectArray.length == 1) {
            d2 = n2;
        } else {
            d2 = ScriptRuntime.toInteger(objectArray[1]);
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d2 > (double)n2) {
                d2 = n2;
            }
            if (d2 < d3) {
                if (context.getLanguageVersion() != 120) {
                    double d4 = d3;
                    d3 = d2;
                    d2 = d4;
                } else {
                    d2 = d3;
                }
            }
        }
        return string.substring((int)d3, (int)d2);
    }

    public static Object jsFunction_split(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n2;
        String string = ScriptRuntime.toString(scriptable);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(function);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        if (objectArray.length < 1) {
            scriptable3.put(0, scriptable3, (Object)string);
            return scriptable3;
        }
        boolean bl = objectArray.length > 1 && objectArray[1] != Undefined.instance;
        long l2 = 0L;
        if (bl && (l2 = ScriptRuntime.toUint32(objectArray[1])) > (long)string.length()) {
            l2 = 1 + string.length();
        }
        String string2 = null;
        int[] nArray = new int[]{0};
        Object object = null;
        RegExpProxy regExpProxy = context.c();
        if (regExpProxy != null && regExpProxy.isRegExp(objectArray[0])) {
            object = objectArray[0];
        } else {
            string2 = ScriptRuntime.toString(objectArray[0]);
            nArray[0] = string2.length();
        }
        int[] nArray2 = new int[]{0};
        int n3 = 0;
        boolean[] blArray = new boolean[]{false};
        String[][] stringArray = new String[][]{null};
        while (!((n2 = NativeString.a(function, string, string2, object, nArray2, nArray, blArray, stringArray)) < 0 || bl && (long)n3 >= l2 || n2 > string.length())) {
            String string3 = string.length() == 0 ? string : string.substring(nArray2[0], n2);
            scriptable3.put(n3, scriptable3, (Object)string3);
            ++n3;
            if (object != null && blArray[0]) {
                int n4 = stringArray[0].length;
                for (int i2 = 0; !(i2 >= n4 || bl && (long)n3 >= l2); ++i2) {
                    scriptable3.put(n3, scriptable3, (Object)stringArray[0][i2]);
                    ++n3;
                }
                blArray[0] = false;
            }
            nArray2[0] = n2 + nArray[0];
            if (context.getLanguageVersion() >= 130 || context.getLanguageVersion() == 0 || bl || nArray2[0] != string.length()) continue;
            break;
        }
        return scriptable3;
    }

    private static int a(Function function, String string, String string2, Object object, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n2;
        int n3 = string.length();
        Context context = Context.b();
        int n4 = context.getLanguageVersion();
        if (n4 == 120 && object == null && string2.length() == 1 && string2.charAt(0) == ' ') {
            int n5;
            if (n2 == 0) {
                for (n2 = nArray[0]; n2 < n3 && Character.isWhitespace(string.charAt(n2)); ++n2) {
                }
                nArray[0] = n2;
            }
            if (n2 == n3) {
                return -1;
            }
            while (n2 < n3 && !Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            for (n5 = n2; n5 < n3 && Character.isWhitespace(string.charAt(n5)); ++n5) {
            }
            nArray2[0] = n5 - n2;
            return n2;
        }
        if (n2 > n3) {
            return -1;
        }
        if (object != null) {
            return context.c().find_split(function, string, string2, object, nArray, nArray2, blArray, stringArray);
        }
        if (n4 != 0 && n4 < 130 && n3 == 0) {
            return -1;
        }
        if (string2.length() == 0) {
            if (n4 == 120) {
                if (n2 == n3) {
                    nArray2[0] = 1;
                    return n2;
                }
                return n2 + 1;
            }
            return n2 == n3 ? -1 : n2 + 1;
        }
        if (nArray[0] >= n3) {
            return n3;
        }
        n2 = string.indexOf(string2, nArray[0]);
        return n2 != -1 ? n2 : n3;
    }

    public static int jsFunction_lastIndexOf(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 2) {
            objectArray = ScriptRuntime.padArguments(objectArray, 2);
        }
        String string = ScriptRuntime.toString(scriptable);
        String string2 = ScriptRuntime.toString(objectArray[0]);
        double d2 = ScriptRuntime.toNumber(objectArray[1]);
        if (d2 != d2 || d2 > (double)string.length()) {
            d2 = string.length();
        } else if (d2 < 0.0) {
            d2 = 0.0;
        }
        return string.lastIndexOf(string2, (int)d2);
    }

    public static int jsFunction_indexOf(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 2) {
            objectArray = ScriptRuntime.padArguments(objectArray, 2);
        }
        String string = ScriptRuntime.toString(scriptable);
        String string2 = ScriptRuntime.toString(objectArray[0]);
        double d2 = ScriptRuntime.toInteger(objectArray[1]);
        if (d2 > (double)string.length()) {
            return -1;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return string.indexOf(string2, (int)d2);
    }

    public static double jsFunction_charCodeAt(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(scriptable);
        double d2 = ScriptRuntime.toInteger(objectArray[0]);
        if (d2 < 0.0 || d2 >= (double)string.length()) {
            return ScriptRuntime.NaN;
        }
        return string.charAt((int)d2);
    }

    public static String jsFunction_charAt(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            objectArray = ScriptRuntime.padArguments(objectArray, 1);
        }
        String string = ScriptRuntime.toString(scriptable);
        double d2 = ScriptRuntime.toInteger(objectArray[0]);
        if (d2 < 0.0 || d2 >= (double)string.length()) {
            return b;
        }
        return string.substring((int)d2, (int)d2 + 1);
    }

    public void put(int n2, Scriptable scriptable, Object object) {
        if (n2 >= 0 && n2 < this.a.length()) {
            return;
        }
        super.put(n2, scriptable, object);
    }

    public Object get(int n2, Scriptable scriptable) {
        if (n2 >= 0 && n2 < this.a.length()) {
            return this.a.substring(n2, n2 + 1);
        }
        return super.get(n2, scriptable);
    }

    public String jsFunction_valueOf() {
        return this.a;
    }

    public String jsFunction_toString() {
        return this.a;
    }

    public String toString() {
        return this.a;
    }

    public static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        String string;
        String string2 = string = objectArray.length >= 1 ? ScriptRuntime.toString(objectArray[0]) : b;
        if (bl) {
            return new NativeString(string);
        }
        return string;
    }

    public static String jsStaticFunction_fromCharCode(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length < 1) {
            return b;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            stringBuffer.append(ScriptRuntime.toUint16(objectArray[i2]));
        }
        return stringBuffer.toString();
    }

    public String getClassName() {
        return "String";
    }

    public NativeString(String string) {
        this.a = string;
    }

    public static void finishInit(Scriptable scriptable, FunctionObject functionObject, Scriptable scriptable2) {
        String[] stringArray = new String[]{"indexOf", "lastIndexOf", "substring", "toUpperCase", "toLowerCase", "toString"};
        short[] sArray = new short[]{2, 2, 2, 0, 0, 0};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Object object = scriptable2.get(stringArray[i2], scriptable2);
            ((FunctionObject)object).setLength(sArray[i2]);
        }
    }

    public NativeString() {
        this.a = b;
    }
}

