/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CFTPDI;
import ipworks.CIPPMsg;
import ipworks.Ftp;
import ipworks.IPWorksException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.StringTokenizer;

class CFTP
extends CIPPMsg {
    static final int idle = 0;
    static final int abort = 1;
    static final int logon = 2;
    static final int logoff = 3;
    static final int download = 4;
    static final int upload = 5;
    static final int deleteFile = 6;
    static final int renameFile = 7;
    static final int listDirectory = 8;
    static final int listDirectoryLong = 9;
    static final int makeDirectory = 10;
    static final int removeDirectory = 11;
    static final int append = 12;
    static final int storeUnique = 13;
    static final int modeAscii = 14;
    static final int modeBinary = 15;
    static final int changeDir = 16;
    static final int getRemotePath = 17;
    static final int actionCommand = 18;
    static final int ftpTransDefault = 0;
    static final int ftpTransAscii = 1;
    static final int ftpTransBinary = 2;
    private static final int shortDirList = 2;
    private static final int longDirList = 3;
    private static final int PORT = 21;
    private String command = "";
    private CFTPDI di;
    private int action = 0;
    int transferMode = 0;
    private String startByte = "";
    private boolean passive = false;
    private String user;
    private String password;
    private String remotePath;
    private String remoteFile;
    private String altFile;
    private Ftp sink = null;

    CFTP(Ftp ftp, Object object) {
        super(null, object);
        this.sink = ftp;
        try {
            this.setRemotePort(21);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        this.resetHeaders();
        this.setEOL(CBase.CRLFB);
    }

    void do_Abort() throws IPWorksException {
        this.setAction(1);
    }

    void do_Append() throws IPWorksException {
        this.setAction(12);
    }

    void do_DeleteFile() throws IPWorksException {
        this.setAction(6);
    }

    void do_Download() throws IPWorksException {
        this.setAction(4);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_ListDirectory() throws IPWorksException {
        this.setAction(8);
    }

    void do_ListDirectoryLong() throws IPWorksException {
        this.setAction(9);
    }

    void do_Logoff() throws IPWorksException {
        this.setAction(3);
    }

    void do_Logon() throws IPWorksException {
        this.setAction(2);
    }

    void do_MakeDirectory() throws IPWorksException {
        this.setAction(10);
    }

    void do_RemoveDirectory() throws IPWorksException {
        this.setAction(11);
    }

    void do_RenameFile() throws IPWorksException {
        this.setAction(7);
    }

    void do_StoreUnique() throws IPWorksException {
        this.setAction(13);
    }

    void do_Upload() throws IPWorksException {
        this.setAction(5);
    }

    void setTimeout(int n) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.di != null) {
                this.di.setTimeout(n);
            }
            super.setTimeout(n);
        }
    }

    private void resetHeaders() {
        this.altFile = "";
        this.remoteFile = "";
        this.remotePath = "";
        this.localFile = "";
        this.password = "";
        this.user = "";
    }

    private void sendFTPCommand(String string) throws IPWorksException {
        if (string != null) {
            this.firePITrail(0, string);
        }
        this.sendCommand(string, "\r\n");
        boolean bl = false;
        String string2 = "";
        while (true) {
            this.firePITrail(1, this.lastReply);
            if (string2 != "" && this.lastReply.startsWith(string2)) {
                string2 = "";
            }
            if (string2.length() == 0) {
                if (this.lastReply.length() < 4) {
                    bl = true;
                } else if (this.lastReply.charAt(3) != '-') {
                    switch (this.lastReply.charAt(0)) {
                        case '1': {
                            break;
                        }
                        case '2': 
                        case '3': {
                            return;
                        }
                        case '4': {
                            if (string != null && string.equalsIgnoreCase("ABOR") && this.lastReply.startsWith("426")) break;
                        }
                        default: {
                            bl = true;
                            break;
                        }
                    }
                } else {
                    try {
                        Integer.parseInt(this.lastReply.substring(0, 3));
                        string2 = this.lastReply.substring(0, 3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                throw new IPWorksException(141, this.lastReply);
            }
            this.waitForReply();
        }
    }

    void setUser(String string) {
        this.user = string != null ? string : "";
    }

    String getUser() {
        return this.user;
    }

    void setPassword(String string) {
        this.password = string != null ? string : "";
    }

    String getPassword() {
        return this.password;
    }

    void setRemotePath(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            String string2 = this.remotePath = string != null ? string : "";
            if (this.getConnected()) {
                this.setFTPAction(16);
            }
        }
    }

    String getRemotePath() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.getConnected()) {
                try {
                    this.setFTPAction(17);
                    int n = this.lastReply.indexOf("\"", 5);
                    this.remotePath = this.lastReply.substring(5, n);
                }
                catch (Exception exception) {
                    this.remotePath = "";
                }
            }
            String string = this.remotePath;
            return string;
        }
    }

    void setRemoteFile(String string) {
        this.remoteFile = string != null ? string : "";
    }

    String getRemoteFile() {
        return this.remoteFile;
    }

    void setAltFile(String string) {
        this.altFile = string != null ? string : "";
    }

    String getAltFile() {
        return this.altFile;
    }

    void setPassive(boolean bl) {
        this.passive = bl;
    }

    boolean getPassive() {
        return this.passive;
    }

    void setTransferMode(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.getConnected()) {
                if (n == 1) {
                    this.setFTPAction(14);
                } else if (n == 2) {
                    this.setFTPAction(15);
                }
            }
            this.transferMode = n;
        }
    }

    int getTransferMode() {
        return this.transferMode;
    }

    String getStartByte() {
        return this.startByte;
    }

    void setStartByte(String string) {
        this.startByte = string;
    }

    private void createDiFromPassive(String string) throws IPWorksException {
        int n;
        this.sendFTPCommand("PASV");
        int n2 = this.lastReply.indexOf("(");
        int n3 = 0;
        if (n2 != -1) {
            n3 = this.lastReply.indexOf(")", n2);
        }
        if (n2 == -1 || n3 == -1) {
            throw new IPWorksException(141);
        }
        String string2 = this.lastReply.substring(n2 + 1, n3);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() < 6) {
            throw new IPWorksException(141);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < 3) {
            stringBuffer.append(stringTokenizer.nextToken()).append(".");
            ++n4;
        }
        stringBuffer.append(stringTokenizer.nextToken());
        String string3 = stringBuffer.toString();
        try {
            n = Integer.parseInt(stringTokenizer.nextToken()) * 256 + Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IPWorksException(141);
        }
        this.di = new CFTPDI(this, this.syncObj);
        this.di.timestart = this.timestart;
        this.di.setRemoteHost(string3);
        this.di.setRemotePort(n);
        this.di.setFirewallHost(this.getFirewallHost());
        this.di.setFirewallPort(this.getFirewallPort());
        this.di.blockConnect();
        this.blockSend(string + "\r\n");
        this.firePITrail(0, string);
        this.waitForReply();
        this.firePITrail(1, this.lastReply);
        if (this.lastReply.startsWith("5")) {
            throw new IPWorksException(142, this.lastReply);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createDiFromActive(String var1_1) throws IPWorksException {
        block15: {
            var2_2 = null;
            try {
                block14: {
                    var2_2 = new ServerSocket(0);
                    var2_2.setSoTimeout(100);
                    var3_3 = new StringTokenizer(InetAddress.getByName(this.getLocalHost()).getHostAddress(), ".");
                    var4_5 = new StringBuffer();
                    while (var3_3.hasMoreTokens()) {
                        var4_5.append(var3_3.nextToken() + ",");
                    }
                    var5_6 = var2_2.getLocalPort();
                    var4_5.append(var5_6 / 256).append(",").append(var5_6 % 256);
                    this.sendFTPCommand("PORT " + var4_5.toString());
                    this.blockSend(var1_1 + "\r\n");
                    this.firePITrail(0, var1_1);
                    this.waitForReply();
                    this.firePITrail(1, this.lastReply);
                    if (!this.lastReply.startsWith("5")) ** GOTO lbl32
                    throw new IPWorksException(142, this.lastReply);
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var6_8 = var2_2.accept();
                            this.di = new CFTPDI(this, var6_8, this.syncObj);
                            this.di.timestart = this.timestart;
                            this.di.blockConnect();
                            break block14;
                        }
                        catch (InterruptedIOException var6_7) {
                        }
                        catch (IOException var7_9) {
                            throw new IPWorksException(142);
                        }
lbl32:
                        // 2 sources

                        if (!this.getConnected()) break block14;
                        ** while (this.pendingException == null)
                    }
lbl34:
                    // 1 sources

                }
                var9_10 = null;
                ** if (var2_2 == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_11 = null;
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var10_13) {
                        // empty catch block
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var2_2.close();
                }
                catch (IOException var10_12) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (IOException var3_4) {
                    throw new IPWorksException(142);
                }
            }
        }
    }

    private void createDi(String string) throws IPWorksException {
        if (this.passive) {
            this.createDiFromPassive(string);
        } else {
            this.createDiFromActive(string);
        }
    }

    private void doActionDownload() throws IPWorksException {
        block9: {
            if (this.remoteFile.length() == 0) {
                throw new IPWorksException(146);
            }
            if (this.startByte.length() > 0) {
                this.sendFTPCommand("REST " + this.startByte);
            }
            this.createDi("RETR " + this.remoteFile);
            this.di.localFile = this.localFile;
            try {
                this.di.setInBufferSize(20000);
                this.di.setMaxLineLength(20000);
                this.di.receiveFile();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    if (this.di != null) {
                        this.di.setConnected(false);
                    }
                }
                catch (IPWorksException iPWorksException) {
                    // empty catch block
                }
                this.di = null;
                throw throwable;
            }
            try {
                if (this.di != null) {
                    this.di.setConnected(false);
                }
                break block9;
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            {
            }
        }
        this.di = null;
        this.sendFTPCommand(null);
    }

    /*
     * Loose catch block
     */
    private void doActionUpload(int n) throws IPWorksException {
        block14: {
            if (this.startByte.length() > 0) {
                this.sendFTPCommand("REST " + this.startByte);
            }
            String string = null;
            if (n == 13) {
                string = "STOU";
            } else {
                if (this.remoteFile.length() == 0) {
                    throw new IPWorksException(146);
                }
                if (n == 5) {
                    string = "STOR " + this.remoteFile;
                } else if (n == 12) {
                    string = "APPE " + this.remoteFile;
                }
            }
            this.createDi(string);
            this.di.localFile = this.localFile;
            this.di.bytesSent = 0;
            this.fireStartTransfer();
            this.di.setOutBufferSize(20000);
            this.di.sendLocalFile(2);
            Object var5_3 = null;
            try {
                this.di.setConnected(false);
                break block14;
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            {
                break block14;
                catch (IPWorksException iPWorksException) {
                    throw iPWorksException;
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    this.di.setConnected(false);
                }
                catch (IPWorksException iPWorksException) {
                    // empty catch block
                }
                this.di = null;
                throw throwable;
            }
        }
        this.di = null;
        this.sendFTPCommand(null);
        this.fireEndTransfer();
    }

    private void doActionListDirectory(int n) throws IPWorksException {
        block9: {
            try {
                switch (n) {
                    case 8: {
                        this.createDi("NLST" + (this.remoteFile.length() > 0 ? " " + this.remoteFile : ""));
                        this.di.receiveDirList(2);
                        break;
                    }
                    case 9: {
                        this.createDi("LIST" + (this.remoteFile.length() > 0 ? " " + this.remoteFile : ""));
                        this.di.receiveDirList(3);
                    }
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.di.setConnected(false);
                }
                catch (IPWorksException iPWorksException) {
                    // empty catch block
                }
                this.di = null;
                throw throwable;
            }
            try {
                this.di.setConnected(false);
                break block9;
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            {
            }
        }
        this.di = null;
        this.sendFTPCommand(null);
    }

    private void doActionLogon() throws IPWorksException {
        if (!this.getConnected()) {
            this.firePITrail(2, "Connecting to FTP server.");
            this.blockConnect();
            this.sendFTPCommand(null);
        }
        if (this.user.length() > 0) {
            this.sendFTPCommand("USER " + this.user);
        }
        if (this.password.length() > 0) {
            this.sendFTPCommand("PASS " + this.password);
        }
        this.setTransferMode(this.transferMode);
    }

    private void doActionLogoff() throws IPWorksException {
        if (this.getConnected()) {
            try {
                this.firePITrail(2, "Forcing disconnection from FTP server.");
                this.sendFTPCommand("QUIT");
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.setConnected(false);
                throw throwable;
            }
            this.setConnected(false);
            {
            }
        }
    }

    void setCommand(String string) throws IPWorksException {
        this.command = string != null ? string : "";
        this.setFTPAction(18);
    }

    void interrupt() {
        Object object = this.syncObj;
        synchronized (object) {
            super.interrupt();
            if (this.di != null) {
                this.di.interrupt();
            }
        }
    }

    int getAction() {
        return this.action;
    }

    void setAction(int n) throws IPWorksException {
        this.setFTPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setFTPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0 && (this.action != 2 || n != 14 && n != 15)) {
                throw new IPWorksException(143);
            }
            this.restart();
            if (!this.getConnected() && n != 2 && n != 3) {
                this.setFTPAction(2);
            }
            this.action = n;
        }
        try {
            switch (n) {
                case 1: {
                    this.sendFTPCommand("ABOR");
                    break;
                }
                case 2: {
                    this.doActionLogon();
                    break;
                }
                case 3: {
                    this.doActionLogoff();
                    break;
                }
                case 4: {
                    this.doActionDownload();
                    break;
                }
                case 5: 
                case 12: 
                case 13: {
                    this.doActionUpload(n);
                    break;
                }
                case 6: {
                    this.sendFTPCommand("DELE " + this.remoteFile);
                    break;
                }
                case 7: {
                    this.sendFTPCommand("RNFR " + this.remoteFile);
                    this.sendFTPCommand("RNTO " + this.altFile);
                    break;
                }
                case 8: 
                case 9: {
                    this.doActionListDirectory(n);
                    break;
                }
                case 10: {
                    this.sendFTPCommand("MKD " + this.remoteFile);
                    break;
                }
                case 11: {
                    this.sendFTPCommand("RMD " + this.remoteFile);
                    break;
                }
                case 14: {
                    this.sendFTPCommand("TYPE A");
                    break;
                }
                case 15: {
                    this.sendFTPCommand("TYPE I");
                    break;
                }
                case 16: {
                    if (this.remotePath.equals("..")) {
                        this.sendFTPCommand("CDUP");
                        break;
                    }
                    this.sendFTPCommand("CWD " + this.remotePath);
                    break;
                }
                case 17: {
                    this.sendFTPCommand("PWD");
                    break;
                }
                case 18: {
                    this.sendFTPCommand(this.command);
                }
            }
            Object var5_5 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Object object3 = this.syncObj;
            synchronized (object3) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var5_6 = null;
                Object object4 = this.syncObj;
                synchronized (object4) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
    }

    void firePITrail(int n, String string) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.firePITrail(n, string);
            }
        }
    }

    void fireStartTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireStartTransfer();
            }
        }
    }

    void fireTransfer(int n, byte[] byArray) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireTransfer(n, byArray);
        }
    }

    void fireEndTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireEndTransfer();
            }
        }
    }

    void fireDirList(String string, String string2, boolean bl, int n, String string3) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireDirList(string, string2, bl, n, string3);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.pendingException == null && this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireError(0, "OK");
            }
        }
    }
}

