/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CFTP;
import ipworks.CIPPMsg;
import ipworks.IPWorksException;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class CFTPDI
extends CIPPMsg {
    private static final int nothing = 0;
    private static final int data = 1;
    private static final int shortDirList = 2;
    private static final int longDirList = 3;
    private static final byte[] ftpEol = "\r\n".getBytes();
    private static final int ftpEolSize = ftpEol.length;
    private int transfering = 0;
    private boolean writingToLocalFile;
    private int bytesTransferred;
    private byte[] systemEol;
    private int systemEolSize;
    private boolean ftpEOLdiffersFormSystemEOL;
    private CFTP cFTP;

    CFTPDI(CFTP cFTP, Object object) {
        super(null, object);
        this.cFTP = cFTP;
        this.systemEol = "\r\n".getBytes();
        this.systemEolSize = this.systemEol.length;
        this.ftpEOLdiffersFormSystemEOL = true;
        this.setTimeout(cFTP.timeout);
    }

    CFTPDI(CFTP cFTP, Socket socket, Object object) {
        super(null, socket, object);
        this.cFTP = cFTP;
        this.systemEol = "\r\n".getBytes();
        this.systemEolSize = this.systemEol.length;
        this.ftpEOLdiffersFormSystemEOL = true;
        this.setTimeout(cFTP.timeout);
    }

    private void receive() throws IPWorksException {
        this.setAcceptData(true);
        this.cFTP.fireStartTransfer();
        this.waitForDisconnect();
    }

    void receiveFile() throws IPWorksException {
        boolean bl = this.writingToLocalFile = this.localFile.length() != 0;
        if (this.writingToLocalFile) {
            this.openLocalFile();
        }
        this.bytesTransferred = 0;
        this.transfering = 1;
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ftpEOLdiffersFormSystemEOL) {
                this.setEOL(this.cFTP.transferMode == 1 ? CBase.BYTE0 : ftpEol);
            }
        }
        this.receive();
        this.closeLocalFile();
    }

    void receiveDirList(int n) throws IPWorksException {
        this.transfering = n;
        this.setEOL(ftpEol);
        this.receive();
    }

    void waitForDisconnect() throws IPWorksException {
        super.waitForDisconnect();
        this.cFTP.fireEndTransfer();
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        switch (this.transfering) {
            case 0: {
                break;
            }
            case 1: {
                this.bytesTransferred += byArray.length;
                try {
                    if (this.writingToLocalFile) {
                        this.writeToLocalFile(byArray);
                        if (bl) {
                            this.writeToLocalFile(this.systemEol);
                            this.bytesTransferred += this.systemEolSize;
                        }
                        this.cFTP.fireTransfer(this.bytesTransferred, CBase.BYTE0);
                        break;
                    }
                    this.cFTP.fireTransfer(this.bytesTransferred, byArray);
                    if (!bl) break;
                    this.bytesTransferred += this.systemEolSize;
                    this.cFTP.fireTransfer(this.bytesTransferred, this.systemEol);
                }
                catch (IPWorksException iPWorksException) {
                    this.cFTP.fireError(iPWorksException);
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException2) {}
                }
                break;
            }
            case 2: {
                this.cFTP.fireDirList(new String(byArray), null, false, 0, null);
                break;
            }
            case 3: {
                this.parseAndFireLongDirList(new String(byArray));
            }
        }
    }

    void parseAndFireLongDirList(String string) {
        if (string.startsWith("total")) {
            return;
        }
        String string2 = "";
        String string3 = "";
        int n = 0;
        boolean bl = false;
        try {
            StringBuffer stringBuffer;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            char c = string.charAt(0);
            if (c >= '0' && c <= '9') {
                string3 = stringTokenizer.nextToken() + stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                bl = string4.equalsIgnoreCase("<DIR>");
                if (!bl) {
                    stringBuffer = new StringBuffer();
                    int n2 = string4.length();
                    int n3 = 0;
                    while (n3 < n2) {
                        c = string4.charAt(n3);
                        if (c >= '0' && c <= '9') {
                            stringBuffer.append(c);
                        }
                        ++n3;
                    }
                    n = Integer.parseInt(stringBuffer.toString());
                }
            } else {
                String string5 = stringTokenizer.nextToken();
                bl = string5.charAt(0) == 'd';
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                n = Integer.parseInt(stringTokenizer.nextToken());
                stringBuffer = new StringBuffer();
                int n4 = 0;
                while (n4 < 3) {
                    stringBuffer.append(stringTokenizer.nextToken());
                    if (n4 < 2) {
                        stringBuffer.append(' ');
                    }
                    ++n4;
                }
                string3 = stringBuffer.toString();
            }
            stringBuffer = new StringBuffer(stringTokenizer.nextToken());
            try {
                stringBuffer.append(stringTokenizer.nextToken(""));
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            string2 = stringBuffer.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cFTP.fireDirList(string, string2, bl, n, string3);
    }

    void fireTransfer(int n, byte[] byArray) {
        this.cFTP.fireTransfer(n, CBase.BYTE0);
    }
}

