/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CJDKIndependent;
import ipworks.IPWorksException;
import ipworks.Ipport;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

class CIPPortNoFirewall
extends CBase {
    private static final int IDLE = 1;
    private static final int CONNECTING = 2;
    private static final int CONNECTED = 3;
    private static final int DISCONNECTING = 4;
    private static final int BLOCKING = 0;
    private static final int NOT_BLOCKING = 1;
    private static final int SENT_BLOCKING = 0;
    private static final int SENT_NOT_BLOCKING = 1;
    private static final int WAITING_TO_RESEND = 2;
    private static final int RESEND = 3;
    private static final int WAITING_TO_INTERRUPT = 4;
    private int connectionState = 1;
    private int sendingState = 0;
    private int flowingState;
    private Ipport sink;
    private Socket socket;
    private ReaderThread readerThread;
    private WriterThread writerThread;
    private String remoteHost = "";
    private int remotePort = 0;
    private String localHost = "";
    private int localPort = 0;
    private int inBufferSize = 2048;
    private int outBufferSize = 2048;
    private byte[] eol = CBase.BYTE0;
    private int maxLineLength = 2048;
    private boolean acceptData = true;
    private boolean linger = true;
    private boolean keepAlive = false;
    private boolean dirtyAttempt;
    private int bytesSent = 0;
    private int reuseTimeout = 1;

    CIPPortNoFirewall(Ipport ipport, Object object) {
        this(ipport, null, object);
    }

    CIPPortNoFirewall(Ipport ipport, Socket socket, Object object) {
        super(object);
        this.sink = ipport;
        this.socket = socket;
    }

    boolean isIdle() {
        return this.connectionState == 1;
    }

    void setConnected(boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (bl) {
                if (this.connectionState == 2) {
                    throw new IPWorksException(1105);
                }
                if (this.connectionState == 3) {
                    throw new IPWorksException(104);
                }
            }
            long l = this.timeout == 0 ? 0L : System.currentTimeMillis();
            this.setConnected(bl, l);
        }
    }

    void setConnected(boolean bl, long l) throws IPWorksException {
        if (this.sendingState == 3 || this.sendingState == 2) {
            this.sendingState = 4;
            while (this.sendingState == 4) {
                try {
                    this.syncObj.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        int n = this.flowingState = l == 0L ? 1 : 0;
        if (bl) {
            this.pendingException = null;
            this.doConnect();
        } else {
            if (this.connectionState == 1) {
                return;
            }
            this.doDisconnect();
        }
        if (this.flowingState == 0) {
            int n2 = this.connectionState;
            while (n2 == this.connectionState) {
                try {
                    this.waitWhileProcessingEvents(l);
                }
                catch (IPWorksException iPWorksException) {
                    this.doDisconnect();
                    throw iPWorksException;
                }
            }
        }
    }

    private void doConnect() {
        this.connectionState = 2;
        this.sendingState = 0;
        if (this.readerThread != null && !this.readerThread.isReady()) {
            this.readerThread.beTerminating();
            this.readerThread = null;
        }
        if (this.readerThread == null) {
            this.readerThread = new ReaderThread();
            this.readerThread.start();
        }
        if (this.writerThread != null) {
            this.writerThread.beSilent();
            this.writerThread.beStanding();
        }
        this.readerThread.beRunning(this.socket);
    }

    private void doDisconnect() {
        this.connectionState = 4;
        if (this.readerThread != null) {
            this.readerThread.beStanding();
        }
        if (this.writerThread != null) {
            this.writerThread.beStanding();
        }
        this.socket = null;
    }

    boolean getConnected() {
        return this.connectionState == 3;
    }

    void setAcceptData(boolean bl) {
        Object object = this.syncObj;
        synchronized (object) {
            this.acceptData = bl;
            if (this.connectionState == 3 && bl) {
                this.readerThread.beRelaxingMaxLineLength();
                this.syncObj.notifyAll();
            }
        }
    }

    boolean getAcceptData() {
        return this.acceptData;
    }

    void setDataToSend(byte[] byArray) throws IPWorksException {
        if (byArray == null) {
            return;
        }
        this.setDataToSend(byArray, 0, byArray.length);
    }

    void setDataToSend(byte[] byArray, int n, int n2) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.sendingState == 3 || this.sendingState == 2 || this.sendingState == 4) {
                this.dirtyAttempt = true;
                throw new IPWorksException(135);
            }
            if (byArray == null) {
                return;
            }
            if (this.timeout == 0) {
                try {
                    this.trySetDataToSend(byArray, n, n2, 1);
                    Object var6_5 = null;
                    this.sendingState = 1;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.sendingState = 1;
                    throw throwable;
                }
            } else {
                this.setDataToSend(byArray, n, n2, System.currentTimeMillis(), 1);
            }
        }
    }

    void setDataToSend(byte[] byArray, int n, int n2, long l, int n3) throws IPWorksException {
        if (l + (long)(this.timeout * 1000) - System.currentTimeMillis() <= 0L) {
            throw new IPWorksException(201);
        }
        this.bytesSent = 0;
        this.dirtyAttempt = false;
        this.sendingState = 3;
        int n4 = 0;
        try {
            while (true) {
                try {
                    if (this.sendingState == 3) {
                        this.trySetDataToSend(byArray, n, n2, n3);
                        n4 += this.writerThread.getBytesSent();
                        break;
                    }
                    if (this.sendingState == 4) {
                        break;
                    }
                }
                catch (IPWorksException iPWorksException) {
                    if (iPWorksException.getCode() != 135) {
                        throw iPWorksException;
                    }
                    int n5 = this.writerThread.getBytesSent();
                    n += n5;
                    n2 -= n5;
                    n4 += n5;
                    this.sendingState = 2;
                }
                this.waitWhileProcessingEvents(l);
            }
            Object var11_9 = null;
            this.sendingState = 0;
            if (!this.dirtyAttempt) {
                this.bytesSent = n4;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.sendingState = 0;
            if (!this.dirtyAttempt) {
                this.bytesSent = n4;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void trySetDataToSend(byte[] byArray, int n, int n2, int n3) throws IPWorksException {
        block5: {
            if (this.connectionState != 3) throw new IPWorksException(1117);
            try {
                this.writerThread.write(byArray, n, n2);
                Object var6_5 = null;
                if (n3 == 1) break block5;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (n3 != 1) {
                    int n4 = this.writerThread.getBytesSent();
                    byte[] byArray2 = CBase.BYTE0;
                    if (n3 == 2) {
                        byArray2 = new byte[n4];
                        System.arraycopy(byArray, n, byArray2, 0, n4);
                    }
                    this.fireDataOut(n4, byArray2);
                }
                this.syncObj.notifyAll();
                throw throwable;
            }
            int n5 = this.writerThread.getBytesSent();
            byte[] byArray3 = CBase.BYTE0;
            if (n3 == 2) {
                byArray3 = new byte[n5];
                System.arraycopy(byArray, n, byArray3, 0, n5);
            }
            this.fireDataOut(n5, byArray3);
        }
        this.syncObj.notifyAll();
    }

    int getBytesSent() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 3) {
                int n = 0;
                return n;
            }
            int n = this.sendingState == 1 ? this.writerThread.getBytesSent() : this.bytesSent;
            return n;
        }
    }

    void setEOL(byte[] byArray) {
        Object object = this.syncObj;
        synchronized (object) {
            byte[] byArray2 = this.eol = byArray == null ? CBase.BYTE0 : byArray;
            if (this.connectionState == 3) {
                this.readerThread.setEOL(this.eol);
                this.syncObj.notifyAll();
            }
        }
    }

    byte[] getEOL() {
        return this.eol;
    }

    void setMaxLineLength(int n) {
        Object object = this.syncObj;
        synchronized (object) {
            if (n <= 0) {
                return;
            }
            this.maxLineLength = n;
            if (this.connectionState == 3) {
                this.readerThread.setMaxLineLength(n);
                this.syncObj.notifyAll();
            }
        }
    }

    int getMaxLineLength() {
        return this.maxLineLength;
    }

    void setLinger(boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.linger = bl;
            if (this.connectionState == 3) {
                try {
                    this.socket.setSoLinger(!bl, 0);
                }
                catch (IOException iOException) {
                    throw new IPWorksException(iOException);
                }
            }
        }
    }

    boolean getLinger() {
        return this.linger;
    }

    void setKeepAlive(boolean bl) {
        Object object = this.syncObj;
        synchronized (object) {
            this.keepAlive = bl;
        }
    }

    boolean getKeepAlive() {
        return false;
    }

    void setInBufferSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.inBufferSize = n;
            if (this.connectionState == 3) {
                try {
                    CJDKIndependent.cJDKSocketsIndependent.socketSetReceiveBufferSize(this.socket, n);
                }
                catch (SocketException socketException) {
                    throw new IPWorksException(socketException);
                }
            }
        }
    }

    int getInBufferSize() {
        return this.inBufferSize;
    }

    void setOutBufferSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.outBufferSize = n;
            if (this.connectionState == 3) {
                try {
                    CJDKIndependent.cJDKSocketsIndependent.socketSetSendBufferSize(this.socket, n);
                    this.writerThread.updateBufferSize();
                }
                catch (SocketException socketException) {
                    throw new IPWorksException(socketException);
                }
            }
        }
    }

    int getOutBufferSize() {
        return this.outBufferSize;
    }

    void setLocalHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 1 && this.connectionState != 4) {
                throw new IPWorksException(1119);
            }
            this.localHost = string != null ? string : "";
        }
    }

    String getLocalHost() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState == 3) {
                String string = this.socket.getLocalAddress().getHostAddress();
                return string;
            }
            String string = this.localHost;
            return string;
        }
    }

    void setLocalPort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 1 && this.connectionState != 4) {
                throw new IPWorksException(106);
            }
            this.localPort = n;
        }
    }

    int getLocalPort() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState == 3) {
                int n = this.socket.getLocalPort();
                return n;
            }
            int n = this.localPort;
            return n;
        }
    }

    void setRemoteHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 1 && this.connectionState != 4) {
                throw new IPWorksException(101);
            }
            this.remoteHost = string != null ? string : "";
        }
    }

    String getRemoteHost() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState == 3) {
                String string = this.socket.getInetAddress().getHostAddress();
                return string;
            }
            String string = this.remoteHost;
            return string;
        }
    }

    void setRemotePort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState != 1 && this.connectionState != 4) {
                throw new IPWorksException(100);
            }
            this.remotePort = n;
        }
    }

    int getRemotePort() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.connectionState == 3) {
                int n = this.socket.getPort();
                return n;
            }
            int n = this.remotePort;
            return n;
        }
    }

    void setReuseTimeout(int n) {
        Object object = this.syncObj;
        synchronized (object) {
            this.reuseTimeout = n > 0 ? n : 0;
        }
    }

    private void reportConnectionFailure(IPWorksException iPWorksException) {
        this.connectionState = 1;
        if (this.flowingState == 0) {
            if (this.pendingException == null) {
                this.pendingException = iPWorksException;
            }
            this.syncObj.notifyAll();
        } else {
            this.fireConnected(iPWorksException);
        }
    }

    private void reportCreatedSocket(Socket socket) {
        this.socket = socket;
        if (this.writerThread != null && !this.writerThread.isReady()) {
            this.writerThread.beTerminating();
            this.writerThread = null;
        }
        if (this.writerThread == null) {
            this.writerThread = new WriterThread();
            this.writerThread.start();
        }
        this.writerThread.beRunning(socket);
    }

    private void reportConnectionSuccess() {
        this.connectionState = 3;
        this.syncObj.notifyAll();
        this.fireConnected(null);
        this.reportReadyToSend();
    }

    private void reportDisconnection(IPWorksException iPWorksException) {
        if (this.sendingState == 2) {
            this.sendingState = 3;
        }
        if (this.flowingState == 0 && this.pendingException == null) {
            this.pendingException = iPWorksException;
        }
        boolean bl = this.connectionState == 4;
        this.connectionState = 1;
        if (bl) {
            this.fireDisconnected(this.flowingState == 0 ? this.pendingException : iPWorksException);
        }
        this.syncObj.notifyAll();
    }

    private void reportReadyToSend() {
        if (this.sendingState == 2) {
            this.sendingState = 3;
        } else {
            this.fireReadyToSend();
        }
        this.syncObj.notifyAll();
    }

    void fireDataOut(int n, byte[] byArray) {
    }

    void fireConnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireConnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireConnected(0, "OK");
            }
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireDisconnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireDisconnected(0, "OK");
            }
        }
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        if (this.sink != null) {
            this.sink.fireDataIn(byArray, bl);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    void fireReadyToSend() {
        if (this.sink != null) {
            this.sink.fireReadyToSend();
        }
    }

    static /* synthetic */ byte[] access$1702(CIPPortNoFirewall cIPPortNoFirewall, byte[] byArray) {
        cIPPortNoFirewall.eol = byArray;
        return byArray;
    }

    private class WriterThread
    extends Thread {
        private static final int GOING_TO_RUN = 1;
        private static final int RUNNING = 2;
        private static final int GOING_TO_SLEEP = 3;
        private static final int SLEEPING = 4;
        private static final int TERMINATING = 5;
        private int state = 4;
        private Socket socket;
        private OutputStream os;
        private int bytesSent;
        private byte[][] dataBuffer;
        private byte[] fillingBuffer;
        private int fillingBufferIndex;
        private byte bufferIndex;
        private boolean toUpdateBufferSize;
        private boolean toReportReadyToSend;
        private boolean fire = true;

        private WriterThread() {
        }

        private boolean isReady() {
            return this.state == 4;
        }

        private void beSilent() {
            this.fire = false;
        }

        private void beStanding() {
            if (this.state == 5) {
                return;
            }
            this.state = 3;
            if (!CIPPortNoFirewall.this.linger && this.socket != null) {
                this.doDisconnect();
            }
            CIPPortNoFirewall.this.syncObj.notifyAll();
        }

        private void doDisconnect() {
            IPWorksException iPWorksException = null;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iPWorksException = new IPWorksException(iOException);
            }
            this.socket = null;
            Object object = CIPPortNoFirewall.this.syncObj;
            synchronized (object) {
                if (this.fire) {
                    CIPPortNoFirewall.this.reportDisconnection(iPWorksException);
                }
            }
        }

        private void beRunning(Socket socket) {
            this.socket = socket;
            this.state = 1;
            this.bytesSent = 0;
            this.dataBuffer = new byte[2][CIPPortNoFirewall.this.outBufferSize];
            this.fillingBuffer = this.dataBuffer[this.bufferIndex];
            this.fillingBufferIndex = 0;
            this.bufferIndex = 0;
            this.toUpdateBufferSize = false;
            this.toReportReadyToSend = false;
            this.fire = true;
            try {
                this.os = socket.getOutputStream();
            }
            catch (IOException iOException) {
                this.os = null;
                CIPPortNoFirewall.this.fireError(new IPWorksException(iOException));
            }
        }

        private void beTerminating() {
            this.state = 5;
            this.fire = false;
        }

        private void updateBufferSize() {
            this.toUpdateBufferSize = true;
        }

        private void write(byte[] byArray) throws IPWorksException {
            this.bytesSent = Math.min(this.fillingBuffer.length - this.fillingBufferIndex, byArray.length);
            System.arraycopy(byArray, 0, this.fillingBuffer, this.fillingBufferIndex, this.bytesSent);
            this.fillingBufferIndex += this.bytesSent;
            if (this.bytesSent < byArray.length) {
                this.toReportReadyToSend = true;
                throw new IPWorksException(135);
            }
        }

        private void write(byte[] byArray, int n, int n2) throws IPWorksException {
            this.bytesSent = Math.min(this.fillingBuffer.length - this.fillingBufferIndex, n2);
            System.arraycopy(byArray, n, this.fillingBuffer, this.fillingBufferIndex, this.bytesSent);
            this.fillingBufferIndex += this.bytesSent;
            if (this.bytesSent < n2) {
                this.toReportReadyToSend = true;
                throw new IPWorksException(135);
            }
        }

        private int getBytesSent() {
            return this.bytesSent;
        }

        private void tryToReportReadyToSend() {
            Object object = CIPPortNoFirewall.this.syncObj;
            synchronized (object) {
                if (this.fire && this.toReportReadyToSend) {
                    this.toReportReadyToSend = false;
                    CIPPortNoFirewall.this.reportReadyToSend();
                }
            }
        }

        private void monitorDataOut() {
            while (true) {
                Object object = CIPPortNoFirewall.this.syncObj;
                synchronized (object) {
                    if (this.fillingBufferIndex == 0) {
                        if (this.state != 2) {
                            break;
                        }
                        try {
                            CIPPortNoFirewall.this.syncObj.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.toUpdateBufferSize) {
                        this.toUpdateBufferSize = false;
                        this.dataBuffer = new byte[2][CIPPortNoFirewall.this.outBufferSize];
                    }
                }
                if (this.fillingBufferIndex <= 0) continue;
                try {
                    int n;
                    byte[] byArray;
                    Object object2 = CIPPortNoFirewall.this.syncObj;
                    synchronized (object2) {
                        byArray = this.fillingBuffer;
                        n = this.fillingBufferIndex;
                        this.bufferIndex = (byte)(1 - this.bufferIndex);
                        this.fillingBuffer = this.dataBuffer[this.bufferIndex];
                        this.fillingBufferIndex = 0;
                    }
                    this.os.write(byArray, 0, n);
                    this.tryToReportReadyToSend();
                }
                catch (IOException iOException) {
                    Object object3 = CIPPortNoFirewall.this.syncObj;
                    synchronized (object3) {
                        if (this.fire) {
                            CIPPortNoFirewall.this.fireError(new IPWorksException(iOException));
                        }
                    }
                }
            }
        }

        private void waitForReuse() {
            Object object = CIPPortNoFirewall.this.syncObj;
            synchronized (object) {
                long l = System.currentTimeMillis();
                while (true) {
                    long l2 = l + (long)CIPPortNoFirewall.this.reuseTimeout - System.currentTimeMillis();
                    if (this.state == 1) {
                        this.state = this.os == null ? 5 : 2;
                        return;
                    }
                    if (l2 <= 0L) {
                        this.state = 5;
                        return;
                    }
                    this.state = 4;
                    try {
                        CIPPortNoFirewall.this.syncObj.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void run() {
            while (this.state != 5) {
                this.waitForReuse();
                this.monitorDataOut();
                Object object = CIPPortNoFirewall.this.syncObj;
                synchronized (object) {
                    if (this.socket != null) {
                        this.doDisconnect();
                    }
                }
            }
        }
    }

    private class ReaderThread
    extends Thread {
        private static final int GOING_TO_RUN = 1;
        private static final int RUNNING = 2;
        private static final int GOING_TO_SLEEP = 3;
        private static final int SLEEPING = 4;
        private static final int TERMINATING = 5;
        private int state = 4;
        private Socket socket = null;
        private InputStream is;
        private byte[] waitingEol;
        private int waitingMaxLineLength;
        private int currentMaxLineLength;
        private boolean waitingToRelax;
        private boolean dataIsValid;
        private boolean isReady = true;
        private byte[] inBuffer;
        private boolean check;
        private int begin;
        private int middle;
        private int end;

        private ReaderThread() {
        }

        private boolean isReady() {
            return this.isReady && this.state != 5;
        }

        private void beStanding() {
            if (this.state == 5) {
                return;
            }
            this.state = 4;
            CIPPortNoFirewall.this.syncObj.notifyAll();
        }

        private void beRunning(Socket socket) {
            this.socket = socket;
            this.state = 1;
            CIPPortNoFirewall.this.syncObj.notifyAll();
        }

        private void doRestart() {
            this.state = 2;
            this.waitingEol = CIPPortNoFirewall.this.eol;
            this.waitingMaxLineLength = this.currentMaxLineLength = CIPPortNoFirewall.this.getMaxLineLength();
            this.waitingToRelax = false;
            this.dataIsValid = true;
            this.inBuffer = new byte[this.currentMaxLineLength + 1];
            this.check = false;
            this.end = 0;
            this.middle = 0;
            this.begin = 0;
        }

        private void beTerminating() {
            this.state = 5;
        }

        private void tryToConnect() {
            Object object = CIPPortNoFirewall.this.syncObj;
            synchronized (object) {
                if (this.state != 2) {
                    return;
                }
            }
            boolean bl = this.socket == null;
            try {
                Object object2;
                if (bl) {
                    if (CIPPortNoFirewall.this.remoteHost.length() == 0) {
                        throw new UnknownHostException("\"\"");
                    }
                    object2 = CIPPortNoFirewall.this.syncObj;
                    synchronized (object2) {
                        if (this.state != 2) {
                            return;
                        }
                        this.isReady = false;
                    }
                    try {
                        InetAddress inetAddress = CIPPortNoFirewall.this.localHost.length() == 0 ? InetAddress.getLocalHost() : InetAddress.getByName(CIPPortNoFirewall.this.localHost);
                        this.socket = new Socket(CIPPortNoFirewall.this.remoteHost, CIPPortNoFirewall.this.remotePort, inetAddress, CIPPortNoFirewall.this.localPort);
                    }
                    catch (Exception exception) {
                        try {
                            InetAddress inetAddress = InetAddress.getLocalHost();
                            this.socket = new Socket(CIPPortNoFirewall.this.remoteHost, CIPPortNoFirewall.this.remotePort, inetAddress, CIPPortNoFirewall.this.localPort);
                        }
                        catch (Exception exception2) {
                            this.socket = new Socket(CIPPortNoFirewall.this.remoteHost, CIPPortNoFirewall.this.remotePort);
                        }
                    }
                }
                CJDKIndependent.cJDKSocketsIndependent.socketSetSendBufferSize(this.socket, CIPPortNoFirewall.this.outBufferSize);
                CJDKIndependent.cJDKSocketsIndependent.socketSetReceiveBufferSize(this.socket, CIPPortNoFirewall.this.inBufferSize);
                if (!CIPPortNoFirewall.this.getLinger()) {
                    this.socket.setSoLinger(true, 0);
                }
                this.socket.setSoTimeout(100);
                this.socket.setTcpNoDelay(true);
                this.is = this.socket.getInputStream();
                object2 = CIPPortNoFirewall.this.syncObj;
                synchronized (object2) {
                    if (this.state == 2) {
                        CIPPortNoFirewall.this.reportCreatedSocket(this.socket);
                    }
                    if (this.state == 2) {
                        CIPPortNoFirewall.this.reportConnectionSuccess();
                    } else if (bl) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.isReady = true;
                }
            }
            catch (IOException iOException) {
                if (bl && this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                Object object3 = CIPPortNoFirewall.this.syncObj;
                synchronized (object3) {
                    if (this.state == 2) {
                        CIPPortNoFirewall.this.reportConnectionFailure(new IPWorksException(iOException));
                        this.state = 4;
                    }
                    this.isReady = true;
                }
            }
            this.socket = null;
        }

        private void setEOL(byte[] byArray) {
            this.waitingEol = byArray;
            this.dataIsValid = false;
        }

        private void setMaxLineLength(int n) {
            this.waitingMaxLineLength = n;
            this.waitingToRelax = false;
            this.dataIsValid = false;
        }

        private boolean beRelaxingMaxLineLength() {
            this.waitingToRelax = this.sum(this.end, -this.begin) != 0;
            return this.waitingToRelax;
        }

        private void renewBreakingConditions() {
            int n = this.currentMaxLineLength = this.waitingToRelax ? this.sum(this.end, -this.begin) : this.waitingMaxLineLength;
            if (this.currentMaxLineLength + 1 > this.inBuffer.length) {
                byte[] byArray = new byte[this.currentMaxLineLength + 1];
                this.transfer(byArray, this.sum(this.end, -this.begin));
                this.end = this.sum(this.end, -this.begin);
                this.begin = 0;
                this.inBuffer = byArray;
            }
            CIPPortNoFirewall.access$1702(CIPPortNoFirewall.this, this.waitingEol);
            this.middle = this.begin;
            this.check = true;
            this.dataIsValid = true;
            this.waitingToRelax = false;
        }

        private boolean nextMiddle(int n) {
            this.middle = this.sum(this.middle, n);
            return this.sum(this.end, -this.middle) >= CIPPortNoFirewall.this.eol.length;
        }

        private void transfer(byte[] byArray, int n) {
            if (this.end > this.begin) {
                System.arraycopy(this.inBuffer, this.begin, byArray, 0, n);
            } else if (this.begin + n <= this.inBuffer.length) {
                System.arraycopy(this.inBuffer, this.begin, byArray, 0, n);
            } else {
                System.arraycopy(this.inBuffer, this.begin, byArray, 0, this.inBuffer.length - this.begin);
                int n2 = n - (this.inBuffer.length - this.begin);
                System.arraycopy(this.inBuffer, 0, byArray, this.inBuffer.length - this.begin, n2);
            }
        }

        private int sum(int n, int n2) {
            int n3 = n + n2;
            if (n3 < 0) {
                n3 += this.inBuffer.length;
            } else if (n3 >= this.inBuffer.length) {
                n3 -= this.inBuffer.length;
            }
            return n3;
        }

        private byte[] getLineEOL() {
            if (CIPPortNoFirewall.this.eol.length == 0) {
                return null;
            }
            int n = 0;
            while (this.nextMiddle(n)) {
                int n2 = this.middle;
                int n3 = 0;
                while (n3 < CIPPortNoFirewall.this.eol.length && this.inBuffer[n2] == CIPPortNoFirewall.this.eol[n3]) {
                    n2 = this.sum(n2, 1);
                    ++n3;
                }
                if (n3 == CIPPortNoFirewall.this.eol.length) {
                    int n4 = this.sum(n2, -this.begin) - CIPPortNoFirewall.this.eol.length;
                    byte[] byArray = new byte[n4];
                    this.transfer(byArray, n4);
                    this.middle = n2;
                    return byArray;
                }
                n = 1;
            }
            return null;
        }

        private byte[] getLineMaxLength() {
            if (this.sum(this.end, -this.begin) >= this.currentMaxLineLength) {
                byte[] byArray = new byte[this.currentMaxLineLength];
                this.transfer(byArray, this.currentMaxLineLength);
                this.middle = this.sum(this.begin, this.currentMaxLineLength);
                return byArray;
            }
            if (CIPPortNoFirewall.this.eol.length == 0 && this.begin != this.end) {
                int n = this.sum(this.end, -this.begin);
                byte[] byArray = new byte[n];
                this.transfer(byArray, n);
                this.middle = this.end;
                return byArray;
            }
            return null;
        }

        private boolean readData() throws IOException {
            int n;
            int n2;
            if (this.end >= this.begin) {
                n2 = this.inBuffer.length - this.end;
                if (this.begin == 0) {
                    --n2;
                }
                try {
                    n = this.is.read(this.inBuffer, this.end, n2);
                }
                catch (InterruptedIOException interruptedIOException) {
                    return true;
                }
                if (n == -1) {
                    return false;
                }
                this.end = this.sum(this.end, n);
                this.check = true;
            }
            if (this.end < this.begin) {
                n2 = this.begin - this.end - 1;
                try {
                    n = this.is.read(this.inBuffer, this.end, n2);
                }
                catch (InterruptedIOException interruptedIOException) {
                    return true;
                }
                if (n == -1) {
                    return false;
                }
                this.end += n;
                this.check = true;
            }
            return true;
        }

        private void monitorDataIn() {
            boolean bl = true;
            IPWorksException iPWorksException = null;
            while (true) {
                Object object = CIPPortNoFirewall.this.syncObj;
                synchronized (object) {
                    if (this.state != 2) {
                        break;
                    }
                    if (!this.dataIsValid || this.waitingToRelax) {
                        this.renewBreakingConditions();
                    }
                }
                if (this.check) {
                    byte[] byArray = this.getLineEOL();
                    if (byArray != null) {
                        this.tryToFireDataIn(byArray, true);
                        continue;
                    }
                    byArray = this.getLineMaxLength();
                    if (byArray != null) {
                        this.tryToFireDataIn(byArray, false);
                        continue;
                    }
                    this.check = false;
                }
                try {
                    if (bl) {
                        bl = this.readData();
                    }
                }
                catch (IOException iOException) {
                    bl = false;
                    iPWorksException = new IPWorksException(iOException);
                }
                if (bl) continue;
                Object object2 = CIPPortNoFirewall.this.syncObj;
                synchronized (object2) {
                    if (!this.dataIsValid) {
                        continue;
                    }
                    if (this.beRelaxingMaxLineLength()) {
                        continue;
                    }
                }
                if (iPWorksException != null) {
                    this.tryToFireError(iPWorksException);
                }
                Object object3 = CIPPortNoFirewall.this.syncObj;
                synchronized (object3) {
                    if (this.state == 2) {
                        try {
                            if (CIPPortNoFirewall.this.pendingException == null && CIPPortNoFirewall.this.connectionState == 3) {
                                CIPPortNoFirewall.this.pendingException = iPWorksException;
                            }
                            CIPPortNoFirewall.this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException2) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        private void waitForReuse() {
            Object object = CIPPortNoFirewall.this.syncObj;
            synchronized (object) {
                long l = System.currentTimeMillis();
                while (true) {
                    long l2 = l + (long)CIPPortNoFirewall.this.reuseTimeout - System.currentTimeMillis();
                    if (this.state == 1) {
                        this.doRestart();
                        return;
                    }
                    if (l2 <= 0L) {
                        this.state = 5;
                        return;
                    }
                    this.state = 4;
                    try {
                        CIPPortNoFirewall.this.syncObj.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public void run() {
            while (this.state != 5) {
                this.tryToConnect();
                this.monitorDataIn();
                this.waitForReuse();
            }
        }

        private void tryToFireDataIn(byte[] byArray, boolean bl) {
            Object object = CIPPortNoFirewall.this.syncObj;
            synchronized (object) {
                if (this.state != 2) {
                    return;
                }
                if (CIPPortNoFirewall.this.acceptData && this.dataIsValid) {
                    CIPPortNoFirewall.this.fireDataIn(byArray, bl);
                    this.begin = this.middle;
                    if (this.currentMaxLineLength != this.waitingMaxLineLength) {
                        this.renewBreakingConditions();
                    }
                    return;
                }
                if (!CIPPortNoFirewall.this.acceptData) {
                    try {
                        CIPPortNoFirewall.this.syncObj.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.middle = this.begin;
            }
        }

        private void tryToFireError(IPWorksException iPWorksException) {
            Object object = CIPPortNoFirewall.this.syncObj;
            synchronized (object) {
                if (this.state == 2) {
                    CIPPortNoFirewall.this.fireError(iPWorksException);
                }
            }
        }
    }
}

