/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CJDKIndependent;
import ipworks.IPWorksException;
import ipworks.Mcast;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

class CMCast
extends CBase {
    private static final int disactive = 1;
    private static final int active = 2;
    private int state = 1;
    MulticastSocket socket = null;
    private DatagramPacket packet;
    private CReaderThread reader;
    private String multicastGroup = "";
    private String remoteHost = "";
    private int remotePort = 0;
    private String receiveInterface = "";
    private String sendInterface = "";
    private int localPort = 0;
    private int inBufferSize = 2048;
    private int outBufferSize = 2048;
    private boolean acceptData = true;
    private int timeToLive = 7;
    private int maxPacketSize = 2048;
    private Mcast sink = null;

    CMCast(Mcast mcast, Object object) {
        super(object);
        this.sink = mcast;
    }

    void do_Send(byte[] byArray) throws IPWorksException {
        this.setDataToSend(byArray);
    }

    int getQOSFlags() {
        return 0;
    }

    void setQOSFlags(int n) throws IPWorksException {
        throw new IPWorksException();
    }

    void setActive(boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (bl) {
                if (this.state == 2) {
                    throw new IPWorksException(3104);
                }
                this.doActivate();
            } else if (this.state == 2) {
                this.reader.terminate();
                this.doDisactivate();
            }
        }
    }

    boolean getActive() {
        Object object = this.syncObj;
        synchronized (object) {
            boolean bl = this.state == 2;
            return bl;
        }
    }

    void doActivate() throws IPWorksException {
        try {
            InetAddress inetAddress = this.sendInterface.equals("") ? InetAddress.getLocalHost() : InetAddress.getAllByName(this.sendInterface)[0];
            InetAddress inetAddress2 = InetAddress.getByName(this.remoteHost);
            this.socket = new MulticastSocket(this.localPort);
            this.socket.setInterface(inetAddress);
            this.socket.setSoTimeout(100);
            CJDKIndependent.cJDKSocketsIndependent.multicastSocketSetTimeToLive(this.socket, this.timeToLive);
            CJDKIndependent.cJDKSocketsIndependent.datagramSocketSetSendBufferSize(this.socket, this.outBufferSize);
            CJDKIndependent.cJDKSocketsIndependent.datagramSocketSetReceiveBufferSize(this.socket, this.inBufferSize);
            this.packet = new DatagramPacket(new byte[1], 1, inetAddress2, this.remotePort);
            this.reader = new CReaderThread();
            if (!this.acceptData) {
                this.reader.disable();
            }
            this.reader.start();
            this.state = 2;
        }
        catch (IOException iOException) {
            this.doDisactivate();
            throw new IPWorksException(iOException);
        }
    }

    void doDisactivate() {
        this.state = 1;
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        this.packet = null;
    }

    void setAcceptData(boolean bl) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                if (bl && !this.acceptData) {
                    this.reader.enable();
                } else if (!bl && this.acceptData) {
                    this.reader.disable();
                }
            }
            this.acceptData = bl;
        }
    }

    boolean getAcceptData() {
        Object object = this.syncObj;
        synchronized (object) {
            boolean bl = this.acceptData;
            return bl;
        }
    }

    void setMaxPacketSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                throw new IPWorksException(3112);
            }
            this.maxPacketSize = n;
        }
    }

    int getMaxPacketSize() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.maxPacketSize;
            return n;
        }
    }

    void setDataToSend(byte[] byArray, int n, int n2) throws IPWorksException {
        if (byArray == null) {
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                CJDKIndependent.cJDKSocketsIndependent.setData(this.packet, byArray, n, n2);
                try {
                    this.socket.send(this.packet);
                }
                catch (IOException iOException) {
                    throw new IPWorksException(iOException);
                }
            } else {
                throw new IPWorksException(3109);
            }
        }
    }

    void setDataToSend(byte[] byArray) throws IPWorksException {
        if (byArray == null) {
            return;
        }
        this.setDataToSend(byArray, 0, byArray.length);
    }

    void setTimeToLive(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                try {
                    CJDKIndependent.cJDKSocketsIndependent.multicastSocketSetTimeToLive(this.socket, n);
                }
                catch (IOException iOException) {
                    throw new IPWorksException(iOException);
                }
            }
            this.timeToLive = n;
        }
    }

    int getTimeToLive() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                try {
                    int n = CJDKIndependent.cJDKSocketsIndependent.multicastSocketGetTimeToLive(this.socket);
                    return n;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            int n = this.timeToLive;
            return n;
        }
    }

    void setInBufferSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                try {
                    CJDKIndependent.cJDKSocketsIndependent.datagramSocketSetReceiveBufferSize(this.socket, this.inBufferSize);
                }
                catch (SocketException socketException) {
                    throw new IPWorksException(socketException);
                }
            }
            this.inBufferSize = n;
        }
    }

    int getInBufferSize() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.inBufferSize;
            return n;
        }
    }

    void setOutBufferSize(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                try {
                    CJDKIndependent.cJDKSocketsIndependent.datagramSocketSetSendBufferSize(this.socket, this.outBufferSize);
                }
                catch (SocketException socketException) {
                    throw new IPWorksException(socketException);
                }
            }
            this.outBufferSize = n;
        }
    }

    int getOutBufferSize() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.outBufferSize;
            return n;
        }
    }

    void setMulticastGroup(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state != 2) {
                throw new IPWorksException(3109);
            }
            if (string == null || string.length() == 0) {
                return;
            }
            int n = 0;
            int n2 = 1;
            if (string.charAt(0) == '-') {
                n = 1;
                n2 = 2;
            } else if (string.charAt(0) == '+') {
                n = 1;
            }
            String string2 = string.substring(n);
            try {
                if (n2 == 1) {
                    this.socket.joinGroup(InetAddress.getByName(string2));
                } else {
                    this.socket.leaveGroup(InetAddress.getByName(string2));
                }
            }
            catch (IOException iOException) {
                throw new IPWorksException(iOException);
            }
            this.multicastGroup = string2;
        }
    }

    String getMulticastGroup() {
        return this.multicastGroup;
    }

    void setSendInterface(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            String string2;
            String string3 = string2 = string != null ? string : "";
            if (this.state == 2) {
                try {
                    InetAddress inetAddress = string2.equals("") ? InetAddress.getLocalHost() : InetAddress.getAllByName(this.sendInterface)[0];
                    this.socket.setInterface(inetAddress);
                }
                catch (IOException iOException) {
                    throw new IPWorksException(iOException);
                }
            }
            this.sendInterface = string2;
        }
    }

    String getSendInterface() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                try {
                    String string = this.socket.getInterface().getHostAddress();
                    return string;
                }
                catch (IOException iOException) {
                    String string = "";
                    return string;
                }
            }
            String string = this.sendInterface;
            return string;
        }
    }

    void setReceiveInterface(String string) {
        Object object = this.syncObj;
        synchronized (object) {
            this.receiveInterface = string;
        }
    }

    String getReceiveInterface() {
        Object object = this.syncObj;
        synchronized (object) {
            String string = this.receiveInterface;
            return string;
        }
    }

    String getLocalHost() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                String string = this.socket.getLocalAddress().getHostAddress();
                return string;
            }
            try {
                String string = InetAddress.getLocalHost().getHostAddress();
                return string;
            }
            catch (UnknownHostException unknownHostException) {
                String string = "";
                return string;
            }
        }
    }

    void setLocalHost(String string) throws IPWorksException {
        throw new IPWorksException();
    }

    boolean getLoopback() {
        return false;
    }

    void setLoopback(boolean bl) throws IPWorksException {
        throw new IPWorksException();
    }

    boolean getShareLocalPort() {
        return false;
    }

    void setShareLocalPort(boolean bl) throws IPWorksException {
        throw new IPWorksException();
    }

    void setLocalPort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                throw new IPWorksException(3106);
            }
            this.localPort = n;
        }
    }

    int getLocalPort() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                int n = this.socket.getLocalPort();
                return n;
            }
            int n = this.localPort;
            return n;
        }
    }

    void setRemoteHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            String string2 = string != null ? string : "";
            try {
                if (this.state == 2) {
                    this.packet.setAddress(InetAddress.getByName(string2));
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new IPWorksException(unknownHostException);
            }
            this.remoteHost = string2;
        }
    }

    String getRemoteHost() {
        return this.remoteHost;
    }

    void setRemotePort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.state == 2) {
                this.packet.setPort(n);
            }
            this.remotePort = n;
        }
    }

    int getRemotePort() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.remotePort;
            return n;
        }
    }

    void fireDataIn(byte[] byArray, String string, int n) {
        if (this.sink != null) {
            this.sink.fireDataIn(byArray, string, n);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireError(0, "OK");
            }
        }
    }

    void fireReadyToSend() {
        if (this.sink != null) {
            this.sink.fireReadyToSend();
        }
    }

    class CReaderThread
    extends Thread {
        private static final int running = 1;
        private static final int terminating = 2;
        private static final int pending = 3;
        private int state = 1;
        private MulticastSocket socket;
        private DatagramPacket packet;
        private int maxPacketSize;

        CReaderThread() {
            this.socket = CMCast.this.socket;
            this.maxPacketSize = CMCast.this.getMaxPacketSize();
            this.packet = new DatagramPacket(new byte[this.maxPacketSize], this.maxPacketSize);
        }

        void terminate() {
            this.state = 2;
            CMCast.this.syncObj.notify();
        }

        void disable() {
            this.state = 3;
        }

        void enable() {
            this.state = 1;
            CMCast.this.syncObj.notify();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void tryToFireDataIn() {
            int n = this.packet.getLength();
            byte[] byArray = new byte[n];
            System.arraycopy(this.packet.getData(), 0, byArray, 0, n);
            Object object = CMCast.this.syncObj;
            synchronized (object) {
                while (this.state == 3) {
                    try {
                        CMCast.this.syncObj.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.state != 1) return;
                CMCast.this.fireDataIn(byArray, this.packet.getAddress().getHostAddress(), this.packet.getPort());
                return;
            }
        }

        public void run() {
            boolean bl = false;
            while (this.state != 2) {
                if (bl) {
                    this.tryToFireDataIn();
                    this.packet.setLength(this.maxPacketSize);
                    bl = false;
                }
                try {
                    this.socket.receive(this.packet);
                    bl = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

