/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CNetCode;
import ipworks.DelimitedInputStream;
import ipworks.FragmentedInputStream;
import ipworks.IPWorksException;
import ipworks.Mime;
import ipworks.ProgressInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

class CMIME {
    static final int a_Idle = 0;
    static final int a_DecodeFromFile = 1;
    static final int a_DecodeFromString = 2;
    static final int ENCODE_TO_FILE = 3;
    static final int a_EncodeToString = 4;
    static final int RESET = 5;
    static final int SEVEN_BIT = 0;
    static final int pe_QuotedPrintable = 1;
    static final int pe_Base64 = 2;
    static final int EIGHT_BIT = 3;
    static final int BINARY = 4;
    private static final int headersIndex = 0;
    private static final int contentTypeIndex = 1;
    private static final int contentTypeAttrIndex = 2;
    private static final int contentIdIndex = 3;
    private static final int contentDispositionIndex = 4;
    private static final int contentDispositionAttrIndex = 5;
    private static final int encodingIndex = 6;
    private static final int filenameIndex = 7;
    private static final int nameIndex = 8;
    private static final int decodedFileIndex = 9;
    private static final int maxProperties = 10;
    private static final int maxParts = 100;
    private static final int maxLineLength = 76;
    private static final int encoded = 1;
    private static final int decoded = 2;
    private static final int stringSupport = 1;
    private static final int fileSupport = 2;
    protected static final String cr = "\r";
    protected static final String lf = "\n";
    protected static final String crlf = "\r\n";
    private static final byte[] BYTE0 = new byte[0];
    protected static final byte[] crlfEol = "\r\n".getBytes();
    private static final String[] encoding = new String[]{"7bit", "quoted-printable", "base64", "8bit", "binary"};
    private Random randomizer = null;
    private CNetCode netcode = new CNetCode(null, new Object());
    private int action = 0;
    private int lastAction = 0;
    private String boundary = "";
    private int partCount = 0;
    private long[] bodyOffset = new long[101];
    private long[] bodyLength = new long[101];
    private byte[][] body = new byte[101][];
    private String[][] parts = new String[101][10];
    private int currentPoz;
    private String currentHeader;
    private String currentHeaderName;
    private String currentHeaderValue;
    private byte[] currentMessageByte;
    private long totalSize;
    private int pozPercent;
    private Object syncObj;
    Mime sink = null;

    CMIME(Mime mime, Object object) {
        this.sink = mime;
        this.syncObj = object;
        this.resetAllHeaders();
    }

    private void resetAllHeaders() {
        int n = 0;
        while (n <= 100) {
            int n2 = 0;
            while (n2 < 10) {
                this.parts[n][n2] = "";
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 <= 100) {
            this.body[n3] = BYTE0;
            this.bodyLength[n3] = 0L;
            this.bodyOffset[n3] = 0L;
            this.parts[n3][6] = "7bit";
            ++n3;
        }
        this.parts[100][6] = "";
    }

    void do_DecodeFromFile() throws IPWorksException {
        this.setAction(1);
    }

    void do_DecodeFromString() throws IPWorksException {
        this.setAction(2);
    }

    void do_EncodeToFile() throws IPWorksException {
        this.setAction(3);
    }

    void do_EncodeToString() throws IPWorksException {
        this.setAction(4);
    }

    void do_ResetData() throws IPWorksException {
        this.setAction(5);
    }

    int getAction() {
        return this.action;
    }

    String getBoundary() {
        return this.boundary;
    }

    void setBoundary(String string) throws IPWorksException {
        this.boundary = string != null ? string : "";
        this.buildHeaders(100);
    }

    String getContentType() {
        return this.parts[100][1];
    }

    void setContentType(String string) throws IPWorksException {
        this.parts[100][1] = string != null ? string : "";
        this.buildHeaders(100);
    }

    String getContentTypeAttr() {
        return this.parts[100][2];
    }

    void setContentTypeAttr(String string) throws IPWorksException {
        this.parts[100][2] = string != null ? string : "";
        this.buildHeaders(100);
    }

    byte[] getMessage() {
        if (this.lastAction != 2 && this.lastAction != 1) {
            return this.body[100];
        }
        try {
            this.decode(100, false);
            return this.body[100];
        }
        catch (IPWorksException iPWorksException) {
            return BYTE0;
        }
    }

    void setMessage(byte[] byArray, int n, int n2) throws IPWorksException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.setMessage(byArray2);
    }

    void setPartDecodedString(int n, byte[] byArray, int n2, int n3) throws IPWorksException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.setPartDecodedString(n, byArray2);
    }

    void setMessage(byte[] byArray) throws IPWorksException {
        this.body[100] = byArray != null ? byArray : BYTE0;
    }

    String getMessageHeaders() {
        return this.parts[100][0];
    }

    void setMessageHeaders(String string) throws IPWorksException {
        this.parts[100][0] = string != null ? CMIME.toValidHeader(string) : "";
    }

    private boolean indexInRange(int n) {
        return n >= 0 && n < this.partCount;
    }

    private void checkIndex(int n) throws IPWorksException {
        if (!this.indexInRange(n)) {
            throw new IPWorksException(280);
        }
    }

    String getPartContentId(int n) {
        return this.indexInRange(n) ? this.parts[n][3] : "";
    }

    void setPartContentId(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][3] = string != null ? string : "";
        this.buildHeaders(n);
    }

    String getPartContentType(int n) {
        return this.indexInRange(n) ? this.parts[n][1] : "";
    }

    void setPartContentType(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][1] = string != null ? string : "";
        this.buildHeaders(n);
    }

    String getPartContentTypeAttr(int n) {
        return this.indexInRange(n) ? this.parts[n][2] : "";
    }

    void setPartContentTypeAttr(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][2] = string != null ? string : "";
        this.buildHeaders(n);
    }

    String getPartContentDisposition(int n) {
        return this.indexInRange(n) ? this.parts[n][4] : "";
    }

    void setPartContentDisposition(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][4] = string != null ? string : "";
        this.buildHeaders(n);
    }

    String getPartContentDispositionAttr(int n) {
        return this.indexInRange(n) ? this.parts[n][5] : "";
    }

    void setPartContentDispositionAttr(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][5] = string != null ? string : "";
        this.buildHeaders(n);
    }

    private static int getIntEncoding(String string) {
        int n = 0;
        while (n < 5) {
            if (encoding[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    int getPartEncoding(int n) {
        return this.indexInRange(n) ? CMIME.getIntEncoding(this.parts[n][6]) : -1;
    }

    void setPartEncoding(int n, int n2) throws IPWorksException {
        this.checkIndex(n);
        if (n2 < 0 || n2 > 4) {
            n2 = 0;
        }
        this.parts[n][6] = encoding[n2];
        this.buildHeaders(n);
    }

    private void decode(int n, boolean bl) throws IPWorksException {
        block32: {
            IOException iOException5;
            block31: {
                InputStream inputStream = null;
                try {
                    switch (this.lastAction) {
                        case 1: {
                            try {
                                inputStream = new FileInputStream(new String(this.body[100]));
                                break;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                throw new IPWorksException(4);
                            }
                        }
                        case 2: {
                            inputStream = new ByteArrayInputStream(this.body[100]);
                        }
                    }
                    this.netcode.iStream = new FragmentedInputStream(inputStream, this.bodyOffset[n], this.bodyLength[n]);
                    if (bl) {
                        try {
                            this.netcode.oStream = new FileOutputStream("decoded" + n + ".tmp");
                        }
                        catch (IOException iOException2) {
                            throw new IPWorksException(3);
                        }
                    } else {
                        this.netcode.oStream = new ByteArrayOutputStream();
                    }
                    try {
                        switch (this.getPartEncoding(n)) {
                            case 1: {
                                this.netcode.qpDecode();
                                break;
                            }
                            case 2: {
                                this.netcode.b64Decode();
                                break;
                            }
                            default: {
                                int n2;
                                byte[] byArray = new byte[20000];
                                while ((n2 = this.netcode.iStream.read(byArray)) > 0) {
                                    this.netcode.oStream.write(byArray, 0, n2);
                                }
                                break;
                            }
                        }
                    }
                    catch (IOException iOException3) {
                        throw new IPWorksException(6);
                    }
                    if (bl) {
                        this.parts[n][9] = "decoded" + n + ".tmp";
                    } else {
                        this.body[n] = ((ByteArrayOutputStream)this.netcode.oStream).toByteArray();
                    }
                    Object var7_9 = null;
                    if (this.netcode.iStream == null) break block31;
                }
                catch (Throwable throwable) {
                    IOException iOException42;
                    Object var7_10 = null;
                    if (this.netcode.iStream != null) {
                        try {
                            this.netcode.iStream.close();
                        }
                        catch (IOException iOException42) {
                            // empty catch block
                        }
                    }
                    if (this.netcode.oStream != null) {
                        try {
                            this.netcode.oStream.close();
                        }
                        catch (IOException iOException42) {
                            // empty catch block
                        }
                    }
                    this.netcode.iStream = null;
                    this.netcode.oStream = null;
                    throw throwable;
                }
                try {
                    this.netcode.iStream.close();
                }
                catch (IOException iOException5) {
                    // empty catch block
                }
            }
            if (this.netcode.oStream != null) {
                try {
                    this.netcode.oStream.close();
                    break block32;
                }
                catch (IOException iOException5) {
                    // empty catch block
                }
                {
                }
            }
        }
        this.netcode.iStream = null;
        this.netcode.oStream = null;
    }

    String getPartDecodedFile(int n) throws IPWorksException {
        if (!this.indexInRange(n)) {
            return "";
        }
        String string = this.parts[n][9];
        if (string.length() > 0) {
            return string;
        }
        if (this.lastAction != 2 && this.lastAction != 1) {
            return "";
        }
        this.decode(n, true);
        return this.parts[n][9];
    }

    void setPartDecodedFile(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][9] = string != null ? string : "";
    }

    byte[] getPartDecodedString(int n) throws IPWorksException {
        if (!this.indexInRange(n)) {
            return BYTE0;
        }
        if (this.lastAction != 2 && this.lastAction != 1) {
            return this.body[n];
        }
        this.decode(n, false);
        return this.body[n];
    }

    void setPartDecodedString(int n, byte[] byArray) throws IPWorksException {
        this.checkIndex(n);
        this.body[n] = byArray != null ? byArray : BYTE0;
    }

    String getPartFilename(int n) {
        return this.indexInRange(n) ? this.parts[n][7] : "";
    }

    void setPartFilename(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][7] = string != null ? string : "";
        this.buildContentDispositionAttr(n);
        this.buildHeaders(n);
    }

    String getPartName(int n) {
        return this.indexInRange(n) ? this.parts[n][8] : "";
    }

    void setPartName(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][8] = string != null ? string : "";
        this.buildContentTypeAttr(n);
        this.buildHeaders(n);
    }

    String getPartHeaders(int n) {
        return this.indexInRange(n) ? this.parts[n][0] : "";
    }

    private static String toValidHeader(String string) {
        String string2 = string.endsWith(cr) ? string + lf + crlf : string + crlf + crlf;
        int n = string2.indexOf("\r\n\r\n");
        return string2.substring(0, n + 2);
    }

    void setPartHeaders(int n, String string) throws IPWorksException {
        this.checkIndex(n);
        this.parts[n][0] = string != null ? CMIME.toValidHeader(string) : "";
    }

    int getPartSize(int n) {
        if (!this.indexInRange(n)) {
            return 0;
        }
        if (this.lastAction == 1 || this.lastAction == 2) {
            switch (this.getPartEncoding(n)) {
                case 2: {
                    return (int)Math.floor(this.bodyLength[n] * 3L / 4L);
                }
            }
            return (int)this.bodyLength[n];
        }
        String string = this.parts[n][9];
        if (string.length() == 0) {
            return this.body[n].length;
        }
        try {
            return (int)new File(string).length();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    int getPartCount() {
        return this.partCount;
    }

    void setPartCount(int n) throws IPWorksException {
        if (n < 0 || n >= 100) {
            throw new IPWorksException(280);
        }
        this.partCount = n;
        if (n == 0 || this.partCount == 0) {
            this.buildHeaders(100);
        }
    }

    private boolean parseHeaderName() throws IPWorksException {
        if (this.currentPoz == this.currentHeader.length()) {
            return false;
        }
        int n = this.currentHeader.indexOf(58, this.currentPoz);
        if (n == -1) {
            return false;
        }
        this.currentHeaderName = this.currentHeader.substring(this.currentPoz, n);
        this.currentPoz = n + 1;
        return true;
    }

    private void parseHeaderValue() throws IPWorksException {
        int n;
        int n2 = this.currentHeader.length();
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c;
            n = this.currentHeader.indexOf(crlf, this.currentPoz);
            stringBuffer.append(this.currentHeader.substring(this.currentPoz, n));
            if (n + 2 == n2 || (c = this.currentHeader.charAt(n + 2)) != ' ' && c != '\t') break;
            this.currentPoz = n + 3;
            stringBuffer.append(' ');
        }
        this.currentPoz = n + 2;
        this.currentHeaderValue = stringBuffer.toString().trim();
    }

    private static String parse(String string, String string2) throws IPWorksException {
        int n = string.indexOf(string2);
        if (n == -1) {
            return null;
        }
        try {
            n += string2.length();
            while (string.charAt(n) == ' ' || string.charAt(n) == '\t') {
                ++n;
            }
            if (string.charAt(n) == '\"') {
                int n2 = n + 1;
                while ((n2 = string.indexOf(34, n2)) != -1) {
                    if (string.charAt(n2 - 1) == '\\') continue;
                    return string.substring(n + 1, n2);
                }
                throw new IPWorksException(289);
            }
            int n3 = n;
            while (n3 < string.length()) {
                char c = string.charAt(n3);
                if (c == ';' || c == ' ' || c == '\t') {
                    return string.substring(n, n3);
                }
                if (c == '\\') {
                    ++n3;
                }
                ++n3;
            }
            return string.substring(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IPWorksException(289);
        }
    }

    private void parseContentTypeAttr(int n) throws IPWorksException {
        String string = this.parts[n][2];
        if (n == 100) {
            String string2 = CMIME.parse(string, "boundary=");
            if (string2 != null) {
                this.boundary = string2;
            }
        } else {
            String string3 = CMIME.parse(string, "name=");
            if (string3 != null) {
                this.parts[n][8] = string3;
            }
        }
    }

    private void parseContentType(int n) throws IPWorksException {
        String string;
        int n2 = this.currentHeaderValue.indexOf(59);
        if (n2 == -1) {
            this.parts[n][1] = this.currentHeaderValue;
            return;
        }
        this.parts[n][1] = this.currentHeaderValue.substring(0, n2);
        this.parts[n][2] = string = this.currentHeaderValue.substring(n2 + 1).trim();
        this.parseContentTypeAttr(n);
    }

    private void parseContentDispositionAttr(int n) throws IPWorksException {
        String string = this.parts[n][5];
        if (n != 100) {
            String string2 = CMIME.parse(string, "name=");
            if (string2 != null) {
                this.parts[n][8] = string2;
            }
            if ((string2 = CMIME.parse(string, "filename=")) != null) {
                this.parts[n][7] = string2;
            }
        }
    }

    private void parseContentDisposition(int n) throws IPWorksException {
        String string;
        int n2 = this.currentHeaderValue.indexOf(59);
        if (n2 == -1) {
            this.parts[n][1] = this.currentHeaderValue;
            return;
        }
        this.parts[n][4] = this.currentHeaderValue.substring(0, n2);
        this.parts[n][5] = string = this.currentHeaderValue.substring(n2 + 1).trim();
        this.parseContentDispositionAttr(n);
    }

    void parseHeaders(int n) throws IPWorksException {
        if (this.currentHeader.length() == 0) {
            this.parts[n][0] = "text/plain;\r\n\tcharset=\"iso-8859-1\"\r\n";
            this.parts[n][1] = "text/plain";
            this.parts[n][2] = "charset=\"iso-8859-1\"";
            return;
        }
        this.currentPoz = 0;
        this.parts[n][0] = this.currentHeader;
        while (this.parseHeaderName()) {
            this.parseHeaderValue();
            if (this.currentHeaderName.equalsIgnoreCase("MIME-Version")) {
                if (n != 100 || this.currentHeaderValue.startsWith("1.0")) continue;
                throw new IPWorksException(281);
            }
            if (this.currentHeaderName.equalsIgnoreCase("Content-Id")) {
                this.parts[n][3] = this.currentHeaderValue;
                continue;
            }
            if (this.currentHeaderName.equalsIgnoreCase("Content-Type")) {
                this.parseContentType(n);
                continue;
            }
            if (this.currentHeaderName.equalsIgnoreCase("Content-Disposition")) {
                this.parseContentDisposition(n);
                continue;
            }
            if (!this.currentHeaderName.equalsIgnoreCase("Content-Transfer-Encoding")) continue;
            this.parts[n][6] = this.currentHeaderValue;
        }
    }

    void parseMessage(InputStream inputStream, long l) throws IPWorksException {
        ProgressInputStream progressInputStream = new ProgressInputStream(inputStream, l, 0, 100, this, this.syncObj);
        DelimitedInputStream delimitedInputStream = new DelimitedInputStream(progressInputStream, "\r\n\r\n");
        if (this.currentHeader.length() == 0) {
            this.currentHeader = delimitedInputStream.readString() + crlf;
        }
        this.parts[100][0] = this.currentHeader;
        this.parseHeaders(100);
        this.bodyOffset[100] = delimitedInputStream.getCurrentPozition();
        if (this.boundary.length() == 0) {
            this.partCount = 0;
            this.bodyLength[100] = -1L;
        } else {
            delimitedInputStream.setDelimiter("--" + this.boundary);
            delimitedInputStream.readString();
            this.bodyLength[100] = delimitedInputStream.getCurrentPozition() - this.bodyOffset[100] - (long)(this.boundary.length() + 2);
            String string = "--" + this.boundary;
            int n = string.length() + 2;
            this.partCount = 0;
            while (this.partCount < 100) {
                delimitedInputStream.setDelimiter("\r\n\r\n");
                String string2 = delimitedInputStream.readString();
                if (string2.startsWith("--")) break;
                this.currentHeader = string2.substring(2) + crlf;
                this.parseHeaders(this.partCount);
                this.bodyOffset[this.partCount] = delimitedInputStream.getCurrentPozition();
                delimitedInputStream.setDelimiter(string);
                if (!delimitedInputStream.skipToNext()) {
                    throw new IPWorksException(282);
                }
                this.bodyLength[this.partCount] = delimitedInputStream.getCurrentPozition() - this.bodyOffset[this.partCount] - (long)n;
                ++this.partCount;
            }
        }
    }

    void setBoundaryIfEmpty() {
        if (this.boundary.length() == 0) {
            if (this.randomizer == null) {
                this.randomizer = new Random();
            }
            byte[] byArray = new byte[30];
            this.randomizer.nextBytes(byArray);
            this.netcode.setDecodedData(byArray);
            this.netcode.setFormat(1);
            try {
                this.netcode.setAction(4);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            this.boundary = "----=_Next_Part_" + new String(this.netcode.getEncodedData());
        }
    }

    void buildContentTypeAttr(int n) throws IPWorksException {
        String string = this.parts[n][8];
        this.parts[n][2] = string.length() > 0 ? "name=" + string : "";
    }

    void buildContentDispositionAttr(int n) throws IPWorksException {
        String string = this.parts[n][8];
        String string2 = this.parts[n][7];
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() > 0) {
            stringBuffer.append("name=" + string);
        }
        if (string2.length() > 0) {
            stringBuffer.append("; filename=" + string2);
        }
        this.parts[n][5] = stringBuffer.toString();
    }

    void buildHeaders(int n) throws IPWorksException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 100) {
            stringBuffer.append("MIME-Version: 1.0 (produced by IP*Works! www.dev-soft.com)\r\n");
        }
        if ((string = this.parts[n][3]).length() > 0) {
            stringBuffer.append("Content-Id: ").append(string).append(crlf);
        }
        stringBuffer.append("Content-Type: ");
        string = this.parts[n][1];
        if (string.length() > 0) {
            stringBuffer.append(string);
        } else if (n == 100 && this.partCount > 0) {
            stringBuffer.append("multipart/mixed");
        } else {
            stringBuffer.append("text/plain");
        }
        stringBuffer.append(";\t");
        string = this.parts[n][2];
        if (string.length() > 0) {
            stringBuffer.append(string);
        } else if (n == 100 && this.partCount > 0) {
            this.setBoundaryIfEmpty();
            stringBuffer.append("boundary=" + this.boundary);
        } else {
            stringBuffer.append("charset=\"iso-8859-1\"");
        }
        stringBuffer.append(crlf);
        string = this.parts[n][4];
        if (string.length() > 0) {
            stringBuffer.append("Content-Disposition: " + string);
            string = this.parts[n][5];
            if (string.length() > 0) {
                stringBuffer.append("; " + string);
            }
            stringBuffer.append(crlf);
        }
        if ((string = this.parts[n][6]).length() > 0) {
            stringBuffer.append("Content-Transfer-Encoding: " + string + crlf);
        }
        this.parts[n][0] = stringBuffer.toString();
    }

    private void encode(OutputStream outputStream, int n) throws IPWorksException {
        block18: {
            this.netcode.oStream = outputStream;
            try {
                InputStream inputStream;
                if (this.parts[n][9].length() > 0) {
                    try {
                        inputStream = new FileInputStream(this.parts[n][9]);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new IPWorksException(4);
                    }
                } else {
                    inputStream = new ByteArrayInputStream(this.body[n]);
                }
                int n2 = this.getPartSize(n);
                int n3 = (int)((long)(n2 * 100) / this.totalSize);
                this.netcode.iStream = new ProgressInputStream(inputStream, n2, this.pozPercent, this.pozPercent + n3, this, this.syncObj);
                this.pozPercent += n3;
                try {
                    switch (this.getPartEncoding(n)) {
                        case 1: {
                            this.netcode.qpEncode();
                            break;
                        }
                        case 2: {
                            this.netcode.b64Encode();
                            break;
                        }
                        default: {
                            int n4;
                            byte[] byArray = new byte[20000];
                            while ((n4 = this.netcode.iStream.read(byArray)) > 0) {
                                this.netcode.oStream.write(byArray, 0, n4);
                            }
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new IPWorksException(6);
                }
                Object var9_10 = null;
                if (this.netcode.iStream == null) break block18;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (this.netcode.iStream != null) {
                    try {
                        this.netcode.iStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.netcode.iStream = null;
                this.netcode.oStream = null;
                throw throwable;
            }
            try {
                this.netcode.iStream.close();
                break block18;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
            }
        }
        this.netcode.iStream = null;
        this.netcode.oStream = null;
    }

    void buildMessage(OutputStream outputStream) throws IPWorksException {
        this.buildHeaders(100);
        try {
            if (this.partCount > 0) {
                byte[] byArray = ("\r\n--" + this.boundary).getBytes();
                outputStream.write(byArray);
                this.pozPercent = 0;
                this.totalSize = 0L;
                int n = 0;
                while (n < this.partCount) {
                    this.totalSize += (long)this.getPartSize(n);
                    ++n;
                }
                int n2 = 0;
                while (n2 < this.partCount) {
                    outputStream.write(crlfEol);
                    outputStream.write(this.parts[n2][0].getBytes());
                    outputStream.write(crlfEol);
                    this.encode(outputStream, n2);
                    outputStream.write(byArray);
                    ++n2;
                }
                outputStream.write("--\r\n".getBytes());
            }
        }
        catch (IOException iOException) {
            throw new IPWorksException(6);
        }
    }

    void setAction(int n) throws IPWorksException {
        this.setMIMEAction(n);
    }

    /*
     * Loose catch block
     */
    private void setMIMEAction(int n) throws IPWorksException {
        OutputStream outputStream;
        InputStream inputStream;
        block22: {
            IOException iOException2222;
            block21: {
                if (this.action != 0) {
                    throw new IPWorksException(284);
                }
                inputStream = null;
                outputStream = null;
                this.action = n;
                switch (n) {
                    case 1: {
                        this.currentMessageByte = this.body[100];
                        this.currentHeader = this.parts[100][0];
                        String string = new String(this.currentMessageByte);
                        inputStream = new FileInputStream(string);
                        this.resetAllHeaders();
                        this.body[100] = this.currentMessageByte;
                        this.parseMessage(inputStream, new File(string).length());
                        break;
                    }
                    case 2: {
                        this.currentMessageByte = this.body[100];
                        this.currentHeader = this.parts[100][0];
                        inputStream = new ByteArrayInputStream(this.body[100]);
                        this.resetAllHeaders();
                        this.body[100] = this.currentMessageByte;
                        this.parseMessage(inputStream, this.currentMessageByte.length);
                        break;
                    }
                    case 3: {
                        outputStream = new FileOutputStream(new String(this.body[100]));
                        this.buildMessage(outputStream);
                        break;
                    }
                    case 4: {
                        outputStream = new ByteArrayOutputStream();
                        this.buildMessage(outputStream);
                        this.body[100] = ((ByteArrayOutputStream)outputStream).toByteArray();
                        break;
                    }
                    case 5: {
                        this.resetAllHeaders();
                    }
                }
                Object var6_6 = null;
                if (inputStream == null) break block21;
                try {
                    inputStream.close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                    break block22;
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
                {
                }
            }
            break block22;
            {
                catch (IOException iOException3) {
                    throw new IPWorksException(4);
                }
            }
            catch (Throwable throwable) {
                IOException iOException42222;
                Object var6_7 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                }
                inputStream = null;
                outputStream = null;
                this.lastAction = n;
                this.action = 0;
                throw throwable;
            }
        }
        inputStream = null;
        outputStream = null;
        this.lastAction = n;
        this.action = 0;
    }

    void fireProgress(int n) {
        if (this.sink != null) {
            this.sink.fireProgress(n);
        }
    }
}

