/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CUDPPort;
import ipworks.IPWorksException;
import ipworks.Tftp;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

class CTFTP
extends CUDPPort {
    private static final int TFTP_PORT = 69;
    private static final boolean WAIT_FOR_ANSWER = true;
    private static final int IDLE = 0;
    private static final int GET_FILE = 1;
    private static final int PUT_FILE = 2;
    private static final int HeaderPacketLength = 4;
    private static final int DataPacketLength = 512;
    private static final int PacketLength = 516;
    private static final byte PT_READ_REQUEST = 1;
    private static final byte PT_WRITE_REQUEST = 2;
    private static final byte PT_DATA = 3;
    private static final byte PT_ACK = 4;
    private static final byte PT_ERROR = 5;
    private int action = 0;
    private byte[] receivedPacket = new byte[516];
    private byte[] sendingPacket = new byte[516];
    private int sendingBytes;
    private int receivedBytes;
    private int clientTID;
    private Tftp sink;
    private String localFile = "";
    private String remoteFile = "";
    private String tftpServer = "";
    private int maxRetransmits = 3;
    private int tftpPort = 69;
    private long timestart;
    private int retransmitTimeout = 5;
    private boolean packetIsReceived;
    private int responseType = 0;
    private int blockNumber;

    CTFTP(Tftp tftp, Object object) throws IPWorksException {
        super(null, object);
        this.sink = tftp;
    }

    void do_GetFile() throws IPWorksException {
        this.setAction(1);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_PutFile() throws IPWorksException {
        this.setAction(2);
    }

    void setLocalFile(String string) {
        this.localFile = string != null ? string : "";
    }

    String getLocalFile() {
        return this.localFile;
    }

    void setRemoteFile(String string) {
        this.remoteFile = string != null ? string : "";
    }

    String getRemoteFile() {
        return this.remoteFile;
    }

    void setTFTPServer(String string) throws IPWorksException {
        this.setRemoteHost(string);
        try {
            this.tftpServer = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.tftpServer = string;
        }
    }

    String getTFTPServer() {
        return this.getRemoteHost();
    }

    void setMaxRetransmits(int n) {
        this.maxRetransmits = n > 0 ? n : 0;
    }

    int getMaxRetransmits() {
        return this.maxRetransmits;
    }

    void setRetransmitTimeout(int n) {
        this.retransmitTimeout = n;
    }

    int getRetransmitTimeout() {
        return this.retransmitTimeout;
    }

    void setTFTPPort(int n) {
        this.tftpPort = n;
    }

    int getTFTPPort() {
        return this.tftpPort;
    }

    void interrupt() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null) {
                this.pendingException = new IPWorksException(301);
            }
            try {
                this.setActive(false);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            this.syncObj.notifyAll();
        }
    }

    void restart() {
        Object object = this.syncObj;
        synchronized (object) {
            this.timestart = this.timeout == 0 ? 0L : System.currentTimeMillis();
            this.pendingException = null;
        }
    }

    void setAction(int n) throws IPWorksException {
        this.setTFTPAction(n);
    }

    /*
     * Unable to fully structure code
     */
    private void setTFTPAction(int var1_1) throws IPWorksException {
        block47: {
            if (var1_1 == 0) {
                this.interrupt();
                return;
            }
            var2_2 = this.syncObj;
            synchronized (var2_2) {
                if (this.action != 0) {
                    throw new IPWorksException(130);
                }
                this.restart();
                this.action = var1_1;
            }
            if (var1_1 != 0) {
                this.setLocalPort(0);
                this.setRemotePort(this.tftpPort);
                this.setActive(true);
            }
            var3_4 = null;
            var4_5 = null;
            try {
                switch (var1_1) {
                    case 1: {
                        this.clientTID = 0;
                        if (this.localFile.length() > 0) {
                            try {
                                var3_4 = new FileOutputStream(this.localFile);
                            }
                            catch (IOException var5_6) {
                                throw new IPWorksException(8127);
                            }
                        }
                        this.blockNumber = 1;
                        this.sendRequest((byte)1);
                        if (this.responseType != 3) {
                            throw new IPWorksException(123);
                        }
                        this.fireStartTransfer();
                        do {
                            if (this.timestart + (long)(this.timeout * 1000) - System.currentTimeMillis() <= 0L) {
                                throw new IPWorksException(201);
                            }
                            var6_8 = this.receivedBytes - 4;
                            if (var3_4 != null) {
                                try {
                                    var3_4.write(this.receivedPacket, 4, var6_8);
                                    var5_7 = CBase.BYTE0;
                                }
                                catch (IOException var7_11) {
                                    throw new IPWorksException(128);
                                }
                            } else {
                                var5_7 = new byte[var6_8];
                                System.arraycopy(this.receivedPacket, 4, var5_7, 0, var5_7.length);
                            }
                            this.fireTransfer((this.blockNumber - 1) * 512 + var6_8, var5_7);
                            if (var6_8 < 512) ** GOTO lbl53
                            this.sendACK(true);
                        } while (this.responseType == 3);
                        throw new IPWorksException(123);
lbl53:
                        // 1 sources

                        this.sendACK(false);
                        this.fireEndTransfer();
                        break;
                    }
                    case 2: {
                        if (this.localFile.length() == 0) {
                            throw new IPWorksException(126);
                        }
                        this.clientTID = 0;
                        try {
                            var4_5 = new FileInputStream(this.localFile);
                        }
                        catch (IOException var6_9) {
                            throw new IPWorksException(8127);
                        }
                        this.blockNumber = 0;
                        this.sendRequest((byte)2);
                        if (this.responseType != 4 || this.receivedPacket[2] * 256 + this.receivedPacket[3] != 0) {
                            throw new IPWorksException(125);
                        }
                        this.fireStartTransfer();
                        this.sendingPacket[0] = 0;
                        this.sendingPacket[1] = 3;
                        this.blockNumber = 1;
                        while (true) {
                            if (this.timestart + (long)(this.timeout * 1000) - System.currentTimeMillis() <= 0L) {
                                throw new IPWorksException(201);
                            }
                            this.sendingPacket[2] = (byte)(this.blockNumber / 256);
                            this.sendingPacket[3] = (byte)(this.blockNumber % 256);
                            try {
                                var6_10 = var4_5.read(this.sendingPacket, 4, 512);
                            }
                            catch (IOException var7_12) {
                                throw new IPWorksException(129);
                            }
                            if (var6_10 == -1) break;
                            this.sendingBytes = 4 + var6_10;
                            this.sendPacket(true);
                            if (this.responseType != 4) {
                                throw new IPWorksException(125);
                            }
                            this.fireTransfer((this.blockNumber - 1) * 512 + var6_10, CBase.BYTE0);
                            ++this.blockNumber;
                        }
                        this.fireEndTransfer();
                    }
                }
                var9_13 = null;
                if (var3_4 == null) break block47;
            }
            catch (Throwable var8_21) {
                var9_14 = null;
                if (var3_4 != null) {
                    try {
                        var3_4.close();
                    }
                    catch (IOException var10_17) {
                        throw new IPWorksException(128);
                    }
                }
                if (var4_5 != null) {
                    try {
                        var4_5.close();
                    }
                    catch (IOException var10_18) {
                        // empty catch block
                    }
                }
                this.setActive(false);
                var10_18 = this.syncObj;
                synchronized (var10_18) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        throw this.pendingException;
                    }
                }
                throw var8_21;
            }
            try {
                var3_4.close();
            }
            catch (IOException var10_15) {
                throw new IPWorksException(128);
            }
        }
        if (var4_5 != null) {
            try {
                var4_5.close();
            }
            catch (IOException var10_16) {
                // empty catch block
            }
        }
        this.setActive(false);
        var10_16 = this.syncObj;
        synchronized (var10_16) {
            this.action = 0;
            if (this.pendingException != null) {
                throw this.pendingException;
            }
        }
    }

    int getAction() {
        return this.action;
    }

    void sendRequest(byte by) throws IPWorksException {
        this.sendingBytes = 0;
        this.sendingPacket[this.sendingBytes++] = 0;
        this.sendingPacket[this.sendingBytes++] = by;
        System.arraycopy(this.remoteFile.getBytes(), 0, this.sendingPacket, this.sendingBytes, this.remoteFile.length());
        this.sendingBytes += this.remoteFile.length();
        this.sendingPacket[this.sendingBytes++] = 0;
        byte[] byArray = "octet".getBytes();
        System.arraycopy(byArray, 0, this.sendingPacket, this.sendingBytes, byArray.length);
        this.sendingBytes += byArray.length;
        this.sendingPacket[this.sendingBytes++] = 0;
        this.sendPacket(true);
        if (this.responseType == 5) {
            int n = ((this.receivedPacket[2] & 0xFF) << 8) + (this.receivedPacket[3] & 0xFF);
            throw new IPWorksException(124, "Code: [" + n + "] " + new String(this.receivedPacket, 4, this.receivedBytes - 4) + ".");
        }
    }

    void sendACK(boolean bl) throws IPWorksException {
        this.sendingBytes = 0;
        this.sendingPacket[this.sendingBytes++] = 0;
        this.sendingPacket[this.sendingBytes++] = 4;
        this.sendingPacket[this.sendingBytes++] = (byte)(this.blockNumber / 256);
        this.sendingPacket[this.sendingBytes++] = (byte)(this.blockNumber % 256);
        ++this.blockNumber;
        this.sendPacket(bl);
        if (!bl) {
            return;
        }
        if (this.responseType == 5) {
            int n = ((this.receivedPacket[2] & 0xFF) << 8) + (this.receivedPacket[3] & 0xFF);
            throw new IPWorksException(124, "Code: [" + n + "] " + new String(this.receivedPacket, 4, this.receivedBytes - 4) + ".");
        }
    }

    void sendPacket(boolean bl) throws IPWorksException {
        try {
            int n = this.maxRetransmits;
            this.packetIsReceived = false;
            this.setDataToSend(this.sendingPacket, 0, this.sendingBytes);
            this.setAcceptData(true);
            if (!bl) {
                Object var8_3 = null;
                this.setAcceptData(false);
                return;
            }
            long l = System.currentTimeMillis() + (long)(this.retransmitTimeout * 1000);
            while (!this.packetIsReceived && n > 0) {
                if (this.pendingException != null) {
                    throw this.pendingException;
                }
                Object object = this.syncObj;
                synchronized (object) {
                    this.waitWhileProcessingEvents1(this.retransmitTimeout * 1000);
                }
                if (System.currentTimeMillis() < l) continue;
                this.setDataToSend(this.sendingPacket, 0, this.sendingBytes);
                l = System.currentTimeMillis() + (long)(this.retransmitTimeout * 1000);
                --n;
            }
            if (!this.packetIsReceived) {
                throw new IPWorksException(201);
            }
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.setAcceptData(false);
            throw throwable;
        }
        Object var8_4 = null;
        this.setAcceptData(false);
    }

    void fireDataIn(byte[] byArray, String string, int n) {
        if (!string.equals(this.tftpServer)) {
            return;
        }
        if (byArray.length > 516) {
            this.fireError(new IPWorksException(122, "Packet too large."));
            return;
        }
        if (this.clientTID != n) {
            if (this.clientTID != 0) {
                return;
            }
            this.clientTID = n;
            try {
                this.setRemotePort(this.clientTID);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
        }
        this.receivedBytes = byArray.length;
        System.arraycopy(byArray, 0, this.receivedPacket, 0, this.receivedBytes);
        this.responseType = ((this.receivedPacket[0] & 0xFF) << 8) + (this.receivedPacket[1] & 0xFF);
        boolean bl = this.packetIsReceived = this.blockNumber == ((this.receivedPacket[2] & 0xFF) << 8) + (this.receivedPacket[3] & 0xFF);
        if (this.packetIsReceived) {
            this.setAcceptData(false);
            this.syncObj.notifyAll();
        }
    }

    void fireStartTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireStartTransfer();
            }
        }
    }

    void fireTransfer(int n, byte[] byArray) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireTransfer(n, byArray);
            }
        }
    }

    void fireEndTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireEndTransfer();
            }
        }
    }

    void fireError(IPWorksException iPWorksException) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
            }
        }
    }
}

