/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CIPPMsg;
import ipworks.IPWorksException;
import ipworks.Whois;

class CWhois
extends CIPPMsg {
    private static final int PORT = 43;
    private static final int IDLE = 0;
    private static final int BUSY = 1;
    private int action = 0;
    private String server = "";
    private String domain = "";
    private String defaultServer = "whois.internic.net";
    private StringBuffer domainInfo = new StringBuffer();
    Whois sink;

    CWhois(Whois whois, Object object) {
        super(null, object);
        this.sink = whois;
        try {
            this.setRemotePort(43);
            this.setEOL(CBase.LFB);
            this.setTimeout(60000);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
    }

    void do_Query(String string) throws IPWorksException {
        this.setDomain(string);
    }

    String getDomain() {
        return this.domain;
    }

    void setDomain(String string) throws IPWorksException {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            this.interrupt();
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.action != 0) {
                throw new IPWorksException(531);
            }
            this.restart();
            this.action = 1;
            this.domain = string;
        }
        try {
            if (this.server.length() == 0) {
                this.setRemoteHost(this.defaultServer);
                this.setConnected(true);
                this.setDataToSend(("domain " + string).getBytes());
                this.setDataToSend(CBase.CRLFB);
                while (this.server.length() == 0) {
                    this.waitForReply();
                    int n = this.lastReply.toLowerCase().indexOf("whois server:");
                    int n2 = 0;
                    if (n == -1) continue;
                    try {
                        n += "whois server:".length();
                        while (this.lastReply.charAt(n) == ' ' || this.lastReply.charAt(n) == '\t') {
                            ++n;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    try {
                        n2 = n;
                        while (this.lastReply.charAt(n2) != ' ' && this.lastReply.charAt(n2) != '\t') {
                            ++n2;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    this.server = this.lastReply.substring(n, n2);
                }
                Object object2 = this.syncObj;
                synchronized (object2) {
                    this.setConnected(false, 0L);
                }
            }
            this.domainInfo.setLength(0);
            this.setRemoteHost(this.server);
            this.setConnected(true);
            this.setDataToSend(string.getBytes());
            this.setDataToSend(CBase.CRLFB);
            try {
                while (true) {
                    this.waitForReply();
                    this.domainInfo.append(this.lastReply).append("\r\n");
                }
            }
            catch (IPWorksException iPWorksException) {
                if (iPWorksException.getCode() != 32000) {
                    throw iPWorksException;
                }
                Object var8_12 = null;
                Object object3 = this.syncObj;
                synchronized (object3) {
                    this.action = 0;
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException2) {
                        // empty catch block
                    }
                }
                if (this.server.length() == 0) {
                    throw new IPWorksException(125);
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            Object object4 = this.syncObj;
            synchronized (object4) {
                this.action = 0;
                try {
                    this.setConnected(false, 0L);
                }
                catch (IPWorksException iPWorksException) {
                    // empty catch block
                }
            }
            if (this.server.length() == 0) {
                throw new IPWorksException(125);
            }
            throw throwable;
        }
    }

    String getDomainInfo() {
        return this.domainInfo.toString();
    }

    String getServer() {
        return this.server;
    }

    void setServer(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.action != 0) {
                throw new IPWorksException(531);
            }
            this.server = string != null ? string : "";
        }
    }

    String getDefaultServer() {
        return this.defaultServer;
    }

    void setDefaultServer(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.action != 0) {
                throw new IPWorksException(531);
            }
            this.defaultServer = string != null ? string : "";
        }
    }
}

