/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.IPWorksException;
import java.io.IOException;
import java.io.InputStream;

class DelimitedInputStream
extends InputStream {
    private InputStream iStream;
    private boolean canRead = true;
    private String delimiter;
    private static final int DEFAULT_BUF_SIZE = 20000;
    private int bufSize = 20000;
    private int totalBytesRead = 0;
    private int currentPoz = 0;
    private int delimPoz = 20001;
    private int suspectedPoz = 0;
    private int lastPoz = 0;
    private byte[] buf = new byte[20000];
    IOException ioe = null;

    DelimitedInputStream(InputStream inputStream, String string) {
        this.iStream = inputStream;
        this.delimiter = string;
    }

    private void findDelimiter() {
        this.suspectedPoz = this.lastPoz - this.delimiter.length() + 1;
        String string = new String(this.buf, this.currentPoz, this.lastPoz - this.currentPoz);
        int n = string.indexOf(this.delimiter);
        this.delimPoz = n != -1 ? this.currentPoz + n : this.lastPoz + 1;
    }

    void setDelimiter(String string) {
        this.delimiter = string;
        if (this.currentPoz + string.length() > this.lastPoz) {
            this.refill();
        }
        this.findDelimiter();
    }

    private void refill() {
        int n = this.lastPoz - this.currentPoz;
        System.arraycopy(this.buf, this.currentPoz, this.buf, 0, n);
        this.currentPoz = 0;
        try {
            int n2 = this.iStream.read(this.buf, n, this.bufSize - n);
            this.canRead = n2 != -1;
            if (!this.canRead) {
                n2 = 0;
            }
            this.lastPoz = n + n2;
            this.totalBytesRead += n2;
        }
        catch (IOException iOException) {
            this.ioe = iOException;
        }
    }

    private void resize(int n) {
        int n2 = this.lastPoz - this.currentPoz;
        byte[] byArray = this.buf;
        this.bufSize = n;
        this.buf = new byte[this.bufSize];
        System.arraycopy(byArray, this.currentPoz, this.buf, 0, n2);
        this.currentPoz = 0;
        try {
            int n3 = this.iStream.read(this.buf, n2, n - n2);
            this.canRead = n3 != -1;
            if (!this.canRead) {
                n3 = 0;
            }
            this.lastPoz = n2 + n3;
            this.totalBytesRead += n3;
        }
        catch (IOException iOException) {
            this.ioe = iOException;
        }
    }

    public int read() throws IOException {
        if (this.ioe != null) {
            throw this.ioe;
        }
        if (!this.canRead) {
            return this.currentPoz < this.lastPoz ? this.buf[this.currentPoz++] : -1;
        }
        if (this.currentPoz == this.delimPoz) {
            this.currentPoz += this.delimiter.length();
            this.findDelimiter();
            return -2;
        }
        if (this.currentPoz == this.suspectedPoz) {
            this.refill();
            this.findDelimiter();
            return this.read();
        }
        return this.buf[this.currentPoz++];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.ioe != null) {
            throw this.ioe;
        }
        if (!this.canRead) {
            int n3;
            int n4 = n3 = n2 < this.lastPoz - this.currentPoz ? n2 : this.lastPoz - this.currentPoz;
            if (n3 == 0) {
                return -1;
            }
            System.arraycopy(this.buf, this.currentPoz, byArray, n, n3);
            this.currentPoz += n3;
            return n3;
        }
        if (this.currentPoz == this.delimPoz) {
            this.currentPoz += this.delimiter.length();
            this.findDelimiter();
            return -2;
        }
        if (this.currentPoz + n2 >= this.delimPoz && this.delimPoz < this.lastPoz) {
            int n5 = this.delimPoz - this.currentPoz;
            System.arraycopy(this.buf, this.currentPoz, byArray, n, n5);
            this.currentPoz = this.delimPoz;
            return n5;
        }
        if (this.currentPoz + n2 > this.lastPoz) {
            this.resize(n2 + this.delimiter.length());
            this.findDelimiter();
            return this.read(byArray, n, n2);
        }
        if (this.currentPoz + n2 > this.suspectedPoz) {
            this.refill();
            this.findDelimiter();
            return this.read(byArray, n, n2);
        }
        System.arraycopy(this.buf, this.currentPoz, byArray, n, n2);
        this.currentPoz += n2;
        return n2;
    }

    String readString() throws IPWorksException {
        byte[] byArray = new byte[20000];
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            while ((n = this.read(byArray)) >= 0) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new IPWorksException(iOException);
        }
    }

    long getCurrentPozition() {
        return this.totalBytesRead - (this.lastPoz - this.currentPoz);
    }

    boolean skipToNext() throws IPWorksException {
        int n;
        byte[] byArray = new byte[20000];
        try {
            while ((n = this.read(byArray)) >= 0) {
            }
        }
        catch (IOException iOException) {
            throw new IPWorksException(5);
        }
        return n == -2;
    }

    public void close() throws IOException {
        this.iStream.close();
    }
}

