/*
 * Decompiled with CFR 0.152.
 */
package com.borland.install;

import com.borland.install.DesktopIcon;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class KDEIcon
extends DesktopIcon {
    private String path;
    private String terminalOptions;
    private static final String kdeSuffix = ".kdelnk";

    public KDEIcon() {
        this.setType("Application");
        this.setPath("");
        this.setNeedsTerminal(false);
        this.setTerminalOptions("");
        this.setIcon("exec.xpm");
    }

    public void setFileName(String fileName) {
        this.fileName = !fileName.endsWith(kdeSuffix) ? String.valueOf(fileName).concat(kdeSuffix) : fileName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTerminalOptions(String terminalOpt) {
        this.terminalOptions = terminalOpt;
    }

    public String getTerminalOptions() {
        return this.terminalOptions;
    }

    public void write() {
        String dirName = String.valueOf(new StringBuffer(String.valueOf(System.getProperties().getProperty("user.home"))).append(File.separator).append("Desktop"));
        this.write(new File(dirName));
    }

    public void write(File iconDir) {
        try {
            String fileName = String.valueOf(new StringBuffer(String.valueOf(iconDir.toString())).append(File.separator).append(this.getFileName()));
            File iconFile = new File(fileName);
            if (iconFile.exists()) {
                iconFile.delete();
            }
            PrintWriter iconData = new PrintWriter(new FileWriter(iconFile));
            iconData.println("# KDE Config File");
            iconData.println("[KDE Desktop Entry]");
            iconData.println("Name=".concat(String.valueOf(this.getName())));
            iconData.println("Icon=".concat(String.valueOf(this.getIcon())));
            iconData.println("Comment[]=");
            iconData.println("MimeType=");
            iconData.println("Exec=".concat(String.valueOf(this.getExec())));
            iconData.println("Type=".concat(String.valueOf(this.getType())));
            iconData.println("Path=".concat(String.valueOf(this.getPath())));
            iconData.println("SwallowTitle=");
            iconData.println("SwallowExec=");
            iconData.println("BinaryPattern=");
            iconData.println("Terminal=".concat(String.valueOf(this.getNeedsTerminal() ? "1" : "0")));
            iconData.println("TerminalOptions=".concat(String.valueOf(this.getTerminalOptions())));
            iconData.close();
            Process kfmClient = Runtime.getRuntime().exec("kfmclient refreshDesktop");
            kfmClient.waitFor();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ioe) {
            ioe.printStackTrace();
        }
    }
}

