/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.debugger;

import com.borland.jbuilder.debugger.BreakpointDialog;
import com.borland.jbuilder.debugger.BreakpointTree;
import com.borland.jbuilder.debugger.BreakpointTreeModel;
import com.borland.jbuilder.debugger.BreakpointTreeNode;
import com.borland.jbuilder.debugger.DebugJavaProcessTracker;
import com.borland.jbuilder.debugger.DebugPropertyGroup;
import com.borland.jbuilder.debugger.DebugPropertyGroupOld;
import com.borland.jbuilder.debugger.DebuggerCustomMouseActionProvider;
import com.borland.jbuilder.debugger.DebuggerToolTipProvider;
import com.borland.jbuilder.debugger.EvaluateModifyDialog;
import com.borland.jbuilder.debugger.ModelessDialogListener;
import com.borland.jbuilder.debugger.NoTracingClassTreeNode;
import com.borland.jbuilder.debugger.NoTracingClassesTree;
import com.borland.jbuilder.debugger.NoTracingClassesTreeModel;
import com.borland.jbuilder.debugger.TracingDisabledDialog;
import com.borland.jbuilder.debugger.WatchTreeModel;
import com.borland.jbuilder.debugger.n;
import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.node.JBDebuggable;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.runtime.RuntimeActionPool;
import com.borland.primetime.PrimeTime;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.properties.MapProperty;
import com.borland.primetime.runtime.RunConfiguration;
import com.borland.primetime.runtime.RunPropertyGroup;
import com.borland.primetime.viewer.TextView;
import com.sun.jdi.VirtualMachine;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class DebugInfoManager
implements ModelessDialogListener {
    private static boolean f;
    public static final MapProperty PAUSE_AFTER_LAUNCH;
    private static int c;
    private boolean i = false;
    private EvaluateModifyDialog e = null;
    private ArrayList d = new ArrayList();
    private WatchTreeModel a;
    private NoTracingClassesTreeModel b;
    private BreakpointTreeModel h;

    static {
        c = 0;
        PAUSE_AFTER_LAUNCH = new MapProperty("debug", "PauseAfterLaunch", "0");
        f = JBuilderInfo.isEnterpriseEnabled();
    }

    public static boolean isDebuggableTextFileNode(Node node) {
        if (f) {
            return node instanceof JBDebuggable && node instanceof TextFileNode;
        }
        return node instanceof JavaFileNode;
    }

    public void dialogClosed(JDialog jDialog) {
        if (jDialog instanceof EvaluateModifyDialog) {
            if (!this.e.isModal()) {
                this.e.removeModelessDialogListener(this);
            }
            this.e = null;
        }
    }

    public int getLastDebugTabShown() {
        return c;
    }

    public void setLastDebugTabShown(int n2) {
        c = n2;
    }

    public void cleanUpAfterDebug(VirtualMachine virtualMachine) {
        this.resetBreakpoints(virtualMachine);
        if (this.e != null) {
            this.e.closeDialog();
            this.e = null;
        }
    }

    public List getNoTracingClassesList() {
        return this.b.getClassList();
    }

    public WatchTreeModel getWatchTreeModel() {
        return this.a;
    }

    public NoTracingClassesTreeModel getNoTracingClassesTreeModel() {
        return this.b;
    }

    public BreakpointTreeModel getBreakpointTreeModel() {
        return this.h;
    }

    public void setAllTreeModelTracker(DebugJavaProcessTracker debugJavaProcessTracker) {
        this.a.setTracker(debugJavaProcessTracker);
        this.h.setTracker(debugJavaProcessTracker);
    }

    public static KeyStroke getRunOrResumeAcceleratorKey() {
        return (KeyStroke)RuntimeActionPool.ACTION_DummyRunOrResumeProject.getValue("Accelerator");
    }

    public static DebugJavaProcessTracker getCurrentDebugSession() {
        return DebugJavaProcessTracker.getCurrent();
    }

    public static boolean isDebuggingAndCanStep() {
        DebugJavaProcessTracker debugJavaProcessTracker = DebugJavaProcessTracker.getCurrent();
        return debugJavaProcessTracker != null && debugJavaProcessTracker.debugJavaProcessCanStep();
    }

    public static boolean isDebuggingAndCanPause() {
        DebugJavaProcessTracker debugJavaProcessTracker = DebugJavaProcessTracker.getCurrent();
        return debugJavaProcessTracker != null && debugJavaProcessTracker.debugJavaProcessCanPause();
    }

    public static boolean isDebuggingAndCanResume() {
        DebugJavaProcessTracker debugJavaProcessTracker = DebugJavaProcessTracker.getCurrent();
        return debugJavaProcessTracker != null && debugJavaProcessTracker.debugJavaProcessCanResume();
    }

    public static boolean isDebuggingAndSuspended() {
        DebugJavaProcessTracker debugJavaProcessTracker = DebugJavaProcessTracker.getCurrent();
        return debugJavaProcessTracker != null && debugJavaProcessTracker.debugJavaProcessIsSuspended();
    }

    public static boolean isDebugging() {
        DebugJavaProcessTracker debugJavaProcessTracker = DebugJavaProcessTracker.getCurrent();
        return debugJavaProcessTracker != null && debugJavaProcessTracker.getDebugJavaProcess() != null;
    }

    public void saveEvaluateExpressions(JBProject jBProject) {
        String[] stringArray = this.d.toArray(new String[this.d.size()]);
        DebugPropertyGroup.EVALUATE_EXPRESSIONS.setValues(jBProject, stringArray);
    }

    public void restoreEvaluateExpressions(JBProject jBProject) {
        if (DebugPropertyGroup.EVALUATE_EXPRESSIONS.getValues(jBProject) != null) {
            this.d = new ArrayList();
            String[] stringArray = DebugPropertyGroup.EVALUATE_EXPRESSIONS.getValues(jBProject);
            if (stringArray != null) {
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.d.add(stringArray[i2]);
                }
            }
        }
    }

    public void restoreWatches(JBProject jBProject) {
        this.a.addFromArray(DebugPropertyGroup.WATCHES.getValues(jBProject));
    }

    public void saveWatches(JBProject jBProject) {
        String[] stringArray = this.a.toArray(this.a.getWatchList());
        DebugPropertyGroup.WATCHES.setValues(jBProject, stringArray);
    }

    public void restoreNoTracingClasses(JBProject jBProject) {
        this.b.addFromArray(DebugPropertyGroup.NO_TRACING_CLASSES.getValues(jBProject));
    }

    public void saveNoTracingClasses(JBProject jBProject) {
        String[] stringArray = this.b.toArray(this.b.getClassList());
        DebugPropertyGroup.NO_TRACING_CLASSES.setValues(jBProject, stringArray);
    }

    public void restoreBreakpoints(JBProject jBProject) {
        this.getBreakpointTreeModel().addFromArray(DebugPropertyGroup.BREAKPOINTS.getValues(jBProject));
    }

    public void saveBreakpoints(JBProject jBProject) {
        String[] stringArray = this.getBreakpointTreeModel().toArray(this.getBreakpointTreeModel().getBreakpointList());
        DebugPropertyGroup.BREAKPOINTS.setValues(jBProject, stringArray);
    }

    private void a(JBProject jBProject) {
        try {
            boolean bl = JBuilderInfo.isProEnabled();
            boolean bl2 = JBuilderInfo.isEnterpriseEnabled();
            int n2 = 1;
            try {
                if (!bl || !bl2) {
                    n2 += RunPropertyGroup.getConfigurationCount(jBProject);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                RunConfiguration runConfiguration = new RunConfiguration(jBProject, i2, new String[]{"debug"});
                runConfiguration.readProperties();
                Map map = runConfiguration.getMap();
                if (i2 == 0) {
                    DebugPropertyGroupOld.readOldProperties(jBProject, map);
                }
                if (!bl) {
                    DebugPropertyGroup.SMART_STEP.setValue(map, "0");
                }
                if (!bl2) {
                    DebugPropertyGroup.REMOTE_DEBUG.setValue(map, "0");
                }
                runConfiguration.writeProperties();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restoreDebugSettings(JBProject jBProject) {
        if (!this.i) {
            this.i = true;
            this.restoreBreakpoints(jBProject);
            this.restoreNoTracingClasses(jBProject);
            this.restoreWatches(jBProject);
            this.restoreEvaluateExpressions(jBProject);
            this.a(jBProject);
        }
    }

    public void saveDebugSettings(JBProject jBProject) {
        this.saveBreakpoints(jBProject);
        this.saveNoTracingClasses(jBProject);
        this.saveWatches(jBProject);
        this.saveEvaluateExpressions(jBProject);
    }

    public void evaluateExpression(Component component, String string) {
        if (this.e == null) {
            DebugJavaProcessTracker debugJavaProcessTracker = DebugJavaProcessTracker.getCurrent();
            if (debugJavaProcessTracker != null && debugJavaProcessTracker.getDebugJavaProcess() != null) {
                this.e = EvaluateModifyDialog.showEvaluateModifyDialog(component, this.d, false, debugJavaProcessTracker, string);
                if (!this.e.isModal()) {
                    this.e.addModelessDialogListener(this);
                }
            }
        } else {
            this.e.setInitialExpression(string);
            ((Component)this.e).setVisible(true);
        }
    }

    public void clearNoTracingClasses() {
        this.b.clearClasses();
    }

    public void deleteNoTracingClass(NoTracingClassTreeNode noTracingClassTreeNode) {
        this.b.deleteClass(noTracingClassTreeNode);
    }

    public void addNoTracingClass(String string) {
        this.b.addClass(string);
    }

    public void viewTracingDisabled(Component component) {
        NoTracingClassesTree noTracingClassesTree = new NoTracingClassesTree(this.getNoTracingClassesTreeModel(), -1);
        TracingDisabledDialog tracingDisabledDialog = new TracingDisabledDialog(component, noTracingClassesTree);
        tracingDisabledDialog.show();
        noTracingClassesTree.cleanUp();
    }

    public void resetBreakpoints(VirtualMachine virtualMachine) {
        this.getBreakpointTreeModel().resetBreakpoints(virtualMachine);
    }

    public void deleteBreakpoint(BreakpointTreeNode breakpointTreeNode) {
        this.getBreakpointTreeModel().deleteBreakpoint(breakpointTreeNode);
    }

    public void viewBreakpoints(Component component) {
        BreakpointTree breakpointTree = new BreakpointTree(this.getBreakpointTreeModel(), -1);
        BreakpointDialog breakpointDialog = new BreakpointDialog(component, breakpointTree);
        breakpointDialog.show();
        breakpointTree.cleanUp();
    }

    public void disconnectAllBreakpoints(VirtualMachine virtualMachine) {
        this.getBreakpointTreeModel().disconnectAllBreakpoints(virtualMachine);
    }

    public void connectAllBreakpoints(VirtualMachine virtualMachine) {
        this.getBreakpointTreeModel().connectAllBreakpoints(virtualMachine);
    }

    public DebugInfoManager(JBProject jBProject) {
        this.h = new BreakpointTreeModel(jBProject);
        this.h.rebuildModel();
        this.b = new NoTracingClassesTreeModel(jBProject);
        this.b.rebuildModel();
        this.a = new WatchTreeModel(jBProject);
        this.a.rebuildModel();
    }

    public static void initOpenTool(byte by, byte by2) {
        PrimeTime.initializeOpenTools("Debugger");
        EditorPane.registerToolTipProvider(new DebuggerToolTipProvider(JBuilderInfo.isProEnabled()));
        TextView.registerCustomMouseActionProvider(new DebuggerCustomMouseActionProvider(JBuilderInfo.isProEnabled()));
        Browser.addStaticBrowserListener(new n());
    }
}

