/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.debugger;

import com.borland.jbuilder.debugger.BreakpointMark;
import com.borland.jbuilder.debugger.ExecutionPointMark;
import com.borland.jbuilder.node.JBProject;
import com.borland.primetime.editor.Gutter;
import com.borland.primetime.editor.GutterListener;
import com.borland.primetime.editor.LineMark;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.util.Platform;
import com.borland.primetime.viewer.NodeViewMap;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class DebuggerGutterListener
implements GutterListener {
    public void linesChanged(Gutter gutter) {
        JBProject jBProject;
        FileNode fileNode = NodeViewMap.getNode(gutter.getEditor());
        if (fileNode != null && (jBProject = (JBProject)fileNode.getProject()) != null) {
            jBProject.getDebugInfoManager().getBreakpointTreeModel().linesChanged(gutter, fileNode.getUrl().getFile());
        }
    }

    public void lineClicked(Gutter gutter, int n2, MouseEvent mouseEvent, LineMark[] lineMarkArray) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) || Platform.MAC) {
            for (int i2 = 0; i2 < lineMarkArray.length; ++i2) {
                if (lineMarkArray[i2].getStyle() == null || lineMarkArray[i2].getStyle().getName() == null || !lineMarkArray[i2].getStyle().getName().equals("mergeconflict")) continue;
                return;
            }
            JBProject jBProject = null;
            FileNode fileNode = NodeViewMap.getNode(gutter.getEditor());
            if (fileNode != null) {
                jBProject = (JBProject)fileNode.getProject();
            } else {
                Browser browser = NodeViewMap.getBrowser(gutter.getEditor());
                if (browser != null) {
                    jBProject = (JBProject)browser.getProjectView().getActiveUserProject();
                }
            }
            if (jBProject != null) {
                jBProject.getDebugInfoManager().getBreakpointTreeModel().lineClicked(gutter, n2, mouseEvent);
            }
        }
    }

    public static void initOpenTool(byte by, byte by2) {
        Gutter.addStaticGutterListener(new DebuggerGutterListener());
        new BreakpointMark(-1, null);
        new ExecutionPointMark();
    }
}

