/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.editor;

import com.borland.jbuilder.editor.a;
import com.borland.jbuilder.editor.c;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.paths.ProjectPathSet;
import com.borland.primetime.editor.SearchManager;
import com.borland.primetime.editor.SearchOptions;
import com.borland.primetime.help.PrimetimeHelp;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ui.ButtonStrip;
import com.borland.primetime.ui.DefaultDialog;
import com.borland.primetime.util.RegularExpression;
import com.borland.primetime.vfs.Url;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SearchSourcePathDialog
extends DefaultDialog
implements ActionListener {
    protected JCheckBox subdirectoriesCheck;
    protected JCheckBox caseSensitiveCheck;
    protected JComboBox pathCombo;
    protected JLabel pathLabel;
    protected JComboBox searchCombo;
    protected JLabel searchLabel;
    protected BorderLayout borderLayout1;
    protected JButton helpButton;
    protected JButton cancelButton;
    protected JButton okButton;
    protected ButtonStrip buttons = new ButtonStrip(false);
    protected Browser browser;
    private static RegularExpression m = new RegularExpression("*.java");

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            ((Component)this).setVisible(false);
            this.searchPath();
            this.closeDialog();
        } else if (object == this.cancelButton) {
            this.closeDialog();
        } else if (object == this.helpButton) {
            this.showHelp();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = 420;
        return dimension;
    }

    protected void showHelp() {
        PrimetimeHelp.TOPIC_DSrchPath.show((JDialog)this);
    }

    protected void closeDialog() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    protected void searchPath() {
        SearchOptions searchOptions = this.setOptions();
        if (searchOptions.getSearchText().length() == 0) {
            return;
        }
        JBProject jBProject = (JBProject)this.browser.getProjectView().getActiveUserProject();
        ProjectPathSet projectPathSet = jBProject.getPaths();
        Url[] urlArray = null;
        int n2 = this.pathCombo.getSelectedIndex();
        if (n2 == 0) {
            urlArray = projectPathSet.getSourcePath();
        } else if (n2 == 1) {
            urlArray = projectPathSet.getFullSourcePath();
        } else {
            urlArray = projectPathSet.getFullSourcePath();
            urlArray = new Url[]{urlArray[n2 - 2]};
        }
        SearchManager.searchPaths(this.browser, jBProject, urlArray, searchOptions);
    }

    protected SearchOptions setOptions() {
        SearchOptions searchOptions = new SearchOptions(SearchManager.getSavedOptions());
        String string = this.searchCombo.getEditor().getItem().toString();
        searchOptions.setSearchText(string);
        SearchManager.addSearchText(string);
        searchOptions.setCaseSensitive(this.caseSensitiveCheck.isSelected());
        searchOptions.setRecurseDirectories(this.subdirectoriesCheck.isSelected());
        searchOptions.setFilenameFilters(new RegularExpression[]{m});
        SearchManager.setSavedOptions(searchOptions);
        return searchOptions;
    }

    protected void jbInit() throws Exception {
        int n2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.searchLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 2), 0, 0));
        jPanel.add((Component)this.searchCombo, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(4, 2, 4, 4), 0, 0));
        jPanel.add((Component)this.caseSensitiveCheck, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.add((Component)this.subdirectoriesCheck, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        jPanel.add((Component)this.pathLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 2), 0, 0));
        jPanel.add((Component)this.pathCombo, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(4, 2, 4, 4), 0, 0));
        this.searchCombo.setModel(SearchManager.getSearchHistory());
        this.searchCombo.setEditable(true);
        this.searchCombo.getEditor().getEditorComponent().addKeyListener(new c(this));
        JBProject jBProject = (JBProject)this.browser.getProjectView().getActiveUserProject();
        ProjectPathSet projectPathSet = jBProject.getPaths();
        Url[] urlArray = projectPathSet.getSourcePath();
        String string = "";
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(urlArray[i2].getFile())));
            if (i2 >= urlArray.length - 1) continue;
            string = String.valueOf(String.valueOf(string)).concat(";");
        }
        if (string.length() > 0) {
            this.pathCombo.addItem(string);
        }
        this.pathCombo.setLightWeightPopupEnabled(false);
        urlArray = projectPathSet.getFullSourcePath();
        String string2 = "";
        for (n2 = 0; n2 < urlArray.length; ++n2) {
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(urlArray[n2].getFile())));
            if (n2 >= urlArray.length - 1) continue;
            string2 = String.valueOf(String.valueOf(string2)).concat(";");
        }
        if (string2.length() > 0) {
            this.pathCombo.addItem(string2);
        }
        if (urlArray.length > 1) {
            for (n2 = 0; n2 < urlArray.length; ++n2) {
                this.pathCombo.addItem(urlArray[n2].getFile());
            }
        }
        if (this.pathCombo.getModel().getSize() == 0) {
            String string3 = a.a(35);
            this.pathCombo.addItem(string3);
            this.okButton.setEnabled(false);
        }
        this.pathCombo.setSelectedIndex(0);
        this.getContentPane().setLayout(this.borderLayout1);
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.setDefaultButton(this.okButton);
        this.setCancelButton(this.cancelButton);
        this.setHelpButton(this.helpButton);
        SearchOptions searchOptions = SearchManager.getSavedOptions();
        this.caseSensitiveCheck.setSelected(searchOptions.isCaseSensitive());
        this.subdirectoriesCheck.setSelected(searchOptions.isRecurseDirectories());
        this.caseSensitiveCheck.setMnemonic(a.a(36).charAt(0));
        this.subdirectoriesCheck.setMnemonic(a.a(44).charAt(0));
    }

    public void addNotify() {
        super.addNotify();
        this.searchCombo.getEditor().selectAll();
        this.searchCombo.requestFocus();
    }

    public SearchSourcePathDialog(Browser browser) {
        this(browser, "Find in Source Path");
    }

    public SearchSourcePathDialog(Browser browser, String string) {
        super((Component)browser, string, true);
        this.okButton = this.buttons.createOkButton(true);
        this.cancelButton = this.buttons.createCancelButton(true);
        this.helpButton = this.buttons.createHelpButton(true);
        this.borderLayout1 = new BorderLayout();
        this.searchLabel = new JLabel(a.a(65));
        this.searchCombo = new JComboBox();
        this.pathLabel = new JLabel(a.a(59));
        this.pathCombo = new JComboBox();
        this.caseSensitiveCheck = new JCheckBox(a.a(5));
        this.subdirectoriesCheck = new JCheckBox(a.a(43));
        try {
            this.browser = browser;
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

