/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.schemamanager.jdbc;

import com.borland.jbuilder.schemamanager.SchemaColumnNode;
import com.borland.jbuilder.schemamanager.SchemaConnectionNode;
import com.borland.jbuilder.schemamanager.SchemaForeignKeyNode;
import com.borland.jbuilder.schemamanager.SchemaNode;
import com.borland.jbuilder.schemamanager.SchemaPrimaryKeyNode;
import com.borland.jbuilder.schemamanager.SchemaResolver;
import com.borland.jbuilder.schemamanager.SchemaTableNode;
import com.borland.jbuilder.schemamanager.SchemaTree;
import com.borland.jbuilder.schemamanager.VendorMap;
import com.borland.jbuilder.schemamanager.VendorMapEntry;
import com.borland.jbuilder.schemamanager.jdbc.JdbcConfig;
import com.borland.jbuilder.schemamanager.jdbc.JdbcSchemaProvider;
import com.borland.jbuilder.schemamanager.jdbc.a;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class JdbcSchemaResolver
implements JdbcConfig,
SchemaResolver {
    protected VendorMap map = new VendorMap();
    protected boolean verbose = false;
    private transient Connection k;
    private String d = null;
    private String l = null;
    private String e = "primary key";
    private String f = null;
    private String a = null;
    private String h = null;
    private String c = null;
    private String i = null;
    private boolean b = false;
    private boolean j = false;
    private boolean g = false;

    public static void main(String[] stringArray) {
        JdbcSchemaResolver.testJDS();
    }

    public static void testJDS() {
        JdbcSchemaProvider jdbcSchemaProvider = new JdbcSchemaProvider();
        JdbcSchemaProvider.setupForJDS(jdbcSchemaProvider);
        SchemaTree schemaTree = jdbcSchemaProvider.provideSchema();
        SchemaConnectionNode schemaConnectionNode = (SchemaConnectionNode)schemaTree.getRoot();
        System.err.println("Url=".concat(String.valueOf(String.valueOf(schemaConnectionNode.getUrl()))));
        System.err.println("Driver=".concat(String.valueOf(String.valueOf(schemaConnectionNode.getDriver()))));
        System.err.println("DataSource=".concat(String.valueOf(String.valueOf(schemaConnectionNode.getDataSourceName()))));
        System.err.println("");
        JdbcSchemaResolver jdbcSchemaResolver = new JdbcSchemaResolver();
        JdbcSchemaResolver.setupForJDS(jdbcSchemaResolver);
        System.err.println(jdbcSchemaResolver.resolveSchemaToStrings(schemaTree));
    }

    public static void testNoTypeMatch() {
        JdbcSchemaProvider jdbcSchemaProvider = new JdbcSchemaProvider();
        JdbcSchemaProvider.setupForJDS(jdbcSchemaProvider);
        SchemaTree schemaTree = jdbcSchemaProvider.provideSchema();
        SchemaTableNode schemaTableNode = schemaTree.findTable("BTABLE");
        SchemaColumnNode schemaColumnNode = new SchemaColumnNode();
        schemaColumnNode.setName("bogus");
        schemaColumnNode.setJavaSqlType(-7);
        schemaColumnNode.setVendorTypeName("BIT");
        schemaTableNode.add(schemaColumnNode);
        JdbcSchemaResolver jdbcSchemaResolver = new JdbcSchemaResolver();
        JdbcSchemaResolver.setupForJDS(jdbcSchemaResolver);
        System.err.println(jdbcSchemaResolver.resolveSchemaToStrings(schemaTree));
    }

    public static void testExportSchema() {
        JdbcSchemaProvider jdbcSchemaProvider = new JdbcSchemaProvider();
        JdbcSchemaResolver jdbcSchemaResolver = new JdbcSchemaResolver();
        JdbcSchemaProvider.setupForJDS(jdbcSchemaProvider);
        SchemaTree schemaTree = jdbcSchemaProvider.provideSchema();
        JdbcSchemaResolver.setupForIBase(jdbcSchemaResolver);
        System.err.println(jdbcSchemaResolver.resolveSchemaToStrings(schemaTree));
    }

    public static void setupForIBase(JdbcSchemaResolver jdbcSchemaResolver) {
        jdbcSchemaResolver.setDriver("interbase.interclient.Driver");
        jdbcSchemaResolver.setUrl("jdbc:interbase://localhost/C:\\temp\\hello.gdb");
        jdbcSchemaResolver.setUsername("SYSDBA");
        jdbcSchemaResolver.setPassword("masterkey");
        jdbcSchemaResolver.setVendorMap(VendorMap.getMap("InterBase"));
    }

    public static void setupForJDS(JdbcSchemaResolver jdbcSchemaResolver) {
        jdbcSchemaResolver.setDriver("com.borland.datastore.jdbc.DataStoreDriver");
        jdbcSchemaResolver.setUrl("jdbc:borland:dslocal:C:\\proj\\data\\test51.jds");
        jdbcSchemaResolver.setUsername("SYSDBA");
        jdbcSchemaResolver.setPassword("masterkey");
        jdbcSchemaResolver.setVendorMap(VendorMap.getMap("JDataStore"));
    }

    private void a() {
        block3: {
            try {
                if (this.j) {
                    this.k.close();
                    this.j = false;
                }
                this.g = false;
            }
            catch (Exception exception) {
                if (!this.verbose) break block3;
                System.err.println(exception);
            }
        }
    }

    private boolean b() {
        if (this.g) {
            return true;
        }
        try {
            if (this.j) {
                this.k.close();
                this.j = false;
            }
            if (!this.b) {
                com.fourthpass.runtimejb.a.a(this.h);
                this.k = DriverManager.getConnection(this.c, this.a, this.f);
                if (this.k != null) {
                    this.g = true;
                    this.j = true;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            this.g = false;
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            if (this.verbose) {
                System.err.println("SchemaProvider.importSchema():");
                System.err.println(sQLException);
            }
            JOptionPane.showMessageDialog(null, "Error initializing database connection.", com.borland.jbuilder.schemamanager.jdbc.a.a(1), 0);
            this.g = false;
            boolean bl = false;
            return bl;
        }
        return false;
    }

    private static ArrayList a(SchemaTableNode schemaTableNode) {
        ArrayList<SchemaPrimaryKeyNode> arrayList = new ArrayList<SchemaPrimaryKeyNode>(17);
        Iterator iterator = ((AbstractList)schemaTableNode.listColumns()).iterator();
        while (iterator.hasNext()) {
            SchemaColumnNode schemaColumnNode = (SchemaColumnNode)iterator.next();
            if (!schemaColumnNode.isPrimaryKey()) continue;
            SchemaPrimaryKeyNode schemaPrimaryKeyNode = new SchemaPrimaryKeyNode();
            schemaPrimaryKeyNode.setColumnName(schemaColumnNode.getName());
            schemaPrimaryKeyNode.setKeyName(schemaColumnNode.getName());
            schemaPrimaryKeyNode.setName(schemaColumnNode.getName());
            arrayList.add(schemaPrimaryKeyNode);
        }
        return arrayList;
    }

    public ArrayList resolveSchemaToStrings(SchemaTree schemaTree) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (schemaTree == null) {
            return null;
        }
        ArrayList arrayList2 = schemaTree.listTables();
        Iterator iterator = ((AbstractList)arrayList2).iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Iterator iterator2;
            Cloneable cloneable;
            SchemaTableNode schemaTableNode = (SchemaTableNode)iterator.next();
            stringBuffer.append("create table \"");
            stringBuffer.append(schemaTableNode.getName());
            stringBuffer.append("\"(\n");
            ArrayList arrayList3 = schemaTableNode.listColumns();
            Iterator iterator3 = ((AbstractList)arrayList3).iterator();
            boolean bl = true;
            while (iterator3.hasNext()) {
                if (!bl) {
                    stringBuffer.append(",\n");
                }
                bl = false;
                cloneable = (SchemaColumnNode)iterator3.next();
                stringBuffer.append("  \"");
                stringBuffer.append(((SchemaNode)cloneable).getName());
                stringBuffer.append("\" ");
                iterator2 = this.map.lookupByType(((SchemaColumnNode)cloneable).getJavaSqlType());
                if (iterator2 == null) {
                    JOptionPane.showMessageDialog(null, String.valueOf(String.valueOf(new StringBuffer("  Destination driver does not support type \"").append(((SchemaColumnNode)cloneable).getVendorTypeName()).append("\"   \n  [JDBC type= ").append(((SchemaColumnNode)cloneable).getJavaSqlType()).append("  table=").append(schemaTableNode.getName()).append("  col=").append(((SchemaNode)cloneable).getName()).append("]"))), com.borland.jbuilder.schemamanager.jdbc.a.a(2), 2);
                    stringBuffer.append(((SchemaColumnNode)cloneable).getVendorTypeName());
                }
                String string = ((VendorMapEntry)((Object)iterator2)).getVendorTypeName();
                boolean bl2 = ((VendorMapEntry)((Object)iterator2)).getRequiresPrecision();
                boolean bl3 = ((VendorMapEntry)((Object)iterator2)).getRequiresScale();
                if (bl2 || bl3) {
                    int n2 = string.indexOf("(");
                    if (n2 != -1) {
                        int n3 = string.indexOf(")");
                        int n4 = ((SchemaColumnNode)cloneable).getPrecision();
                        if (n4 == -1) {
                            n4 = 1024;
                        }
                        stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string.substring(0, n2 + 1)))).append(n4).append(string.substring(n3)))));
                        continue;
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("(");
                    stringBuffer.append(((SchemaColumnNode)cloneable).getPrecision());
                    if (bl3) {
                        stringBuffer.append(",");
                        stringBuffer.append(((SchemaColumnNode)cloneable).getScale());
                    }
                    stringBuffer.append(")");
                    continue;
                }
                stringBuffer.append(string);
            }
            cloneable = JdbcSchemaResolver.a(schemaTableNode);
            iterator2 = ((AbstractList)((Object)cloneable)).iterator();
            if (iterator2.hasNext()) {
                stringBuffer.append(String.valueOf(String.valueOf(new StringBuffer(",\n  ").append(this.e).append("("))));
                boolean bl4 = true;
                while (iterator2.hasNext()) {
                    if (!bl4) {
                        stringBuffer.append(", ");
                    }
                    bl4 = false;
                    SchemaPrimaryKeyNode schemaPrimaryKeyNode = (SchemaPrimaryKeyNode)iterator2.next();
                    stringBuffer.append(schemaPrimaryKeyNode.getColumnName());
                }
                stringBuffer.append(")");
            }
            if ((iterator2 = ((AbstractList)((Object)(cloneable = schemaTableNode.listForeignKeys()))).iterator()).hasNext()) {
                while (iterator2.hasNext()) {
                    stringBuffer.append(",\n  foreign key(");
                    SchemaForeignKeyNode schemaForeignKeyNode = (SchemaForeignKeyNode)iterator2.next();
                    stringBuffer.append(schemaForeignKeyNode.getFkColumnName());
                    stringBuffer.append(") references ");
                    stringBuffer.append(schemaForeignKeyNode.getPkTableName());
                    stringBuffer.append("\n");
                }
            }
            stringBuffer.append(");\n");
            arrayList.add(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        return arrayList;
    }

    public boolean resolveSchema(SchemaTree schemaTree) {
        ArrayList arrayList = this.resolveSchemaToStrings(schemaTree);
        try {
            if (arrayList != null) {
                if (!this.b()) {
                    boolean bl = false;
                    return bl;
                }
                Statement statement = this.k.createStatement();
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    statement.executeUpdate((String)iterator.next());
                }
                statement.close();
                this.a();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            if (this.verbose) {
                System.err.println(exception);
            }
            boolean bl = false;
            return bl;
        }
        return false;
    }

    public void setVendorMap(VendorMap vendorMap) {
        this.map = vendorMap;
    }

    public VendorMap getVendorMap() {
        return this.map;
    }

    public Connection getJDBCConnection() {
        if (!this.b()) {
            return null;
        }
        return this.k;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public String getCatalog() {
        return this.l;
    }

    public void setCatalog(String string) {
        this.l = string;
    }

    public String getSqlSchema() {
        return this.d;
    }

    public void setSqlSchema(String string) {
        this.d = string;
    }

    public String getUsername() {
        return this.a;
    }

    public void setUsername(String string) {
        this.g = false;
        this.a = string;
    }

    public String getPassword() {
        return this.f;
    }

    public void setPassword(String string) {
        this.g = false;
        this.f = string;
    }

    public String getDriver() {
        if (this.b) {
            return null;
        }
        return this.h;
    }

    public void setDriver(String string) {
        this.g = false;
        this.b = false;
        this.h = string;
    }

    public String getUrl() {
        if (this.b) {
            return null;
        }
        return this.c;
    }

    public void setUrl(String string) {
        this.g = false;
        this.b = false;
        this.c = string;
    }

    public String getDataSourceName() {
        if (!this.b) {
            return null;
        }
        return this.i;
    }

    public void setDataSourceName(String string) {
        this.g = false;
        this.b = true;
        this.i = string;
    }
}

