/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.wizard.archive;

import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.paths.ProjectPathSet;
import com.borland.jbuilder.wizard.archive.ArchiveBuilder;
import com.borland.jbuilder.wizard.archive.ArchivePropertyGroup;
import com.borland.jbuilder.wizard.archive.ArchiveTarget;
import com.borland.jbuilder.wizard.archive.ArchiveWizard;
import com.borland.jbuilder.wizard.archive.ContentPropertyGroup;
import com.borland.jbuilder.wizard.archive.DependGroup;
import com.borland.jbuilder.wizard.archive.DependPath;
import com.borland.jbuilder.wizard.archive.DependencyPropertyGroup;
import com.borland.jbuilder.wizard.archive.DirectoryArchiveTarget;
import com.borland.jbuilder.wizard.archive.FileArchiveTarget;
import com.borland.jbuilder.wizard.archive.ManifestPropertyGroup;
import com.borland.jbuilder.wizard.archive.a;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.util.Streams;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Archiver {
    static Class a;
    static int b;

    static {
        b = 2;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void writeTarget(Node node, DependGroup dependGroup, ArchiveTarget archiveTarget) throws IOException {
        dependGroup.writeFiles(archiveTarget);
    }

    protected void addManifestEntries(Node node, DependGroup dependGroup, Manifest manifest) throws IOException {
    }

    protected void addDependUrls(Node node, DependGroup dependGroup, ArchiveTarget archiveTarget) throws IOException {
        Project project = node.getProject();
        if (!(project instanceof JBProject)) {
            return;
        }
        JBProject jBProject = (JBProject)project;
        Url[] urlArray = jBProject.getPaths().getSourcePath();
        Url url = jBProject.getPaths().getOutPath();
        ContentPropertyGroup.ExtraRootInfo[] extraRootInfoArray = ContentPropertyGroup.readExtraRootInfo(node);
        block0: for (int i2 = 0; i2 < extraRootInfoArray.length; ++i2) {
            Url url2;
            boolean bl = extraRootInfoArray[i2].isClass();
            String string = extraRootInfoArray[i2].getPath();
            if (bl) {
                if (string.endsWith(".*")) {
                    String string2 = string.substring(0, string.length() - 2);
                    string2 = string2.replace('.', '/');
                    url2 = url.getRelativeUrl(string2);
                    Url[] urlArray2 = VFS.getChildren(url2, 2);
                    for (int i3 = 0; i3 < urlArray2.length; ++i3) {
                        Url url3 = urlArray2[i3];
                        dependGroup.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string2))).append('/').append(url3.getName()))), url3, true);
                    }
                    continue;
                }
                dependGroup.addRequiredClass(string);
                continue;
            }
            for (int i4 = 0; i4 < urlArray.length; ++i4) {
                url2 = urlArray[i4].getRelativeUrl(string);
                if (!VFS.exists(url2)) continue;
                dependGroup.add(Url.URL_ENCODING.decode(string), url2, false);
                continue block0;
            }
        }
    }

    protected void addLibraryDependPaths(Node node, DependGroup dependGroup, ArchiveTarget archiveTarget) throws IOException {
        if (!(node.getProject() instanceof JBProject)) {
            return;
        }
        JBProject jBProject = (JBProject)node.getProject();
        ProjectPathSet projectPathSet = jBProject.getPaths();
        DependencyPropertyGroup.LibraryInfo[] libraryInfoArray = DependencyPropertyGroup.readDependInfo(node);
        for (int i2 = 0; i2 < libraryInfoArray.length; ++i2) {
            int n2 = libraryInfoArray[i2].getType();
            Url[] urlArray = libraryInfoArray[i2].getPathSet().getClassPath();
            for (int i3 = 0; i3 < urlArray.length; ++i3) {
                if (this.isLibraryJar()) {
                    dependGroup.addDependPath(new DependPath(urlArray[i3], n2, this.getLibraryPrefix()), libraryInfoArray[i2].getPathSet().getName());
                    continue;
                }
                dependGroup.addDependPath(new DependPath(urlArray[i3], n2, null));
            }
        }
    }

    protected void addProjectDependPaths(Node node, DependGroup dependGroup, ArchiveTarget archiveTarget) throws IOException {
        if (!(node.getProject() instanceof JBProject)) {
            return;
        }
        JBProject jBProject = (JBProject)node.getProject();
        ProjectPathSet projectPathSet = jBProject.getPaths();
        dependGroup.addDependPath(new DependPath(projectPathSet.getOutPath(), ContentPropertyGroup.getOutPathType(node)));
    }

    protected ArchiveTarget createTarget(Node node) throws IOException {
        String string = ArchivePropertyGroup.TARGET_PATH.getValue(node);
        if (string == null) {
            throw new IOException(com.borland.jbuilder.wizard.archive.a.a(88));
        }
        Url url = node.getProject().getProjectPath().getRelativeUrl(string);
        if ("file".equals(ArchivePropertyGroup.TARGET_TYPE.getValue(node))) {
            FileArchiveTarget fileArchiveTarget = new FileArchiveTarget(url);
            fileArchiveTarget.setCompressed("1".equals(ArchivePropertyGroup.TARGET_COMPRESSED.getValue(node)));
            return fileArchiveTarget;
        }
        return new DirectoryArchiveTarget(url);
    }

    protected Manifest createManifest(Node node, DependGroup dependGroup) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if ("0".equals(ManifestPropertyGroup.INCLUDE_MANIFEST.getValue(node))) {
            return null;
        }
        Project project = node.getProject();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        String string = ManifestPropertyGroup.MANIFEST_OVERRIDE_PATH.getValue(node);
        if (string == null) {
            this.addManifestEntries(node, dependGroup, manifest);
        } else {
            object3 = project.getProjectPath().getRelativeUrl(string);
            try {
                object2 = VFS.getInputStream((Url)object3);
                try {
                    object = Streams.read((InputStream)object2);
                    if (((byte[])object).length == 0) {
                        throw new IOException(com.borland.jbuilder.wizard.archive.a.a(60));
                    }
                    byte by = object[((byte[])object).length - 1];
                    if (by != 10 && by != 13) {
                        throw new IOException(com.borland.jbuilder.wizard.archive.a.a(86));
                    }
                    manifest.read(new ByteArrayInputStream((byte[])object));
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    ((InputStream)object2).close();
                    throw throwable;
                }
                ((InputStream)object2).close();
                {
                }
            }
            catch (IOException iOException) {
                throw new ArchiveBuilder.ArchiveBuildException(iOException.getMessage(), (Url)object3);
            }
        }
        object3 = ManifestPropertyGroup.MANIFEST_SAVE_PATH.getValue(node);
        if (object3 != null) {
            object2 = project.getProjectPath().getRelativeUrl((String)object3);
            object = VFS.getOutputStream((Url)object2, false);
            try {
                manifest.write((OutputStream)object);
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                ((OutputStream)object).close();
                throw throwable;
            }
            ((OutputStream)object).close();
            {
            }
        }
        return manifest;
    }

    protected DependGroup createDependGroup(Node node) {
        return new DependGroup(this.getClassPrefix());
    }

    protected void wizardFinished(Node node) {
        Url url;
        FileNode fileNode;
        Project project = node.getProject();
        String string = ManifestPropertyGroup.MANIFEST_OVERRIDE_PATH.getValue(node);
        if (string == null) {
            string = ManifestPropertyGroup.MANIFEST_SAVE_PATH.getValue(node);
        }
        if (string != null && !(fileNode = project.getNode(url = project.getProjectPath().getRelativeUrl(string))).isPersistent()) {
            fileNode.setParent(project);
        }
    }

    protected void setArchiverDefaults(Node node) {
        String string;
        String string2 = node.getProject().getUrl().getFile();
        int n2 = string2.lastIndexOf(47) + 1;
        int n3 = string2.lastIndexOf(46);
        String string3 = n3 < n2 ? string2.substring(n2) : string2.substring(n2, n3);
        Node[] nodeArray = this.a(node.getProject());
        String string4 = this.getArchivePathPrefix(node);
        if (string4.length() > 0 && !string4.endsWith("/")) {
            string4 = String.valueOf(String.valueOf(string4)).concat(String.valueOf(String.valueOf('/')));
        }
        int n4 = 1;
        while (true) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string4))).append(n4 == 1 ? string3 : String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(n4)))).append('.').append(this.getDefaultExtension())));
            boolean bl = false;
            for (int i2 = 0; i2 < nodeArray.length; ++i2) {
                String string5 = ArchivePropertyGroup.TARGET_PATH.getValue(nodeArray[i2]);
                if (!string.equals(string5)) continue;
                bl = true;
                break;
            }
            if (!bl) break;
            ++n4;
        }
        ArchivePropertyGroup.TARGET_PATH.setValue(node, string, false);
    }

    protected String getArchivePathPrefix(Node node) {
        return "";
    }

    protected String getLibraryPrefix() {
        return "";
    }

    protected boolean isLibraryJar() {
        return false;
    }

    protected String getClassPrefix() {
        return "";
    }

    protected int getBuildOrder() {
        return b;
    }

    protected String getDefaultExtension() {
        return "jar";
    }

    private void a(ArrayList arrayList, Node node) {
        Node[] nodeArray = node.getChildren();
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            Node node2 = nodeArray[i2];
            arrayList.add(node2);
            this.a(arrayList, node2);
        }
    }

    private Node[] a(Project project) {
        ArrayList arrayList = new ArrayList();
        this.a(arrayList, project);
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public void write(Node node) throws IOException {
        ArchiveTarget archiveTarget = this.createTarget(node);
        try {
            DependGroup dependGroup = this.createDependGroup(node);
            this.addProjectDependPaths(node, dependGroup, archiveTarget);
            this.addLibraryDependPaths(node, dependGroup, archiveTarget);
            dependGroup.open();
            try {
                this.addDependUrls(node, dependGroup, archiveTarget);
                dependGroup.addAllRequiredUrls();
                archiveTarget.setManifest(this.createManifest(node, dependGroup));
                this.writeTarget(node, dependGroup, archiveTarget);
                Object var5_4 = null;
                dependGroup.close();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                dependGroup.close();
                throw throwable;
            }
            Object var7_7 = null;
            archiveTarget.close();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            archiveTarget.close();
            throw throwable;
        }
    }

    public static void initOpenTool(byte by, byte by2) {
        ArchiveWizard.registerArchiver(com.borland.jbuilder.wizard.archive.a.a(24), com.borland.jbuilder.wizard.archive.a.a(23), a == null ? (a = Archiver.a("com.borland.jbuilder.wizard.archive.Archiver")) : a);
    }
}

