/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.GutterListener;
import com.borland.primetime.editor.GutterMark;
import com.borland.primetime.editor.LineMark;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class Gutter
extends JPanel
implements PropertyChangeListener,
MouseMotionListener,
MouseListener,
DocumentListener,
ChangeListener {
    static Class h;
    protected int clickRow = -1;
    private int b = -1;
    private EditorDocument f;
    private EditorPane e;
    private int d = 12;
    public static int GUTTERWIDTH;
    protected static ArrayList staticGutterListeners;
    protected ArrayList gutterListeners;

    static {
        GUTTERWIDTH = 20;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("document")) {
            EditorDocument editorDocument;
            this.f = editorDocument = (EditorDocument)propertyChangeEvent.getNewValue();
            editorDocument.addDocumentListener(this);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n2 = this.a(mouseEvent.getY()) + 1;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n2 = this.a(mouseEvent.getY()) + 1;
        if (n2 != -1 && n2 == this.clickRow) {
            this.fireLineClicked(n2, mouseEvent);
            this.repaint();
        }
        this.clickRow = -1;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.clickRow = this.a(mouseEvent.getY()) + 1;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementIndex(documentEvent.getOffset());
        int n3 = element.getElementIndex(documentEvent.getOffset() + documentEvent.getLength());
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.b(i2);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementCount();
        int n3 = element.getElementIndex(documentEvent.getOffset());
        if (n2 != this.b) {
            this.fireLinesChanged();
            this.b = n2;
            Rectangle rectangle = new Rectangle();
            this.computeVisibleRect(rectangle);
            int n4 = Math.min(this.a(rectangle.y + rectangle.height), n2);
            for (int i2 = n3; i2 < n4; ++i2) {
                this.b(i2);
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementCount();
        if (n2 != this.b) {
            this.fireLinesChanged();
            this.b = n2;
            Rectangle rectangle = new Rectangle();
            this.computeVisibleRect(rectangle);
            int n3 = element.getElementIndex(documentEvent.getOffset());
            int n4 = Math.min(this.a(rectangle.y + rectangle.height), n2);
            for (int i2 = n3; i2 < n4; ++i2) {
                this.b(i2);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Dimension dimension = this.e.getSize();
        if (dimension.height != this.getSize().height) {
            this.setSize(GUTTERWIDTH, dimension.height);
        }
    }

    private void b(int n2) {
        this.repaint(100L, 0, this.d * n2, this.getWidth(), this.d);
    }

    private int a(int n2) {
        return (n2 -= this.e.getInsets().top) / this.d;
    }

    protected void paintMark(Graphics graphics, int n2) {
        int n3;
        int n4;
        Icon icon = null;
        int n5 = -1;
        LineMark[] lineMarkArray = this.getMarks(n2 + 1);
        for (n4 = 0; n4 < lineMarkArray.length; ++n4) {
            GutterMark gutterMark;
            if (!(lineMarkArray[n4] instanceof GutterMark) || (gutterMark = (GutterMark)lineMarkArray[n4]).getDisplayPriority() <= n5 || gutterMark.getIcon() == null) continue;
            n5 = gutterMark.getDisplayPriority();
            icon = gutterMark.getIcon();
        }
        n4 = 0;
        int n6 = n2 * this.d;
        int n7 = Math.min(this.d, this.getHeight() - n6);
        n6 += this.e.getInsets().top;
        if (icon == null) {
            return;
        }
        if (n7 < icon.getIconHeight()) {
            n3 = icon.getIconHeight() - n7;
            n6 -= n3 / 2;
        } else if (n7 > icon.getIconHeight()) {
            n3 = n7 - icon.getIconHeight();
            n6 += n3 / 2;
        }
        if (this.getWidth() < icon.getIconWidth()) {
            n3 = icon.getIconWidth() - this.getWidth();
            n4 -= n3 / 2;
        } else if (this.getWidth() < icon.getIconWidth()) {
            n3 = this.getWidth() - icon.getIconWidth();
            n4 = n3 / 2;
        }
        icon.paintIcon(this, graphics, n4, n6);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = this.f.getDefaultRootElement().getElementCount();
        int n3 = this.a(rectangle.y);
        int n4 = Math.min(this.a(rectangle.y + rectangle.height), n2 - 1);
        if (n3 < 0) {
            return;
        }
        for (int i2 = n3; i2 <= n4; ++i2) {
            boolean bl = false;
            LineMark[] lineMarkArray = this.getMarks(i2 + 1);
            for (int i3 = 0; i3 < lineMarkArray.length; ++i3) {
                if (!(lineMarkArray[i3] instanceof GutterMark)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            this.paintMark(graphics, i2);
        }
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public LineMark[] getMarks(int n2) {
        return this.f.getLineMarks(n2 - 1, this.e);
    }

    public void removeMark(LineMark lineMark) {
        int n2 = this.f.removeLineMark(lineMark);
    }

    public void addMark(int n2, LineMark lineMark) {
        int n3 = this.f.setLineMark(n2 - 1, lineMark);
    }

    public int getMarkLine(LineMark lineMark) {
        if (!lineMark.displayInEditor(this.e)) {
            return -1;
        }
        int n2 = this.f.getMarkIndex(lineMark);
        return n2 != -1 ? n2 + 1 : -1;
    }

    protected void fireLinesChanged() {
        Gutter gutter = this;
        synchronized (gutter) {
            if (this.gutterListeners != null) {
                Iterator iterator = ((AbstractList)((ArrayList)this.gutterListeners.clone())).iterator();
                while (iterator.hasNext()) {
                    ((GutterListener)iterator.next()).linesChanged(this);
                }
            }
        }
        Class clazz = h == null ? (h = Gutter.class$("com.borland.primetime.editor.Gutter")) : h;
        synchronized (clazz) {
            if (staticGutterListeners != null) {
                Iterator iterator = ((AbstractList)((ArrayList)staticGutterListeners.clone())).iterator();
                while (iterator.hasNext()) {
                    ((GutterListener)iterator.next()).linesChanged(this);
                }
            }
        }
    }

    protected void fireLineClicked(int n2, MouseEvent mouseEvent) {
        LineMark[] lineMarkArray = this.getMarks(n2);
        Gutter gutter = this;
        synchronized (gutter) {
            if (this.gutterListeners != null) {
                Iterator iterator = ((AbstractList)((ArrayList)this.gutterListeners.clone())).iterator();
                while (iterator.hasNext()) {
                    ((GutterListener)iterator.next()).lineClicked(this, n2, mouseEvent, lineMarkArray);
                }
            }
        }
        Class clazz = h == null ? (h = Gutter.class$("com.borland.primetime.editor.Gutter")) : h;
        synchronized (clazz) {
            if (staticGutterListeners != null) {
                Iterator iterator = ((AbstractList)((ArrayList)staticGutterListeners.clone())).iterator();
                while (iterator.hasNext()) {
                    ((GutterListener)iterator.next()).lineClicked(this, n2, mouseEvent, lineMarkArray);
                }
            }
        }
    }

    public static synchronized void removeStaticGutterListener(GutterListener gutterListener) {
        if (staticGutterListeners == null) {
            return;
        }
        ((AbstractCollection)staticGutterListeners).remove(gutterListener);
        if (staticGutterListeners.size() == 0) {
            staticGutterListeners = null;
        }
    }

    public static synchronized void addStaticGutterListener(GutterListener gutterListener) {
        if (staticGutterListeners == null) {
            staticGutterListeners = new ArrayList();
        }
        staticGutterListeners.add(gutterListener);
    }

    public synchronized void removeGutterListener(GutterListener gutterListener) {
        if (this.gutterListeners == null) {
            return;
        }
        ((AbstractCollection)this.gutterListeners).remove(gutterListener);
        if (this.gutterListeners.size() == 0) {
            this.gutterListeners = null;
        }
    }

    public synchronized void addGutterListener(GutterListener gutterListener) {
        if (this.gutterListeners == null) {
            this.gutterListeners = new ArrayList();
        }
        this.gutterListeners.add(gutterListener);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (font != null) {
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(font);
            this.d = fontMetrics.getHeight();
        }
    }

    public EditorPane getEditor() {
        return this.e;
    }

    public void setEditor(EditorPane editorPane) {
        this.e = editorPane;
        this.f = (EditorDocument)editorPane.getDocument();
        this.setFont(editorPane.getFont());
        editorPane.addPropertyChangeListener(this);
    }

    public Gutter() {
        this.setSize(GUTTERWIDTH, 100);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

