/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.BasicStyleMap;
import com.borland.primetime.editor.EditorActions;
import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.EditorPropertyGroup;
import com.borland.primetime.editor.JBUndoManager;
import com.borland.primetime.editor.Scanner;
import com.borland.primetime.editor.s;
import com.borland.primetime.node.Node;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;
import javax.swing.text.ViewFactory;

public class TextEditorKit
extends DefaultEditorKit {
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    private static final int e = 32768;
    protected BasicStyleMap styleMap;
    protected Map registeredKeymaps = new HashMap(2);
    private static boolean a = false;

    static {
        String string = System.getProperty("primetime.editor.useVariableWidthFont", "false");
        if (string.equals("true")) {
            a = true;
        }
        e = 32768;
        EndOfLineStringProperty = EndOfLineStringProperty;
    }

    static boolean a() {
        return a;
    }

    public Action[] getActions() {
        new EditorActions();
        return EditorActions.getActions();
    }

    private String a(Node node, Document document) {
        String string = "\n";
        String string2 = "0";
        if (node != null) {
            string2 = EditorPropertyGroup.LINE_ENDING_STYLE.getValue(node.getProject());
        }
        if (string2.equals("0")) {
            Object object = document.getProperty(EndOfLineStringProperty);
            if (object != null && object instanceof String) {
                string = (String)object;
            }
        } else if (string2.equals("1")) {
            string = System.getProperty("line.separator", string);
        } else if (string2.equals("2")) {
            string = "\r\n";
        } else if (string2.equals("3")) {
            string = "\n";
        } else if (string2.equals("4")) {
            string = "\r";
        }
        return string;
    }

    public void write(Node node, Writer writer, Document document, int n2, int n3) throws IOException, BadLocationException {
        int n4;
        if (n2 < 0 || n2 + n3 > document.getLength()) {
            throw new BadLocationException("TextEditorKit.write", n2);
        }
        Segment segment = new Segment();
        int n5 = n2;
        String string = this.a(node, document);
        if (!string.equals("\n")) {
            int n6;
            for (n4 = n3; n4 > 0; n4 -= n6) {
                n6 = Math.min(n4, 4096);
                document.getText(n5, n6, segment);
                int n7 = segment.offset;
                char[] cArray = segment.array;
                int n8 = n7 + segment.count;
                for (int i2 = n7; i2 < n8; ++i2) {
                    if (cArray[i2] != '\n') continue;
                    if (i2 > n7) {
                        writer.write(cArray, n7, i2 - n7);
                    }
                    writer.write(string);
                    n7 = i2 + 1;
                }
                if (n8 > n7) {
                    writer.write(cArray, n7, n8 - n7);
                }
                n5 += n6;
            }
        } else {
            while (n4 > 0) {
                int n9 = Math.min(n4, 4096);
                document.getText(n5, n9, segment);
                writer.write(segment.array, segment.offset, segment.count);
                n5 += n9;
                n4 -= n9;
            }
        }
        writer.flush();
        document.putProperty(EndOfLineStringProperty, string);
    }

    public void write(Writer writer, Document document, int n2, int n3) throws IOException, BadLocationException {
        this.write(null, writer, document, n2, n3);
    }

    public void read(Node node, Reader reader, Document document, int n2) throws IOException, BadLocationException {
        int n3;
        int n4;
        int n5;
        int n6;
        StringBuffer stringBuffer = new StringBuffer(32768);
        char[] cArray = new char[32768];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while ((n6 = reader.read(cArray)) != -1) {
            n5 = 0;
            n4 = 0;
            while (n5 < n6) {
                int n10;
                if ((n10 = cArray[n5++]) == 10) {
                    ++n8;
                    if (n9 == 13) {
                        n9 = n10;
                        continue;
                    }
                }
                n9 = n10;
                if (n10 == 13) {
                    ++n7;
                    n10 = 10;
                }
                if (n10 == 12) {
                    n10 = 10;
                }
                cArray[n4++] = n10;
            }
            stringBuffer.append(cArray, 0, n4);
        }
        document.putProperty(EndOfLineStringProperty, n7 > 0 && n8 > 0 ? "\r\n" : (n7 > 0 && n8 == 0 ? "\r" : "\n"));
        n5 = document.getLength();
        n4 = stringBuffer.length();
        if (n5 == 0) {
            document.insertString(0, new String(stringBuffer), null);
            return;
        }
        if (n4 == 0) {
            document.remove(0, n5);
            return;
        }
        String string = document.getText(0, n5);
        char[] cArray2 = new char[n5];
        string.getChars(0, n5, cArray2, 0);
        char[] cArray3 = new char[n4];
        stringBuffer.getChars(0, n4, cArray3, 0);
        int n11 = cArray2.length - 1;
        int n12 = cArray3.length - 1;
        int n13 = Math.min(n11, n12);
        for (n3 = 0; n3 <= n13 && cArray2[n3] == cArray3[n3]; ++n3) {
        }
        while (n13 > n3 && cArray2[n11] == cArray3[n12]) {
            --n11;
            --n12;
            --n13;
        }
        JBUndoManager jBUndoManager = null;
        if (document instanceof EditorDocument) {
            jBUndoManager = ((EditorDocument)document).getUndoManager();
            jBUndoManager.startUndoGroup(n3, n3);
        }
        if (n11 >= n3) {
            document.remove(n3, n11 - n3 + 1);
        }
        if (n12 >= n3) {
            String string2 = new String(cArray3, n3, n12 - n3 + 1);
            document.insertString(n3, string2, null);
        }
        if (jBUndoManager != null) {
            jBUndoManager.endUndoGroup(n3, n3);
        }
    }

    public void read(Reader reader, Document document, int n2) throws IOException, BadLocationException {
        this.read(null, reader, document, n2);
    }

    public void write(Node node, OutputStream outputStream, Document document, int n2, int n3) throws IOException, BadLocationException {
        this.write(node, new OutputStreamWriter(outputStream), document, n2, n3);
    }

    public void write(OutputStream outputStream, Document document, int n2, int n3) throws IOException, BadLocationException {
        this.write(null, outputStream, document, n2, n3);
    }

    public void read(Node node, InputStream inputStream, Document document, int n2) throws IOException, BadLocationException {
        this.read(node, new InputStreamReader(inputStream), document, n2);
    }

    public void read(InputStream inputStream, Document document, int n2) throws IOException, BadLocationException {
        this.read(null, inputStream, document, n2);
    }

    public Caret createCaret() {
        return null;
    }

    public ViewFactory getViewFactory() {
        return new s();
    }

    public Document createDefaultDocument() {
        EditorDocument editorDocument = new EditorDocument();
        editorDocument.setStyleMap(this.getStyleMap());
        editorDocument.setScanner(this.createScanner());
        return editorDocument;
    }

    public Object clone() {
        TextEditorKit textEditorKit = new TextEditorKit();
        return textEditorKit;
    }

    public String getContentType() {
        return "text/plain";
    }

    public void install(JEditorPane jEditorPane) {
        Keymap keymap = this.getKeymap(EditorManager.getKeymapName());
        if (keymap != null) {
            jEditorPane.setKeymap(keymap);
        }
    }

    public Keymap getKeymap(String string) {
        return (Keymap)this.registeredKeymaps.get(string);
    }

    public void registerKeymap(Keymap keymap) {
        this.registeredKeymaps.put(keymap.getName(), keymap);
    }

    public BasicStyleMap getStyleMap() {
        return this.styleMap;
    }

    public Scanner createScanner() {
        return EditorDocument.DEFAULT_SCANNER;
    }

    public TextEditorKit() {
        this.styleMap = new BasicStyleMap();
    }

    public static void initOpenTool(byte by, byte by2) {
        EditorManager.registerEditorKit(new TextEditorKit());
        EditorPane.HighlightMark highlightMark = new EditorPane.HighlightMark();
    }
}

