/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.EditorPane;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;

public class TextUtilities {
    public static final String DEBUGGER_END_DELIMITERS = " ,;:?+-/*(){}[]<>=%&|.!^@#\n\t~";
    public static final String DEBUGGER_START_DELIMITERS = " ,;:?+-/*(){}[]<>=%&|!^@#\n\t~";
    public static final String STANDARD_DELIMITERS = " ,;:?+-/*(){}[]<>=%&|.!^@#\"'\n\t";

    static {
        STANDARD_DELIMITERS = STANDARD_DELIMITERS;
        DEBUGGER_START_DELIMITERS = DEBUGGER_START_DELIMITERS;
        DEBUGGER_END_DELIMITERS = DEBUGGER_END_DELIMITERS;
    }

    public static int getTokenEnd(char[] cArray, int n2, int n3, int n4, String string) {
        int n5 = n3;
        for (int i2 = n2 + n4; i2 < n3; ++i2) {
            if (string.indexOf(cArray[i2]) < 0) continue;
            n5 = i2;
            break;
        }
        return n5;
    }

    public static int getTokenStart(char[] cArray, int n2, int n3, int n4, String string) {
        int n5 = n2;
        for (int i2 = n2 + n4 - 1; i2 >= n2; --i2) {
            if (string.indexOf(cArray[i2]) < 0) continue;
            n5 = i2 + 1;
            break;
        }
        return n5;
    }

    public static String ripTextAt(char[] cArray, int n2, int n3, int n4, String string, String string2) {
        int n5 = TextUtilities.getTokenStart(cArray, n2, n3, n4, string);
        int n6 = TextUtilities.getTokenEnd(cArray, n2, n3, n4, string2);
        return new String(cArray, n5, n6 - n5);
    }

    public static String ripTextAt(char[] cArray, int n2, int n3, int n4, String string) {
        return TextUtilities.ripTextAt(cArray, n2, n3, n4, string, string);
    }

    public static String ripTextAt(EditorPane editorPane, int n2, String string, String string2) {
        try {
            Document document = editorPane.getDocument();
            Element element = document.getDefaultRootElement();
            int n3 = element.getElementIndex(n2);
            Element element2 = element.getElement(n3);
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset();
            Segment segment = new Segment();
            document.getText(n4, n5 - n4, segment);
            if (n2 - n4 > segment.count) {
                n2 = n4 + segment.count;
            }
            String string3 = TextUtilities.ripTextAt(segment.array, segment.offset, segment.offset + segment.count, n2 - n4, string, string2);
            return string3;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            String string4 = null;
            return string4;
        }
    }

    public static String ripTextAt(EditorPane editorPane, int n2, String string) {
        return TextUtilities.ripTextAt(editorPane, n2, string, string);
    }

    public static String ripTextAt(EditorPane editorPane, int n2) {
        return TextUtilities.ripTextAt(editorPane, n2, STANDARD_DELIMITERS);
    }

    public static final int getTabbedTextWidth(Segment segment, FontMetrics fontMetrics, int n2, TabExpander tabExpander, int n3) {
        int n4 = fontMetrics.charWidth(' ');
        int n5 = n2;
        char[] cArray = segment.array;
        int n6 = segment.offset + segment.count;
        for (int i2 = segment.offset; i2 < n6; ++i2) {
            if (cArray[i2] == '\t') {
                if (tabExpander != null) {
                    n5 = (int)tabExpander.nextTabStop(n5, n3 + i2 - segment.offset);
                    continue;
                }
                n5 += n4;
                continue;
            }
            if (cArray[i2] == '\n') continue;
            n5 += fontMetrics.charWidth(cArray[i2]);
        }
        return n5 - n2;
    }

    public static final int drawTabbedText(Segment segment, int n2, int n3, Graphics graphics, TabExpander tabExpander, int n4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.charWidth(' ');
        int n6 = n2;
        char[] cArray = segment.array;
        int n7 = 0;
        int n8 = segment.offset;
        int n9 = segment.offset + segment.count;
        for (int i2 = segment.offset; i2 < n9; ++i2) {
            if (cArray[i2] == '\t') {
                if (n7 > 0) {
                    graphics.drawChars(cArray, n8, n7, n2, n3);
                    n7 = 0;
                }
                n8 = i2 + 1;
                n6 = tabExpander != null ? (int)tabExpander.nextTabStop(n6, n4 + i2 - segment.offset) : (n6 += n5);
                n2 = n6;
                continue;
            }
            if (cArray[i2] == '\n' || cArray[i2] == '\r') {
                if (n7 > 0) {
                    graphics.drawChars(cArray, n8, n7, n2, n3);
                    n7 = 0;
                }
                n8 = i2 + 1;
                n2 = n6;
                continue;
            }
            ++n7;
            n6 += fontMetrics.charWidth(cArray[i2]);
        }
        if (n7 > 0) {
            graphics.drawChars(cArray, n8, n7, n2, n3);
        }
        return n6;
    }

    protected static final boolean isSkipCharacter(char c2, boolean bl) {
        if (Character.isWhitespace(c2)) {
            return true;
        }
        switch (c2) {
            case '!': 
            case '\"': 
            case '#': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
            case '_': {
                return bl;
            }
        }
        return false;
    }

    public static int getTabbedTextPosition(Segment segment, int n2, int n3) {
        int n4 = 0;
        if (n3 > segment.count) {
            n3 = segment.count;
        }
        for (int i2 = segment.offset; i2 < segment.offset + n3; ++i2) {
            if (segment.array[i2] == '\t') {
                n4 += n2 - n4 % n2;
                continue;
            }
            ++n4;
        }
        return n4;
    }

    public static int getTabbedTextPosition(char[] cArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < cArray.length && i2 < n3; ++i2) {
            if (cArray[i2] == '\t') {
                n4 += n2 - n4 % n2;
                continue;
            }
            ++n4;
        }
        return n4;
    }

    public static int getTabbedTextPosition(String string, int n2, int n3) {
        return TextUtilities.getTabbedTextPosition(string.toCharArray(), n2, n3);
    }

    public static int getTabbedTextPosition(JTextComponent jTextComponent, Element element, int n2, int n3) throws BadLocationException {
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        int n6 = n5 - n4;
        if (n6 <= 0) {
            return 0;
        }
        Segment segment = new Segment();
        jTextComponent.getDocument().getText(n4, n6, segment);
        char[] cArray = new char[n6];
        System.arraycopy(segment.array, segment.offset, cArray, 0, n6);
        return TextUtilities.getTabbedTextPosition(cArray, n2, n3);
    }

    public static boolean isBlankLine(char[] cArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (Character.isWhitespace(cArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankLine(char[] cArray) {
        return TextUtilities.isBlankLine(cArray, 0, cArray.length);
    }

    public static boolean isBlankLine(JTextComponent jTextComponent, Element element) throws BadLocationException {
        int n2;
        int n3 = element.getStartOffset();
        if (n3 >= (n2 = element.getEndOffset())) {
            return true;
        }
        String string = jTextComponent.getText(n3, n2 - n3);
        return TextUtilities.isBlankLine(string.toCharArray());
    }

    public static final Element getLineElement(JTextComponent jTextComponent, int n2) {
        int n3;
        Element element;
        Element element2;
        Document document = jTextComponent.getDocument();
        if (n2 > document.getLength()) {
            n2 = document.getLength();
        }
        if (n2 >= (element2 = (element = document.getDefaultRootElement()).getElement(n3 = element.getElementIndex(n2))).getStartOffset() && n2 < element2.getEndOffset()) {
            return element2;
        }
        return null;
    }

    public static final int getPreviousWord(JTextComponent jTextComponent, int n2) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        Element element = TextUtilities.getLineElement(jTextComponent, n2);
        boolean bl = false;
        int n3 = element.getStartOffset();
        int n4 = Math.min(element.getEndOffset(), document.getLength());
        if (n2 == n3) {
            return n2 == 0 ? 0 : n2 - 1;
        }
        String string = document.getText(n3, n4 - n3);
        if (string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(cArray[n2 - n3 - 1]);
            for (int i2 = n2 - n3 - 1; i2 >= 0; --i2) {
                if (bl) {
                    if (Character.UnicodeBlock.of(cArray[i2]) != unicodeBlock) {
                        return n3 + i2 + 1;
                    }
                    if (!TextUtilities.isSkipCharacter(cArray[i2], false)) continue;
                    return n3 + i2 + 1;
                }
                if (Character.UnicodeBlock.of(cArray[i2]) != unicodeBlock) {
                    return n3 + i2 + 1;
                }
                if (TextUtilities.isSkipCharacter(cArray[i2], false)) continue;
                bl = true;
            }
        }
        return bl ? n3 : (n3 > 0 ? n3 - 1 : 0);
    }

    public static final int getNextWord(JTextComponent jTextComponent, int n2) throws BadLocationException {
        String string;
        Document document = jTextComponent.getDocument();
        Element element = TextUtilities.getLineElement(jTextComponent, n2);
        boolean bl = true;
        int n3 = element.getStartOffset();
        int n4 = Math.min(element.getEndOffset(), document.getLength());
        if (n2 == n4 - 1) {
            element = TextUtilities.getLineElement(jTextComponent, ++n2);
            n3 = element.getStartOffset();
            n4 = Math.min(element.getEndOffset(), document.getLength());
            bl = false;
        }
        if ((string = document.getText(n3, n4 - n3)) != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(cArray[n2 - n3]);
            for (int i2 = n2 - n3; i2 < cArray.length; ++i2) {
                if (!bl) {
                    if (TextUtilities.isSkipCharacter(cArray[i2], false)) continue;
                    return n3 + i2;
                }
                if (Character.UnicodeBlock.of(cArray[i2]) != unicodeBlock) {
                    return n3 + i2;
                }
                if (!TextUtilities.isSkipCharacter(cArray[i2], false)) continue;
                bl = false;
            }
        }
        return n4 < document.getLength() ? n4 - 1 : n4;
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n2) throws BadLocationException {
        return TextUtilities.getWordEnd(jTextComponent, n2, true);
    }

    public static final int getWordEnd(JTextComponent jTextComponent, int n2, boolean bl) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        boolean bl2 = false;
        while (n2 < document.getLength()) {
            int n3;
            Element element = TextUtilities.getLineElement(jTextComponent, n2);
            int n4 = element.getStartOffset();
            String string = document.getText(n4, (n3 = Math.min(element.getEndOffset(), document.getLength())) - n4);
            if (string != null && string.length() > 0) {
                char[] cArray = string.toCharArray();
                Character.UnicodeBlock unicodeBlock = null;
                for (int i2 = n2 - n4; i2 < cArray.length; ++i2) {
                    if (bl2) {
                        if (!TextUtilities.isSkipCharacter(cArray[i2], bl) && unicodeBlock == Character.UnicodeBlock.of(cArray[i2])) continue;
                        return n4 + i2;
                    }
                    if (TextUtilities.isSkipCharacter(cArray[i2], bl)) continue;
                    bl2 = true;
                    unicodeBlock = Character.UnicodeBlock.of(cArray[i2]);
                }
            }
            n2 = n3;
        }
        return document.getLength();
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n2) throws BadLocationException {
        return TextUtilities.getWordStart(jTextComponent, n2, true);
    }

    public static final int getWordStart(JTextComponent jTextComponent, int n2, boolean bl) throws BadLocationException {
        Document document = jTextComponent.getDocument();
        boolean bl2 = false;
        while (n2 >= 0) {
            int n3;
            Element element = TextUtilities.getLineElement(jTextComponent, n2);
            int n4 = element.getStartOffset();
            String string = document.getText(n4, (n3 = Math.min(element.getEndOffset(), document.getLength())) - n4);
            if (string != null && string.length() > 0) {
                char[] cArray = string.toCharArray();
                Character.UnicodeBlock unicodeBlock = null;
                for (int i2 = n2 - n4 - 1; i2 >= 0; --i2) {
                    if (bl2) {
                        if (!TextUtilities.isSkipCharacter(cArray[i2], bl) && unicodeBlock == Character.UnicodeBlock.of(cArray[i2])) continue;
                        return n4 + i2 + 1;
                    }
                    if (TextUtilities.isSkipCharacter(cArray[i2], bl)) continue;
                    bl2 = true;
                    unicodeBlock = Character.UnicodeBlock.of(cArray[i2]);
                }
                if (bl2) {
                    return n4;
                }
            }
            n2 = n4 - 1;
        }
        return 0;
    }
}

